/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.Image;
import com.google.cloud.compute.DiskId;
import com.google.cloud.compute.ImageConfiguration;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class DiskImageConfiguration
extends ImageConfiguration {
    private static final long serialVersionUID = 2716403667042981170L;
    private final DiskId sourceDisk;
    private final String sourceDiskId;

    private DiskImageConfiguration(Builder builder) {
        super(builder);
        this.sourceDisk = (DiskId)Preconditions.checkNotNull((Object)builder.sourceDisk);
        this.sourceDiskId = builder.sourceDiskId;
    }

    @Deprecated
    public DiskId sourceDisk() {
        return this.getSourceDisk();
    }

    public DiskId getSourceDisk() {
        return this.sourceDisk;
    }

    @Deprecated
    public String sourceDiskId() {
        return this.getSourceDiskId();
    }

    public String getSourceDiskId() {
        return this.sourceDiskId;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("sourceDisk", (Object)this.sourceDisk).add("sourceDiskId", (Object)this.sourceDiskId);
    }

    public final int hashCode() {
        return Objects.hash(this.baseHashCode(), this.sourceDisk, this.sourceDiskId);
    }

    public final boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(DiskImageConfiguration.class) && this.baseEquals((DiskImageConfiguration)obj);
    }

    @Override
    DiskImageConfiguration setProjectId(String projectId) {
        if (this.sourceDisk.getProject() != null) {
            return this;
        }
        return this.toBuilder().setSourceDisk(this.sourceDisk.setProjectId(projectId)).build();
    }

    @Override
    Image toPb() {
        Image imagePb = super.toPb();
        imagePb.setSourceDisk(this.sourceDisk.getSelfLink());
        imagePb.setSourceDiskId(this.sourceDiskId);
        return imagePb;
    }

    @Deprecated
    public static Builder builder(DiskId sourceDisk) {
        return DiskImageConfiguration.newBuilder(sourceDisk);
    }

    public static Builder newBuilder(DiskId sourceDisk) {
        return new Builder().setSourceDisk(sourceDisk);
    }

    public static DiskImageConfiguration of(DiskId sourceId) {
        return DiskImageConfiguration.newBuilder(sourceId).build();
    }

    static DiskImageConfiguration fromPb(Image imagePb) {
        return new Builder(imagePb).build();
    }

    public static final class Builder
    extends ImageConfiguration.Builder<DiskImageConfiguration, Builder> {
        private DiskId sourceDisk;
        private String sourceDiskId;

        private Builder() {
            super(ImageConfiguration.Type.DISK);
        }

        private Builder(DiskImageConfiguration imageConfiguration) {
            super(imageConfiguration);
            this.sourceDisk = imageConfiguration.sourceDisk;
            this.sourceDiskId = imageConfiguration.sourceDiskId;
        }

        private Builder(Image imagePb) {
            super(ImageConfiguration.Type.DISK, imagePb);
            this.sourceDisk = DiskId.fromUrl(imagePb.getSourceDisk());
            this.sourceDiskId = imagePb.getSourceDiskId();
        }

        @Deprecated
        public Builder sourceDisk(DiskId sourceDisk) {
            return this.setSourceDisk(sourceDisk);
        }

        public Builder setSourceDisk(DiskId sourceDisk) {
            this.sourceDisk = (DiskId)Preconditions.checkNotNull((Object)sourceDisk);
            return this;
        }

        Builder setSourceDiskId(String sourceDiskId) {
            this.sourceDiskId = sourceDiskId;
            return this;
        }

        @Override
        public DiskImageConfiguration build() {
            return new DiskImageConfiguration(this);
        }
    }
}

