/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectGlobalHttpHealthCheckName
implements ResourceName {
    private final String httpHealthCheck;
    private final String project;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/global/httpHealthChecks/{httpHealthCheck}");
    public static final String SERVICE_ADDRESS = "https://www.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectGlobalHttpHealthCheckName(Builder builder) {
        this.httpHealthCheck = (String)Preconditions.checkNotNull((Object)builder.getHttpHealthCheck());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
    }

    public static ProjectGlobalHttpHealthCheckName of(String httpHealthCheck, String project) {
        return ProjectGlobalHttpHealthCheckName.newBuilder().setHttpHealthCheck(httpHealthCheck).setProject(project).build();
    }

    public static String format(String httpHealthCheck, String project) {
        return ProjectGlobalHttpHealthCheckName.of(httpHealthCheck, project).toString();
    }

    public String getHttpHealthCheck() {
        return this.httpHealthCheck;
    }

    public String getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectGlobalHttpHealthCheckName projectGlobalHttpHealthCheckName = this;
            synchronized (projectGlobalHttpHealthCheckName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"httpHealthCheck", (Object)this.httpHealthCheck);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectGlobalHttpHealthCheckName> newFactory() {
        return new ResourceNameFactory<ProjectGlobalHttpHealthCheckName>(){

            public ProjectGlobalHttpHealthCheckName parse(String formattedString) {
                return ProjectGlobalHttpHealthCheckName.parse(formattedString);
            }
        };
    }

    public static ProjectGlobalHttpHealthCheckName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectGlobalHttpHealthCheckName.parse: formattedString not in valid format");
        return ProjectGlobalHttpHealthCheckName.of((String)matchMap.get("httpHealthCheck"), (String)matchMap.get("project"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"httpHealthCheck", this.httpHealthCheck, "project", this.project});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectGlobalHttpHealthCheckName) {
            ProjectGlobalHttpHealthCheckName that = (ProjectGlobalHttpHealthCheckName)o;
            return Objects.equals(this.httpHealthCheck, that.getHttpHealthCheck()) && Objects.equals(this.project, that.getProject());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.httpHealthCheck, this.project);
    }

    public static class Builder {
        private String httpHealthCheck;
        private String project;

        public String getHttpHealthCheck() {
            return this.httpHealthCheck;
        }

        public String getProject() {
            return this.project;
        }

        public Builder setHttpHealthCheck(String httpHealthCheck) {
            this.httpHealthCheck = httpHealthCheck;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectGlobalHttpHealthCheckName projectGlobalHttpHealthCheckName) {
            this.httpHealthCheck = projectGlobalHttpHealthCheckName.httpHealthCheck;
            this.project = projectGlobalHttpHealthCheckName.project;
        }

        public ProjectGlobalHttpHealthCheckName build() {
            return new ProjectGlobalHttpHealthCheckName(this);
        }
    }
}

