/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.ApiMessageHttpRequestFormatter;
import com.google.api.gax.httpjson.ApiMessageHttpResponseParser;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.compute.v1.AggregatedListTargetInstancesHttpRequest;
import com.google.cloud.compute.v1.DeleteTargetInstanceHttpRequest;
import com.google.cloud.compute.v1.GetTargetInstanceHttpRequest;
import com.google.cloud.compute.v1.InsertTargetInstanceHttpRequest;
import com.google.cloud.compute.v1.ListTargetInstancesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectZoneName;
import com.google.cloud.compute.v1.ProjectZoneTargetInstanceName;
import com.google.cloud.compute.v1.TargetInstance;
import com.google.cloud.compute.v1.TargetInstanceAggregatedList;
import com.google.cloud.compute.v1.TargetInstanceClient;
import com.google.cloud.compute.v1.TargetInstanceList;
import com.google.cloud.compute.v1.stub.HttpJsonTargetInstanceCallableFactory;
import com.google.cloud.compute.v1.stub.TargetInstanceStub;
import com.google.cloud.compute.v1.stub.TargetInstanceStubSettings;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonTargetInstanceStub
extends TargetInstanceStub {
    @InternalApi
    public static final ApiMethodDescriptor<AggregatedListTargetInstancesHttpRequest, TargetInstanceAggregatedList> aggregatedListTargetInstancesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.targetInstances.aggregatedList").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/aggregated/targetInstances")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)TargetInstanceAggregatedList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<DeleteTargetInstanceHttpRequest, Operation> deleteTargetInstanceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.targetInstances.delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/targetInstances/{targetInstance}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectZoneTargetInstanceName.newFactory()).setResourceNameField("targetInstance").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetTargetInstanceHttpRequest, TargetInstance> getTargetInstanceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.targetInstances.get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/targetInstances/{targetInstance}")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectZoneTargetInstanceName.newFactory()).setResourceNameField("targetInstance").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)TargetInstance.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<InsertTargetInstanceHttpRequest, Operation> insertTargetInstanceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.targetInstances.insert").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/targetInstances")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectZoneName.newFactory()).setResourceNameField("zone").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ListTargetInstancesHttpRequest, TargetInstanceList> listTargetInstancesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.targetInstances.list").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/targetInstances")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectZoneName.newFactory()).setResourceNameField("zone").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)TargetInstanceList.getDefaultInstance()).build()).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<AggregatedListTargetInstancesHttpRequest, TargetInstanceAggregatedList> aggregatedListTargetInstancesCallable;
    private final UnaryCallable<AggregatedListTargetInstancesHttpRequest, TargetInstanceClient.AggregatedListTargetInstancesPagedResponse> aggregatedListTargetInstancesPagedCallable;
    private final UnaryCallable<DeleteTargetInstanceHttpRequest, Operation> deleteTargetInstanceCallable;
    private final UnaryCallable<GetTargetInstanceHttpRequest, TargetInstance> getTargetInstanceCallable;
    private final UnaryCallable<InsertTargetInstanceHttpRequest, Operation> insertTargetInstanceCallable;
    private final UnaryCallable<ListTargetInstancesHttpRequest, TargetInstanceList> listTargetInstancesCallable;
    private final UnaryCallable<ListTargetInstancesHttpRequest, TargetInstanceClient.ListTargetInstancesPagedResponse> listTargetInstancesPagedCallable;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonTargetInstanceStub create(TargetInstanceStubSettings settings) throws IOException {
        return new HttpJsonTargetInstanceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonTargetInstanceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonTargetInstanceStub(TargetInstanceStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonTargetInstanceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonTargetInstanceStub(TargetInstanceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonTargetInstanceStub(TargetInstanceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonTargetInstanceCallableFactory());
    }

    protected HttpJsonTargetInstanceStub(TargetInstanceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings aggregatedListTargetInstancesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(aggregatedListTargetInstancesMethodDescriptor).build();
        HttpJsonCallSettings deleteTargetInstanceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteTargetInstanceMethodDescriptor).build();
        HttpJsonCallSettings getTargetInstanceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getTargetInstanceMethodDescriptor).build();
        HttpJsonCallSettings insertTargetInstanceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertTargetInstanceMethodDescriptor).build();
        HttpJsonCallSettings listTargetInstancesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listTargetInstancesMethodDescriptor).build();
        this.aggregatedListTargetInstancesCallable = callableFactory.createUnaryCallable(aggregatedListTargetInstancesTransportSettings, settings.aggregatedListTargetInstancesSettings(), clientContext);
        this.aggregatedListTargetInstancesPagedCallable = callableFactory.createPagedCallable(aggregatedListTargetInstancesTransportSettings, settings.aggregatedListTargetInstancesSettings(), clientContext);
        this.deleteTargetInstanceCallable = callableFactory.createUnaryCallable(deleteTargetInstanceTransportSettings, settings.deleteTargetInstanceSettings(), clientContext);
        this.getTargetInstanceCallable = callableFactory.createUnaryCallable(getTargetInstanceTransportSettings, settings.getTargetInstanceSettings(), clientContext);
        this.insertTargetInstanceCallable = callableFactory.createUnaryCallable(insertTargetInstanceTransportSettings, settings.insertTargetInstanceSettings(), clientContext);
        this.listTargetInstancesCallable = callableFactory.createUnaryCallable(listTargetInstancesTransportSettings, settings.listTargetInstancesSettings(), clientContext);
        this.listTargetInstancesPagedCallable = callableFactory.createPagedCallable(listTargetInstancesTransportSettings, settings.listTargetInstancesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    @BetaApi
    public UnaryCallable<AggregatedListTargetInstancesHttpRequest, TargetInstanceClient.AggregatedListTargetInstancesPagedResponse> aggregatedListTargetInstancesPagedCallable() {
        return this.aggregatedListTargetInstancesPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<AggregatedListTargetInstancesHttpRequest, TargetInstanceAggregatedList> aggregatedListTargetInstancesCallable() {
        return this.aggregatedListTargetInstancesCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<DeleteTargetInstanceHttpRequest, Operation> deleteTargetInstanceCallable() {
        return this.deleteTargetInstanceCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetTargetInstanceHttpRequest, TargetInstance> getTargetInstanceCallable() {
        return this.getTargetInstanceCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<InsertTargetInstanceHttpRequest, Operation> insertTargetInstanceCallable() {
        return this.insertTargetInstanceCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListTargetInstancesHttpRequest, TargetInstanceClient.ListTargetInstancesPagedResponse> listTargetInstancesPagedCallable() {
        return this.listTargetInstancesPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListTargetInstancesHttpRequest, TargetInstanceList> listTargetInstancesCallable() {
        return this.listTargetInstancesCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

