/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.UsableSubnetworkSecondaryRange;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class UsableSubnetwork
implements ApiMessage {
    private final String ipCidrRange;
    private final String network;
    private final List<UsableSubnetworkSecondaryRange> secondaryIpRanges;
    private final String subnetwork;
    private static final UsableSubnetwork DEFAULT_INSTANCE = new UsableSubnetwork();

    private UsableSubnetwork() {
        this.ipCidrRange = null;
        this.network = null;
        this.secondaryIpRanges = null;
        this.subnetwork = null;
    }

    private UsableSubnetwork(String ipCidrRange, String network, List<UsableSubnetworkSecondaryRange> secondaryIpRanges, String subnetwork) {
        this.ipCidrRange = ipCidrRange;
        this.network = network;
        this.secondaryIpRanges = secondaryIpRanges;
        this.subnetwork = subnetwork;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("ipCidrRange")) {
            return this.ipCidrRange;
        }
        if (fieldName.equals("network")) {
            return this.network;
        }
        if (fieldName.equals("secondaryIpRanges")) {
            return this.secondaryIpRanges;
        }
        if (fieldName.equals("subnetwork")) {
            return this.subnetwork;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getIpCidrRange() {
        return this.ipCidrRange;
    }

    public String getNetwork() {
        return this.network;
    }

    public List<UsableSubnetworkSecondaryRange> getSecondaryIpRangesList() {
        return this.secondaryIpRanges;
    }

    public String getSubnetwork() {
        return this.subnetwork;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(UsableSubnetwork prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static UsableSubnetwork getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "UsableSubnetwork{ipCidrRange=" + this.ipCidrRange + ", network=" + this.network + ", secondaryIpRanges=" + this.secondaryIpRanges + ", subnetwork=" + this.subnetwork + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof UsableSubnetwork) {
            UsableSubnetwork that = (UsableSubnetwork)o;
            return Objects.equals(this.ipCidrRange, that.getIpCidrRange()) && Objects.equals(this.network, that.getNetwork()) && Objects.equals(this.secondaryIpRanges, that.getSecondaryIpRangesList()) && Objects.equals(this.subnetwork, that.getSubnetwork());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.ipCidrRange, this.network, this.secondaryIpRanges, this.subnetwork);
    }

    public static class Builder {
        private String ipCidrRange;
        private String network;
        private List<UsableSubnetworkSecondaryRange> secondaryIpRanges;
        private String subnetwork;

        Builder() {
        }

        public Builder mergeFrom(UsableSubnetwork other) {
            if (other == UsableSubnetwork.getDefaultInstance()) {
                return this;
            }
            if (other.getIpCidrRange() != null) {
                this.ipCidrRange = other.ipCidrRange;
            }
            if (other.getNetwork() != null) {
                this.network = other.network;
            }
            if (other.getSecondaryIpRangesList() != null) {
                this.secondaryIpRanges = other.secondaryIpRanges;
            }
            if (other.getSubnetwork() != null) {
                this.subnetwork = other.subnetwork;
            }
            return this;
        }

        Builder(UsableSubnetwork source) {
            this.ipCidrRange = source.ipCidrRange;
            this.network = source.network;
            this.secondaryIpRanges = source.secondaryIpRanges;
            this.subnetwork = source.subnetwork;
        }

        public String getIpCidrRange() {
            return this.ipCidrRange;
        }

        public Builder setIpCidrRange(String ipCidrRange) {
            this.ipCidrRange = ipCidrRange;
            return this;
        }

        public String getNetwork() {
            return this.network;
        }

        public Builder setNetwork(String network) {
            this.network = network;
            return this;
        }

        public List<UsableSubnetworkSecondaryRange> getSecondaryIpRangesList() {
            return this.secondaryIpRanges;
        }

        public Builder addAllSecondaryIpRanges(List<UsableSubnetworkSecondaryRange> secondaryIpRanges) {
            if (this.secondaryIpRanges == null) {
                this.secondaryIpRanges = new LinkedList<UsableSubnetworkSecondaryRange>();
            }
            this.secondaryIpRanges.addAll(secondaryIpRanges);
            return this;
        }

        public Builder addSecondaryIpRanges(UsableSubnetworkSecondaryRange secondaryIpRanges) {
            if (this.secondaryIpRanges == null) {
                this.secondaryIpRanges = new LinkedList<UsableSubnetworkSecondaryRange>();
            }
            this.secondaryIpRanges.add(secondaryIpRanges);
            return this;
        }

        public String getSubnetwork() {
            return this.subnetwork;
        }

        public Builder setSubnetwork(String subnetwork) {
            this.subnetwork = subnetwork;
            return this;
        }

        public UsableSubnetwork build() {
            return new UsableSubnetwork(this.ipCidrRange, this.network, this.secondaryIpRanges, this.subnetwork);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setIpCidrRange(this.ipCidrRange);
            newBuilder.setNetwork(this.network);
            newBuilder.addAllSecondaryIpRanges(this.secondaryIpRanges);
            newBuilder.setSubnetwork(this.subnetwork);
            return newBuilder;
        }
    }
}

