/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.TargetInstance;
import com.google.cloud.compute.v1.Warning;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class TargetInstancesScopedList
implements ApiMessage {
    private final List<TargetInstance> targetInstances;
    private final Warning warning;
    private static final TargetInstancesScopedList DEFAULT_INSTANCE = new TargetInstancesScopedList();

    private TargetInstancesScopedList() {
        this.targetInstances = null;
        this.warning = null;
    }

    private TargetInstancesScopedList(List<TargetInstance> targetInstances, Warning warning) {
        this.targetInstances = targetInstances;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("targetInstances")) {
            return this.targetInstances;
        }
        if (fieldName.equals("warning")) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<TargetInstance> getTargetInstancesList() {
        return this.targetInstances;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(TargetInstancesScopedList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static TargetInstancesScopedList getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "TargetInstancesScopedList{targetInstances=" + this.targetInstances + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TargetInstancesScopedList) {
            TargetInstancesScopedList that = (TargetInstancesScopedList)o;
            return Objects.equals(this.targetInstances, that.getTargetInstancesList()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.targetInstances, this.warning);
    }

    public static class Builder {
        private List<TargetInstance> targetInstances;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(TargetInstancesScopedList other) {
            if (other == TargetInstancesScopedList.getDefaultInstance()) {
                return this;
            }
            if (other.getTargetInstancesList() != null) {
                this.targetInstances = other.targetInstances;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(TargetInstancesScopedList source) {
            this.targetInstances = source.targetInstances;
            this.warning = source.warning;
        }

        public List<TargetInstance> getTargetInstancesList() {
            return this.targetInstances;
        }

        public Builder addAllTargetInstances(List<TargetInstance> targetInstances) {
            if (this.targetInstances == null) {
                this.targetInstances = new LinkedList<TargetInstance>();
            }
            this.targetInstances.addAll(targetInstances);
            return this;
        }

        public Builder addTargetInstances(TargetInstance targetInstances) {
            if (this.targetInstances == null) {
                this.targetInstances = new LinkedList<TargetInstance>();
            }
            this.targetInstances.add(targetInstances);
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public TargetInstancesScopedList build() {
            return new TargetInstancesScopedList(this.targetInstances, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllTargetInstances(this.targetInstances);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

