/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.Router;
import com.google.cloud.compute.v1.Warning;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class RoutersScopedList
implements ApiMessage {
    private final List<Router> routers;
    private final Warning warning;
    private static final RoutersScopedList DEFAULT_INSTANCE = new RoutersScopedList();

    private RoutersScopedList() {
        this.routers = null;
        this.warning = null;
    }

    private RoutersScopedList(List<Router> routers, Warning warning) {
        this.routers = routers;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("routers")) {
            return this.routers;
        }
        if (fieldName.equals("warning")) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<Router> getRoutersList() {
        return this.routers;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(RoutersScopedList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static RoutersScopedList getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "RoutersScopedList{routers=" + this.routers + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RoutersScopedList) {
            RoutersScopedList that = (RoutersScopedList)o;
            return Objects.equals(this.routers, that.getRoutersList()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.routers, this.warning);
    }

    public static class Builder {
        private List<Router> routers;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(RoutersScopedList other) {
            if (other == RoutersScopedList.getDefaultInstance()) {
                return this;
            }
            if (other.getRoutersList() != null) {
                this.routers = other.routers;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(RoutersScopedList source) {
            this.routers = source.routers;
            this.warning = source.warning;
        }

        public List<Router> getRoutersList() {
            return this.routers;
        }

        public Builder addAllRouters(List<Router> routers) {
            if (this.routers == null) {
                this.routers = new LinkedList<Router>();
            }
            this.routers.addAll(routers);
            return this;
        }

        public Builder addRouters(Router routers) {
            if (this.routers == null) {
                this.routers = new LinkedList<Router>();
            }
            this.routers.add(routers);
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public RoutersScopedList build() {
            return new RoutersScopedList(this.routers, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllRouters(this.routers);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

