/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class RawDisk
implements ApiMessage {
    private final String containerType;
    private final String sha1Checksum;
    private final String source;
    private static final RawDisk DEFAULT_INSTANCE = new RawDisk();

    private RawDisk() {
        this.containerType = null;
        this.sha1Checksum = null;
        this.source = null;
    }

    private RawDisk(String containerType, String sha1Checksum, String source) {
        this.containerType = containerType;
        this.sha1Checksum = sha1Checksum;
        this.source = source;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("containerType")) {
            return this.containerType;
        }
        if (fieldName.equals("sha1Checksum")) {
            return this.sha1Checksum;
        }
        if (fieldName.equals("source")) {
            return this.source;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getContainerType() {
        return this.containerType;
    }

    public String getSha1Checksum() {
        return this.sha1Checksum;
    }

    public String getSource() {
        return this.source;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(RawDisk prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static RawDisk getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "RawDisk{containerType=" + this.containerType + ", sha1Checksum=" + this.sha1Checksum + ", source=" + this.source + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RawDisk) {
            RawDisk that = (RawDisk)o;
            return Objects.equals(this.containerType, that.getContainerType()) && Objects.equals(this.sha1Checksum, that.getSha1Checksum()) && Objects.equals(this.source, that.getSource());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.containerType, this.sha1Checksum, this.source);
    }

    public static class Builder {
        private String containerType;
        private String sha1Checksum;
        private String source;

        Builder() {
        }

        public Builder mergeFrom(RawDisk other) {
            if (other == RawDisk.getDefaultInstance()) {
                return this;
            }
            if (other.getContainerType() != null) {
                this.containerType = other.containerType;
            }
            if (other.getSha1Checksum() != null) {
                this.sha1Checksum = other.sha1Checksum;
            }
            if (other.getSource() != null) {
                this.source = other.source;
            }
            return this;
        }

        Builder(RawDisk source) {
            this.containerType = source.containerType;
            this.sha1Checksum = source.sha1Checksum;
            this.source = source.source;
        }

        public String getContainerType() {
            return this.containerType;
        }

        public Builder setContainerType(String containerType) {
            this.containerType = containerType;
            return this;
        }

        public String getSha1Checksum() {
            return this.sha1Checksum;
        }

        public Builder setSha1Checksum(String sha1Checksum) {
            this.sha1Checksum = sha1Checksum;
            return this;
        }

        public String getSource() {
            return this.source;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        public RawDisk build() {
            return new RawDisk(this.containerType, this.sha1Checksum, this.source);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setContainerType(this.containerType);
            newBuilder.setSha1Checksum(this.sha1Checksum);
            newBuilder.setSource(this.source);
            return newBuilder;
        }
    }
}

