/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectZoneNodeTypeName
implements ResourceName {
    private final String nodeType;
    private final String project;
    private final String zone;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/zones/{zone}/nodeTypes/{nodeType}");
    public static final String SERVICE_ADDRESS = "https://www.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectZoneNodeTypeName(Builder builder) {
        this.nodeType = (String)Preconditions.checkNotNull((Object)builder.getNodeType());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.zone = (String)Preconditions.checkNotNull((Object)builder.getZone());
    }

    public static ProjectZoneNodeTypeName of(String nodeType, String project, String zone) {
        return ProjectZoneNodeTypeName.newBuilder().setNodeType(nodeType).setProject(project).setZone(zone).build();
    }

    public static String format(String nodeType, String project, String zone) {
        return ProjectZoneNodeTypeName.of(nodeType, project, zone).toString();
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public String getProject() {
        return this.project;
    }

    public String getZone() {
        return this.zone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectZoneNodeTypeName projectZoneNodeTypeName = this;
            synchronized (projectZoneNodeTypeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"nodeType", (Object)this.nodeType);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"zone", (Object)this.zone);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectZoneNodeTypeName> newFactory() {
        return new ResourceNameFactory<ProjectZoneNodeTypeName>(){

            public ProjectZoneNodeTypeName parse(String formattedString) {
                return ProjectZoneNodeTypeName.parse(formattedString);
            }
        };
    }

    public static ProjectZoneNodeTypeName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectZoneNodeTypeName.parse: formattedString not in valid format");
        return ProjectZoneNodeTypeName.of((String)matchMap.get("nodeType"), (String)matchMap.get("project"), (String)matchMap.get("zone"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"nodeType", this.nodeType, "project", this.project, "zone", this.zone});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectZoneNodeTypeName) {
            ProjectZoneNodeTypeName that = (ProjectZoneNodeTypeName)o;
            return Objects.equals(this.nodeType, that.getNodeType()) && Objects.equals(this.project, that.getProject()) && Objects.equals(this.zone, that.getZone());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.nodeType, this.project, this.zone);
    }

    public static class Builder {
        private String nodeType;
        private String project;
        private String zone;

        public String getNodeType() {
            return this.nodeType;
        }

        public String getProject() {
            return this.project;
        }

        public String getZone() {
            return this.zone;
        }

        public Builder setNodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectZoneNodeTypeName projectZoneNodeTypeName) {
            this.nodeType = projectZoneNodeTypeName.nodeType;
            this.project = projectZoneNodeTypeName.project;
            this.zone = projectZoneNodeTypeName.zone;
        }

        public ProjectZoneNodeTypeName build() {
            return new ProjectZoneNodeTypeName(this);
        }
    }
}

