/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectZoneMachineTypeName
implements ResourceName {
    private final String machineType;
    private final String project;
    private final String zone;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/zones/{zone}/machineTypes/{machineType}");
    public static final String SERVICE_ADDRESS = "https://www.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectZoneMachineTypeName(Builder builder) {
        this.machineType = (String)Preconditions.checkNotNull((Object)builder.getMachineType());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.zone = (String)Preconditions.checkNotNull((Object)builder.getZone());
    }

    public static ProjectZoneMachineTypeName of(String machineType, String project, String zone) {
        return ProjectZoneMachineTypeName.newBuilder().setMachineType(machineType).setProject(project).setZone(zone).build();
    }

    public static String format(String machineType, String project, String zone) {
        return ProjectZoneMachineTypeName.of(machineType, project, zone).toString();
    }

    public String getMachineType() {
        return this.machineType;
    }

    public String getProject() {
        return this.project;
    }

    public String getZone() {
        return this.zone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectZoneMachineTypeName projectZoneMachineTypeName = this;
            synchronized (projectZoneMachineTypeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"machineType", (Object)this.machineType);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"zone", (Object)this.zone);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectZoneMachineTypeName> newFactory() {
        return new ResourceNameFactory<ProjectZoneMachineTypeName>(){

            public ProjectZoneMachineTypeName parse(String formattedString) {
                return ProjectZoneMachineTypeName.parse(formattedString);
            }
        };
    }

    public static ProjectZoneMachineTypeName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectZoneMachineTypeName.parse: formattedString not in valid format");
        return ProjectZoneMachineTypeName.of((String)matchMap.get("machineType"), (String)matchMap.get("project"), (String)matchMap.get("zone"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"machineType", this.machineType, "project", this.project, "zone", this.zone});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectZoneMachineTypeName) {
            ProjectZoneMachineTypeName that = (ProjectZoneMachineTypeName)o;
            return Objects.equals(this.machineType, that.getMachineType()) && Objects.equals(this.project, that.getProject()) && Objects.equals(this.zone, that.getZone());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.machineType, this.project, this.zone);
    }

    public static class Builder {
        private String machineType;
        private String project;
        private String zone;

        public String getMachineType() {
            return this.machineType;
        }

        public String getProject() {
            return this.project;
        }

        public String getZone() {
            return this.zone;
        }

        public Builder setMachineType(String machineType) {
            this.machineType = machineType;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectZoneMachineTypeName projectZoneMachineTypeName) {
            this.machineType = projectZoneMachineTypeName.machineType;
            this.project = projectZoneMachineTypeName.project;
            this.zone = projectZoneMachineTypeName.zone;
        }

        public ProjectZoneMachineTypeName build() {
            return new ProjectZoneMachineTypeName(this);
        }
    }
}

