/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.Disk;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InsertRegionDiskHttpRequest
implements ApiMessage {
    private final String access_token;
    private final String callback;
    private final Disk diskResource;
    private final String fields;
    private final String key;
    private final String prettyPrint;
    private final String quotaUser;
    private final String region;
    private final String requestId;
    private final String sourceImage;
    private final String userIp;
    private static final InsertRegionDiskHttpRequest DEFAULT_INSTANCE = new InsertRegionDiskHttpRequest();

    private InsertRegionDiskHttpRequest() {
        this.access_token = null;
        this.callback = null;
        this.diskResource = null;
        this.fields = null;
        this.key = null;
        this.prettyPrint = null;
        this.quotaUser = null;
        this.region = null;
        this.requestId = null;
        this.sourceImage = null;
        this.userIp = null;
    }

    private InsertRegionDiskHttpRequest(String access_token, String callback, Disk diskResource, String fields, String key, String prettyPrint, String quotaUser, String region, String requestId, String sourceImage, String userIp) {
        this.access_token = access_token;
        this.callback = callback;
        this.diskResource = diskResource;
        this.fields = fields;
        this.key = key;
        this.prettyPrint = prettyPrint;
        this.quotaUser = quotaUser;
        this.region = region;
        this.requestId = requestId;
        this.sourceImage = sourceImage;
        this.userIp = userIp;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("access_token")) {
            return this.access_token;
        }
        if (fieldName.equals("callback")) {
            return this.callback;
        }
        if (fieldName.equals("diskResource")) {
            return this.diskResource;
        }
        if (fieldName.equals("fields")) {
            return this.fields;
        }
        if (fieldName.equals("key")) {
            return this.key;
        }
        if (fieldName.equals("prettyPrint")) {
            return this.prettyPrint;
        }
        if (fieldName.equals("quotaUser")) {
            return this.quotaUser;
        }
        if (fieldName.equals("region")) {
            return this.region;
        }
        if (fieldName.equals("requestId")) {
            return this.requestId;
        }
        if (fieldName.equals("sourceImage")) {
            return this.sourceImage;
        }
        if (fieldName.equals("userIp")) {
            return this.userIp;
        }
        return null;
    }

    @Nullable
    public Disk getApiMessageRequestBody() {
        return this.diskResource;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getAccessToken() {
        return this.access_token;
    }

    public String getCallback() {
        return this.callback;
    }

    public Disk getDiskResource() {
        return this.diskResource;
    }

    public String getFields() {
        return this.fields;
    }

    public String getKey() {
        return this.key;
    }

    public String getPrettyPrint() {
        return this.prettyPrint;
    }

    public String getQuotaUser() {
        return this.quotaUser;
    }

    public String getRegion() {
        return this.region;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getSourceImage() {
        return this.sourceImage;
    }

    public String getUserIp() {
        return this.userIp;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InsertRegionDiskHttpRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InsertRegionDiskHttpRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InsertRegionDiskHttpRequest{access_token=" + this.access_token + ", callback=" + this.callback + ", diskResource=" + this.diskResource + ", fields=" + this.fields + ", key=" + this.key + ", prettyPrint=" + this.prettyPrint + ", quotaUser=" + this.quotaUser + ", region=" + this.region + ", requestId=" + this.requestId + ", sourceImage=" + this.sourceImage + ", userIp=" + this.userIp + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InsertRegionDiskHttpRequest) {
            InsertRegionDiskHttpRequest that = (InsertRegionDiskHttpRequest)o;
            return Objects.equals(this.access_token, that.getAccessToken()) && Objects.equals(this.callback, that.getCallback()) && Objects.equals(this.diskResource, that.getDiskResource()) && Objects.equals(this.fields, that.getFields()) && Objects.equals(this.key, that.getKey()) && Objects.equals(this.prettyPrint, that.getPrettyPrint()) && Objects.equals(this.quotaUser, that.getQuotaUser()) && Objects.equals(this.region, that.getRegion()) && Objects.equals(this.requestId, that.getRequestId()) && Objects.equals(this.sourceImage, that.getSourceImage()) && Objects.equals(this.userIp, that.getUserIp());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.access_token, this.callback, this.diskResource, this.fields, this.key, this.prettyPrint, this.quotaUser, this.region, this.requestId, this.sourceImage, this.userIp);
    }

    public static class Builder {
        private String access_token;
        private String callback;
        private Disk diskResource;
        private String fields;
        private String key;
        private String prettyPrint;
        private String quotaUser;
        private String region;
        private String requestId;
        private String sourceImage;
        private String userIp;

        Builder() {
        }

        public Builder mergeFrom(InsertRegionDiskHttpRequest other) {
            if (other == InsertRegionDiskHttpRequest.getDefaultInstance()) {
                return this;
            }
            if (other.getAccessToken() != null) {
                this.access_token = other.access_token;
            }
            if (other.getCallback() != null) {
                this.callback = other.callback;
            }
            if (other.getDiskResource() != null) {
                this.diskResource = other.diskResource;
            }
            if (other.getFields() != null) {
                this.fields = other.fields;
            }
            if (other.getKey() != null) {
                this.key = other.key;
            }
            if (other.getPrettyPrint() != null) {
                this.prettyPrint = other.prettyPrint;
            }
            if (other.getQuotaUser() != null) {
                this.quotaUser = other.quotaUser;
            }
            if (other.getRegion() != null) {
                this.region = other.region;
            }
            if (other.getRequestId() != null) {
                this.requestId = other.requestId;
            }
            if (other.getSourceImage() != null) {
                this.sourceImage = other.sourceImage;
            }
            if (other.getUserIp() != null) {
                this.userIp = other.userIp;
            }
            return this;
        }

        Builder(InsertRegionDiskHttpRequest source) {
            this.access_token = source.access_token;
            this.callback = source.callback;
            this.diskResource = source.diskResource;
            this.fields = source.fields;
            this.key = source.key;
            this.prettyPrint = source.prettyPrint;
            this.quotaUser = source.quotaUser;
            this.region = source.region;
            this.requestId = source.requestId;
            this.sourceImage = source.sourceImage;
            this.userIp = source.userIp;
        }

        public String getAccessToken() {
            return this.access_token;
        }

        public Builder setAccessToken(String access_token) {
            this.access_token = access_token;
            return this;
        }

        public String getCallback() {
            return this.callback;
        }

        public Builder setCallback(String callback) {
            this.callback = callback;
            return this;
        }

        public Disk getDiskResource() {
            return this.diskResource;
        }

        public Builder setDiskResource(Disk diskResource) {
            this.diskResource = diskResource;
            return this;
        }

        public String getFields() {
            return this.fields;
        }

        public Builder setFields(String fields) {
            this.fields = fields;
            return this;
        }

        public String getKey() {
            return this.key;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public String getPrettyPrint() {
            return this.prettyPrint;
        }

        public Builder setPrettyPrint(String prettyPrint) {
            this.prettyPrint = prettyPrint;
            return this;
        }

        public String getQuotaUser() {
            return this.quotaUser;
        }

        public Builder setQuotaUser(String quotaUser) {
            this.quotaUser = quotaUser;
            return this;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public Builder setRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public String getSourceImage() {
            return this.sourceImage;
        }

        public Builder setSourceImage(String sourceImage) {
            this.sourceImage = sourceImage;
            return this;
        }

        public String getUserIp() {
            return this.userIp;
        }

        public Builder setUserIp(String userIp) {
            this.userIp = userIp;
            return this;
        }

        public InsertRegionDiskHttpRequest build() {
            String missing = "";
            if (this.region == null) {
                missing = missing + " region";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new InsertRegionDiskHttpRequest(this.access_token, this.callback, this.diskResource, this.fields, this.key, this.prettyPrint, this.quotaUser, this.region, this.requestId, this.sourceImage, this.userIp);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setAccessToken(this.access_token);
            newBuilder.setCallback(this.callback);
            newBuilder.setDiskResource(this.diskResource);
            newBuilder.setFields(this.fields);
            newBuilder.setKey(this.key);
            newBuilder.setPrettyPrint(this.prettyPrint);
            newBuilder.setQuotaUser(this.quotaUser);
            newBuilder.setRegion(this.region);
            newBuilder.setRequestId(this.requestId);
            newBuilder.setSourceImage(this.sourceImage);
            newBuilder.setUserIp(this.userIp);
            return newBuilder;
        }
    }
}

