/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.Instance;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InsertInstanceHttpRequest
implements ApiMessage {
    private final String access_token;
    private final String callback;
    private final String fields;
    private final Instance instanceResource;
    private final String key;
    private final String prettyPrint;
    private final String quotaUser;
    private final String requestId;
    private final String sourceInstanceTemplate;
    private final String userIp;
    private final String zone;
    private static final InsertInstanceHttpRequest DEFAULT_INSTANCE = new InsertInstanceHttpRequest();

    private InsertInstanceHttpRequest() {
        this.access_token = null;
        this.callback = null;
        this.fields = null;
        this.instanceResource = null;
        this.key = null;
        this.prettyPrint = null;
        this.quotaUser = null;
        this.requestId = null;
        this.sourceInstanceTemplate = null;
        this.userIp = null;
        this.zone = null;
    }

    private InsertInstanceHttpRequest(String access_token, String callback, String fields, Instance instanceResource, String key, String prettyPrint, String quotaUser, String requestId, String sourceInstanceTemplate, String userIp, String zone) {
        this.access_token = access_token;
        this.callback = callback;
        this.fields = fields;
        this.instanceResource = instanceResource;
        this.key = key;
        this.prettyPrint = prettyPrint;
        this.quotaUser = quotaUser;
        this.requestId = requestId;
        this.sourceInstanceTemplate = sourceInstanceTemplate;
        this.userIp = userIp;
        this.zone = zone;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("access_token")) {
            return this.access_token;
        }
        if (fieldName.equals("callback")) {
            return this.callback;
        }
        if (fieldName.equals("fields")) {
            return this.fields;
        }
        if (fieldName.equals("instanceResource")) {
            return this.instanceResource;
        }
        if (fieldName.equals("key")) {
            return this.key;
        }
        if (fieldName.equals("prettyPrint")) {
            return this.prettyPrint;
        }
        if (fieldName.equals("quotaUser")) {
            return this.quotaUser;
        }
        if (fieldName.equals("requestId")) {
            return this.requestId;
        }
        if (fieldName.equals("sourceInstanceTemplate")) {
            return this.sourceInstanceTemplate;
        }
        if (fieldName.equals("userIp")) {
            return this.userIp;
        }
        if (fieldName.equals("zone")) {
            return this.zone;
        }
        return null;
    }

    @Nullable
    public Instance getApiMessageRequestBody() {
        return this.instanceResource;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getAccessToken() {
        return this.access_token;
    }

    public String getCallback() {
        return this.callback;
    }

    public String getFields() {
        return this.fields;
    }

    public Instance getInstanceResource() {
        return this.instanceResource;
    }

    public String getKey() {
        return this.key;
    }

    public String getPrettyPrint() {
        return this.prettyPrint;
    }

    public String getQuotaUser() {
        return this.quotaUser;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getSourceInstanceTemplate() {
        return this.sourceInstanceTemplate;
    }

    public String getUserIp() {
        return this.userIp;
    }

    public String getZone() {
        return this.zone;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InsertInstanceHttpRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InsertInstanceHttpRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InsertInstanceHttpRequest{access_token=" + this.access_token + ", callback=" + this.callback + ", fields=" + this.fields + ", instanceResource=" + this.instanceResource + ", key=" + this.key + ", prettyPrint=" + this.prettyPrint + ", quotaUser=" + this.quotaUser + ", requestId=" + this.requestId + ", sourceInstanceTemplate=" + this.sourceInstanceTemplate + ", userIp=" + this.userIp + ", zone=" + this.zone + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InsertInstanceHttpRequest) {
            InsertInstanceHttpRequest that = (InsertInstanceHttpRequest)o;
            return Objects.equals(this.access_token, that.getAccessToken()) && Objects.equals(this.callback, that.getCallback()) && Objects.equals(this.fields, that.getFields()) && Objects.equals(this.instanceResource, that.getInstanceResource()) && Objects.equals(this.key, that.getKey()) && Objects.equals(this.prettyPrint, that.getPrettyPrint()) && Objects.equals(this.quotaUser, that.getQuotaUser()) && Objects.equals(this.requestId, that.getRequestId()) && Objects.equals(this.sourceInstanceTemplate, that.getSourceInstanceTemplate()) && Objects.equals(this.userIp, that.getUserIp()) && Objects.equals(this.zone, that.getZone());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.access_token, this.callback, this.fields, this.instanceResource, this.key, this.prettyPrint, this.quotaUser, this.requestId, this.sourceInstanceTemplate, this.userIp, this.zone);
    }

    public static class Builder {
        private String access_token;
        private String callback;
        private String fields;
        private Instance instanceResource;
        private String key;
        private String prettyPrint;
        private String quotaUser;
        private String requestId;
        private String sourceInstanceTemplate;
        private String userIp;
        private String zone;

        Builder() {
        }

        public Builder mergeFrom(InsertInstanceHttpRequest other) {
            if (other == InsertInstanceHttpRequest.getDefaultInstance()) {
                return this;
            }
            if (other.getAccessToken() != null) {
                this.access_token = other.access_token;
            }
            if (other.getCallback() != null) {
                this.callback = other.callback;
            }
            if (other.getFields() != null) {
                this.fields = other.fields;
            }
            if (other.getInstanceResource() != null) {
                this.instanceResource = other.instanceResource;
            }
            if (other.getKey() != null) {
                this.key = other.key;
            }
            if (other.getPrettyPrint() != null) {
                this.prettyPrint = other.prettyPrint;
            }
            if (other.getQuotaUser() != null) {
                this.quotaUser = other.quotaUser;
            }
            if (other.getRequestId() != null) {
                this.requestId = other.requestId;
            }
            if (other.getSourceInstanceTemplate() != null) {
                this.sourceInstanceTemplate = other.sourceInstanceTemplate;
            }
            if (other.getUserIp() != null) {
                this.userIp = other.userIp;
            }
            if (other.getZone() != null) {
                this.zone = other.zone;
            }
            return this;
        }

        Builder(InsertInstanceHttpRequest source) {
            this.access_token = source.access_token;
            this.callback = source.callback;
            this.fields = source.fields;
            this.instanceResource = source.instanceResource;
            this.key = source.key;
            this.prettyPrint = source.prettyPrint;
            this.quotaUser = source.quotaUser;
            this.requestId = source.requestId;
            this.sourceInstanceTemplate = source.sourceInstanceTemplate;
            this.userIp = source.userIp;
            this.zone = source.zone;
        }

        public String getAccessToken() {
            return this.access_token;
        }

        public Builder setAccessToken(String access_token) {
            this.access_token = access_token;
            return this;
        }

        public String getCallback() {
            return this.callback;
        }

        public Builder setCallback(String callback) {
            this.callback = callback;
            return this;
        }

        public String getFields() {
            return this.fields;
        }

        public Builder setFields(String fields) {
            this.fields = fields;
            return this;
        }

        public Instance getInstanceResource() {
            return this.instanceResource;
        }

        public Builder setInstanceResource(Instance instanceResource) {
            this.instanceResource = instanceResource;
            return this;
        }

        public String getKey() {
            return this.key;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public String getPrettyPrint() {
            return this.prettyPrint;
        }

        public Builder setPrettyPrint(String prettyPrint) {
            this.prettyPrint = prettyPrint;
            return this;
        }

        public String getQuotaUser() {
            return this.quotaUser;
        }

        public Builder setQuotaUser(String quotaUser) {
            this.quotaUser = quotaUser;
            return this;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public Builder setRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public String getSourceInstanceTemplate() {
            return this.sourceInstanceTemplate;
        }

        public Builder setSourceInstanceTemplate(String sourceInstanceTemplate) {
            this.sourceInstanceTemplate = sourceInstanceTemplate;
            return this;
        }

        public String getUserIp() {
            return this.userIp;
        }

        public Builder setUserIp(String userIp) {
            this.userIp = userIp;
            return this;
        }

        public String getZone() {
            return this.zone;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        public InsertInstanceHttpRequest build() {
            String missing = "";
            if (this.zone == null) {
                missing = missing + " zone";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new InsertInstanceHttpRequest(this.access_token, this.callback, this.fields, this.instanceResource, this.key, this.prettyPrint, this.quotaUser, this.requestId, this.sourceInstanceTemplate, this.userIp, this.zone);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setAccessToken(this.access_token);
            newBuilder.setCallback(this.callback);
            newBuilder.setFields(this.fields);
            newBuilder.setInstanceResource(this.instanceResource);
            newBuilder.setKey(this.key);
            newBuilder.setPrettyPrint(this.prettyPrint);
            newBuilder.setQuotaUser(this.quotaUser);
            newBuilder.setRequestId(this.requestId);
            newBuilder.setSourceInstanceTemplate(this.sourceInstanceTemplate);
            newBuilder.setUserIp(this.userIp);
            newBuilder.setZone(this.zone);
            return newBuilder;
        }
    }
}

