/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListGlobalOperationsHttpRequest;
import com.google.cloud.compute.v1.DeleteGlobalOperationHttpRequest;
import com.google.cloud.compute.v1.GetGlobalOperationHttpRequest;
import com.google.cloud.compute.v1.GlobalOperationSettings;
import com.google.cloud.compute.v1.ListGlobalOperationsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.OperationAggregatedList;
import com.google.cloud.compute.v1.OperationList;
import com.google.cloud.compute.v1.OperationsScopedList;
import com.google.cloud.compute.v1.ProjectGlobalOperationName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.stub.GlobalOperationStub;
import com.google.cloud.compute.v1.stub.GlobalOperationStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GlobalOperationClient
implements BackgroundResource {
    private final GlobalOperationSettings settings;
    private final GlobalOperationStub stub;

    public static final GlobalOperationClient create() throws IOException {
        return GlobalOperationClient.create(GlobalOperationSettings.newBuilder().build());
    }

    public static final GlobalOperationClient create(GlobalOperationSettings settings) throws IOException {
        return new GlobalOperationClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final GlobalOperationClient create(GlobalOperationStub stub) {
        return new GlobalOperationClient(stub);
    }

    protected GlobalOperationClient(GlobalOperationSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GlobalOperationStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected GlobalOperationClient(GlobalOperationStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final GlobalOperationSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public GlobalOperationStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final AggregatedListGlobalOperationsPagedResponse aggregatedListGlobalOperations(ProjectName project) {
        AggregatedListGlobalOperationsHttpRequest request = AggregatedListGlobalOperationsHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.aggregatedListGlobalOperations(request);
    }

    @BetaApi
    public final AggregatedListGlobalOperationsPagedResponse aggregatedListGlobalOperations(String project) {
        AggregatedListGlobalOperationsHttpRequest request = AggregatedListGlobalOperationsHttpRequest.newBuilder().setProject(project).build();
        return this.aggregatedListGlobalOperations(request);
    }

    @BetaApi
    public final AggregatedListGlobalOperationsPagedResponse aggregatedListGlobalOperations(AggregatedListGlobalOperationsHttpRequest request) {
        return (AggregatedListGlobalOperationsPagedResponse)((Object)this.aggregatedListGlobalOperationsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<AggregatedListGlobalOperationsHttpRequest, AggregatedListGlobalOperationsPagedResponse> aggregatedListGlobalOperationsPagedCallable() {
        return this.stub.aggregatedListGlobalOperationsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<AggregatedListGlobalOperationsHttpRequest, OperationAggregatedList> aggregatedListGlobalOperationsCallable() {
        return this.stub.aggregatedListGlobalOperationsCallable();
    }

    @BetaApi
    public final void deleteGlobalOperation(ProjectGlobalOperationName operation) {
        DeleteGlobalOperationHttpRequest request = DeleteGlobalOperationHttpRequest.newBuilder().setOperation(operation == null ? null : operation.toString()).build();
        this.deleteGlobalOperation(request);
    }

    @BetaApi
    public final void deleteGlobalOperation(String operation) {
        DeleteGlobalOperationHttpRequest request = DeleteGlobalOperationHttpRequest.newBuilder().setOperation(operation).build();
        this.deleteGlobalOperation(request);
    }

    @BetaApi
    public final void deleteGlobalOperation(DeleteGlobalOperationHttpRequest request) {
        this.deleteGlobalOperationCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteGlobalOperationHttpRequest, Void> deleteGlobalOperationCallable() {
        return this.stub.deleteGlobalOperationCallable();
    }

    @BetaApi
    public final Operation getGlobalOperation(ProjectGlobalOperationName operation) {
        GetGlobalOperationHttpRequest request = GetGlobalOperationHttpRequest.newBuilder().setOperation(operation == null ? null : operation.toString()).build();
        return this.getGlobalOperation(request);
    }

    @BetaApi
    public final Operation getGlobalOperation(String operation) {
        GetGlobalOperationHttpRequest request = GetGlobalOperationHttpRequest.newBuilder().setOperation(operation).build();
        return this.getGlobalOperation(request);
    }

    @BetaApi
    public final Operation getGlobalOperation(GetGlobalOperationHttpRequest request) {
        return (Operation)this.getGlobalOperationCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetGlobalOperationHttpRequest, Operation> getGlobalOperationCallable() {
        return this.stub.getGlobalOperationCallable();
    }

    @BetaApi
    public final ListGlobalOperationsPagedResponse listGlobalOperations(ProjectName project) {
        ListGlobalOperationsHttpRequest request = ListGlobalOperationsHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listGlobalOperations(request);
    }

    @BetaApi
    public final ListGlobalOperationsPagedResponse listGlobalOperations(String project) {
        ListGlobalOperationsHttpRequest request = ListGlobalOperationsHttpRequest.newBuilder().setProject(project).build();
        return this.listGlobalOperations(request);
    }

    @BetaApi
    public final ListGlobalOperationsPagedResponse listGlobalOperations(ListGlobalOperationsHttpRequest request) {
        return (ListGlobalOperationsPagedResponse)((Object)this.listGlobalOperationsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListGlobalOperationsHttpRequest, ListGlobalOperationsPagedResponse> listGlobalOperationsPagedCallable() {
        return this.stub.listGlobalOperationsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListGlobalOperationsHttpRequest, OperationList> listGlobalOperationsCallable() {
        return this.stub.listGlobalOperationsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListGlobalOperationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGlobalOperationsHttpRequest, OperationList, Operation, ListGlobalOperationsPage, ListGlobalOperationsFixedSizeCollection> {
        private ListGlobalOperationsFixedSizeCollection(List<ListGlobalOperationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGlobalOperationsFixedSizeCollection createEmptyCollection() {
            return new ListGlobalOperationsFixedSizeCollection(null, 0);
        }

        protected ListGlobalOperationsFixedSizeCollection createCollection(List<ListGlobalOperationsPage> pages, int collectionSize) {
            return new ListGlobalOperationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGlobalOperationsPage
    extends AbstractPage<ListGlobalOperationsHttpRequest, OperationList, Operation, ListGlobalOperationsPage> {
        private ListGlobalOperationsPage(PageContext<ListGlobalOperationsHttpRequest, OperationList, Operation> context, OperationList response) {
            super(context, (Object)response);
        }

        private static ListGlobalOperationsPage createEmptyPage() {
            return new ListGlobalOperationsPage(null, null);
        }

        protected ListGlobalOperationsPage createPage(PageContext<ListGlobalOperationsHttpRequest, OperationList, Operation> context, OperationList response) {
            return new ListGlobalOperationsPage(context, response);
        }

        public ApiFuture<ListGlobalOperationsPage> createPageAsync(PageContext<ListGlobalOperationsHttpRequest, OperationList, Operation> context, ApiFuture<OperationList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGlobalOperationsPagedResponse
    extends AbstractPagedListResponse<ListGlobalOperationsHttpRequest, OperationList, Operation, ListGlobalOperationsPage, ListGlobalOperationsFixedSizeCollection> {
        public static ApiFuture<ListGlobalOperationsPagedResponse> createAsync(PageContext<ListGlobalOperationsHttpRequest, OperationList, Operation> context, ApiFuture<OperationList> futureResponse) {
            ApiFuture<ListGlobalOperationsPage> futurePage = ListGlobalOperationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListGlobalOperationsPage, ListGlobalOperationsPagedResponse>(){

                public ListGlobalOperationsPagedResponse apply(ListGlobalOperationsPage input) {
                    return new ListGlobalOperationsPagedResponse(input);
                }
            });
        }

        private ListGlobalOperationsPagedResponse(ListGlobalOperationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListGlobalOperationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListGlobalOperationsFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListGlobalOperationsHttpRequest, OperationAggregatedList, OperationsScopedList, AggregatedListGlobalOperationsPage, AggregatedListGlobalOperationsFixedSizeCollection> {
        private AggregatedListGlobalOperationsFixedSizeCollection(List<AggregatedListGlobalOperationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListGlobalOperationsFixedSizeCollection createEmptyCollection() {
            return new AggregatedListGlobalOperationsFixedSizeCollection(null, 0);
        }

        protected AggregatedListGlobalOperationsFixedSizeCollection createCollection(List<AggregatedListGlobalOperationsPage> pages, int collectionSize) {
            return new AggregatedListGlobalOperationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListGlobalOperationsPage
    extends AbstractPage<AggregatedListGlobalOperationsHttpRequest, OperationAggregatedList, OperationsScopedList, AggregatedListGlobalOperationsPage> {
        private AggregatedListGlobalOperationsPage(PageContext<AggregatedListGlobalOperationsHttpRequest, OperationAggregatedList, OperationsScopedList> context, OperationAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListGlobalOperationsPage createEmptyPage() {
            return new AggregatedListGlobalOperationsPage(null, null);
        }

        protected AggregatedListGlobalOperationsPage createPage(PageContext<AggregatedListGlobalOperationsHttpRequest, OperationAggregatedList, OperationsScopedList> context, OperationAggregatedList response) {
            return new AggregatedListGlobalOperationsPage(context, response);
        }

        public ApiFuture<AggregatedListGlobalOperationsPage> createPageAsync(PageContext<AggregatedListGlobalOperationsHttpRequest, OperationAggregatedList, OperationsScopedList> context, ApiFuture<OperationAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListGlobalOperationsPagedResponse
    extends AbstractPagedListResponse<AggregatedListGlobalOperationsHttpRequest, OperationAggregatedList, OperationsScopedList, AggregatedListGlobalOperationsPage, AggregatedListGlobalOperationsFixedSizeCollection> {
        public static ApiFuture<AggregatedListGlobalOperationsPagedResponse> createAsync(PageContext<AggregatedListGlobalOperationsHttpRequest, OperationAggregatedList, OperationsScopedList> context, ApiFuture<OperationAggregatedList> futureResponse) {
            ApiFuture<AggregatedListGlobalOperationsPage> futurePage = AggregatedListGlobalOperationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListGlobalOperationsPage, AggregatedListGlobalOperationsPagedResponse>(){

                public AggregatedListGlobalOperationsPagedResponse apply(AggregatedListGlobalOperationsPage input) {
                    return new AggregatedListGlobalOperationsPagedResponse(input);
                }
            });
        }

        private AggregatedListGlobalOperationsPagedResponse(AggregatedListGlobalOperationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListGlobalOperationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

