/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteSnapshotHttpRequest;
import com.google.cloud.compute.v1.GetIamPolicySnapshotHttpRequest;
import com.google.cloud.compute.v1.GetSnapshotHttpRequest;
import com.google.cloud.compute.v1.GlobalSetLabelsRequest;
import com.google.cloud.compute.v1.GlobalSetPolicyRequest;
import com.google.cloud.compute.v1.ListSnapshotsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.ProjectGlobalSnapshotName;
import com.google.cloud.compute.v1.ProjectGlobalSnapshotResourceName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.SetIamPolicySnapshotHttpRequest;
import com.google.cloud.compute.v1.SetLabelsSnapshotHttpRequest;
import com.google.cloud.compute.v1.Snapshot;
import com.google.cloud.compute.v1.SnapshotList;
import com.google.cloud.compute.v1.SnapshotSettings;
import com.google.cloud.compute.v1.TestIamPermissionsSnapshotHttpRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.SnapshotStub;
import com.google.cloud.compute.v1.stub.SnapshotStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class SnapshotClient
implements BackgroundResource {
    private final SnapshotSettings settings;
    private final SnapshotStub stub;

    public static final SnapshotClient create() throws IOException {
        return SnapshotClient.create(SnapshotSettings.newBuilder().build());
    }

    public static final SnapshotClient create(SnapshotSettings settings) throws IOException {
        return new SnapshotClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final SnapshotClient create(SnapshotStub stub) {
        return new SnapshotClient(stub);
    }

    protected SnapshotClient(SnapshotSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SnapshotStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected SnapshotClient(SnapshotStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SnapshotSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SnapshotStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation deleteSnapshot(ProjectGlobalSnapshotName snapshot) {
        DeleteSnapshotHttpRequest request = DeleteSnapshotHttpRequest.newBuilder().setSnapshot(snapshot == null ? null : snapshot.toString()).build();
        return this.deleteSnapshot(request);
    }

    @BetaApi
    public final Operation deleteSnapshot(String snapshot) {
        DeleteSnapshotHttpRequest request = DeleteSnapshotHttpRequest.newBuilder().setSnapshot(snapshot).build();
        return this.deleteSnapshot(request);
    }

    @BetaApi
    public final Operation deleteSnapshot(DeleteSnapshotHttpRequest request) {
        return (Operation)this.deleteSnapshotCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteSnapshotHttpRequest, Operation> deleteSnapshotCallable() {
        return this.stub.deleteSnapshotCallable();
    }

    @BetaApi
    public final Snapshot getSnapshot(ProjectGlobalSnapshotName snapshot) {
        GetSnapshotHttpRequest request = GetSnapshotHttpRequest.newBuilder().setSnapshot(snapshot == null ? null : snapshot.toString()).build();
        return this.getSnapshot(request);
    }

    @BetaApi
    public final Snapshot getSnapshot(String snapshot) {
        GetSnapshotHttpRequest request = GetSnapshotHttpRequest.newBuilder().setSnapshot(snapshot).build();
        return this.getSnapshot(request);
    }

    @BetaApi
    public final Snapshot getSnapshot(GetSnapshotHttpRequest request) {
        return (Snapshot)this.getSnapshotCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetSnapshotHttpRequest, Snapshot> getSnapshotCallable() {
        return this.stub.getSnapshotCallable();
    }

    @BetaApi
    public final Policy getIamPolicySnapshot(ProjectGlobalSnapshotResourceName resource) {
        GetIamPolicySnapshotHttpRequest request = GetIamPolicySnapshotHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicySnapshot(request);
    }

    @BetaApi
    public final Policy getIamPolicySnapshot(String resource) {
        GetIamPolicySnapshotHttpRequest request = GetIamPolicySnapshotHttpRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicySnapshot(request);
    }

    @BetaApi
    public final Policy getIamPolicySnapshot(GetIamPolicySnapshotHttpRequest request) {
        return (Policy)this.getIamPolicySnapshotCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetIamPolicySnapshotHttpRequest, Policy> getIamPolicySnapshotCallable() {
        return this.stub.getIamPolicySnapshotCallable();
    }

    @BetaApi
    public final ListSnapshotsPagedResponse listSnapshots(ProjectName project) {
        ListSnapshotsHttpRequest request = ListSnapshotsHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listSnapshots(request);
    }

    @BetaApi
    public final ListSnapshotsPagedResponse listSnapshots(String project) {
        ListSnapshotsHttpRequest request = ListSnapshotsHttpRequest.newBuilder().setProject(project).build();
        return this.listSnapshots(request);
    }

    @BetaApi
    public final ListSnapshotsPagedResponse listSnapshots(ListSnapshotsHttpRequest request) {
        return (ListSnapshotsPagedResponse)((Object)this.listSnapshotsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListSnapshotsHttpRequest, ListSnapshotsPagedResponse> listSnapshotsPagedCallable() {
        return this.stub.listSnapshotsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListSnapshotsHttpRequest, SnapshotList> listSnapshotsCallable() {
        return this.stub.listSnapshotsCallable();
    }

    @BetaApi
    public final Policy setIamPolicySnapshot(ProjectGlobalSnapshotResourceName resource, GlobalSetPolicyRequest globalSetPolicyRequestResource) {
        SetIamPolicySnapshotHttpRequest request = SetIamPolicySnapshotHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setGlobalSetPolicyRequestResource(globalSetPolicyRequestResource).build();
        return this.setIamPolicySnapshot(request);
    }

    @BetaApi
    public final Policy setIamPolicySnapshot(String resource, GlobalSetPolicyRequest globalSetPolicyRequestResource) {
        SetIamPolicySnapshotHttpRequest request = SetIamPolicySnapshotHttpRequest.newBuilder().setResource(resource).setGlobalSetPolicyRequestResource(globalSetPolicyRequestResource).build();
        return this.setIamPolicySnapshot(request);
    }

    @BetaApi
    public final Policy setIamPolicySnapshot(SetIamPolicySnapshotHttpRequest request) {
        return (Policy)this.setIamPolicySnapshotCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetIamPolicySnapshotHttpRequest, Policy> setIamPolicySnapshotCallable() {
        return this.stub.setIamPolicySnapshotCallable();
    }

    @BetaApi
    public final Operation setLabelsSnapshot(ProjectGlobalSnapshotResourceName resource, GlobalSetLabelsRequest globalSetLabelsRequestResource) {
        SetLabelsSnapshotHttpRequest request = SetLabelsSnapshotHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setGlobalSetLabelsRequestResource(globalSetLabelsRequestResource).build();
        return this.setLabelsSnapshot(request);
    }

    @BetaApi
    public final Operation setLabelsSnapshot(String resource, GlobalSetLabelsRequest globalSetLabelsRequestResource) {
        SetLabelsSnapshotHttpRequest request = SetLabelsSnapshotHttpRequest.newBuilder().setResource(resource).setGlobalSetLabelsRequestResource(globalSetLabelsRequestResource).build();
        return this.setLabelsSnapshot(request);
    }

    @BetaApi
    public final Operation setLabelsSnapshot(SetLabelsSnapshotHttpRequest request) {
        return (Operation)this.setLabelsSnapshotCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetLabelsSnapshotHttpRequest, Operation> setLabelsSnapshotCallable() {
        return this.stub.setLabelsSnapshotCallable();
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsSnapshot(ProjectGlobalSnapshotResourceName resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsSnapshotHttpRequest request = TestIamPermissionsSnapshotHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissionsSnapshot(request);
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsSnapshot(String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsSnapshotHttpRequest request = TestIamPermissionsSnapshotHttpRequest.newBuilder().setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissionsSnapshot(request);
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsSnapshot(TestIamPermissionsSnapshotHttpRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsSnapshotCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<TestIamPermissionsSnapshotHttpRequest, TestPermissionsResponse> testIamPermissionsSnapshotCallable() {
        return this.stub.testIamPermissionsSnapshotCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListSnapshotsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSnapshotsHttpRequest, SnapshotList, Snapshot, ListSnapshotsPage, ListSnapshotsFixedSizeCollection> {
        private ListSnapshotsFixedSizeCollection(List<ListSnapshotsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSnapshotsFixedSizeCollection createEmptyCollection() {
            return new ListSnapshotsFixedSizeCollection(null, 0);
        }

        protected ListSnapshotsFixedSizeCollection createCollection(List<ListSnapshotsPage> pages, int collectionSize) {
            return new ListSnapshotsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSnapshotsPage
    extends AbstractPage<ListSnapshotsHttpRequest, SnapshotList, Snapshot, ListSnapshotsPage> {
        private ListSnapshotsPage(PageContext<ListSnapshotsHttpRequest, SnapshotList, Snapshot> context, SnapshotList response) {
            super(context, (Object)response);
        }

        private static ListSnapshotsPage createEmptyPage() {
            return new ListSnapshotsPage(null, null);
        }

        protected ListSnapshotsPage createPage(PageContext<ListSnapshotsHttpRequest, SnapshotList, Snapshot> context, SnapshotList response) {
            return new ListSnapshotsPage(context, response);
        }

        public ApiFuture<ListSnapshotsPage> createPageAsync(PageContext<ListSnapshotsHttpRequest, SnapshotList, Snapshot> context, ApiFuture<SnapshotList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSnapshotsPagedResponse
    extends AbstractPagedListResponse<ListSnapshotsHttpRequest, SnapshotList, Snapshot, ListSnapshotsPage, ListSnapshotsFixedSizeCollection> {
        public static ApiFuture<ListSnapshotsPagedResponse> createAsync(PageContext<ListSnapshotsHttpRequest, SnapshotList, Snapshot> context, ApiFuture<SnapshotList> futureResponse) {
            ApiFuture<ListSnapshotsPage> futurePage = ListSnapshotsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListSnapshotsPage, ListSnapshotsPagedResponse>(){

                public ListSnapshotsPagedResponse apply(ListSnapshotsPage input) {
                    return new ListSnapshotsPagedResponse(input);
                }
            });
        }

        private ListSnapshotsPagedResponse(ListSnapshotsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSnapshotsFixedSizeCollection.createEmptyCollection());
        }
    }
}

