/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectRegionSubnetworkResourceName
implements ResourceName {
    private final String project;
    private final String region;
    private final String resource;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/regions/{region}/subnetworks/{resource}");
    public static final String SERVICE_ADDRESS = "https://www.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectRegionSubnetworkResourceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
        this.resource = (String)Preconditions.checkNotNull((Object)builder.getResource());
    }

    public static ProjectRegionSubnetworkResourceName of(String project, String region, String resource) {
        return ProjectRegionSubnetworkResourceName.newBuilder().setProject(project).setRegion(region).setResource(resource).build();
    }

    public static String format(String project, String region, String resource) {
        return ProjectRegionSubnetworkResourceName.of(project, region, resource).toString();
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    public String getResource() {
        return this.resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectRegionSubnetworkResourceName projectRegionSubnetworkResourceName = this;
            synchronized (projectRegionSubnetworkResourceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"region", (Object)this.region);
                    fieldMapBuilder.put((Object)"resource", (Object)this.resource);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectRegionSubnetworkResourceName> newFactory() {
        return new ResourceNameFactory<ProjectRegionSubnetworkResourceName>(){

            public ProjectRegionSubnetworkResourceName parse(String formattedString) {
                return ProjectRegionSubnetworkResourceName.parse(formattedString);
            }
        };
    }

    public static ProjectRegionSubnetworkResourceName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectRegionSubnetworkResourceName.parse: formattedString not in valid format");
        return ProjectRegionSubnetworkResourceName.of((String)matchMap.get("project"), (String)matchMap.get("region"), (String)matchMap.get("resource"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "region", this.region, "resource", this.resource});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectRegionSubnetworkResourceName) {
            ProjectRegionSubnetworkResourceName that = (ProjectRegionSubnetworkResourceName)o;
            return Objects.equals(this.project, that.getProject()) && Objects.equals(this.region, that.getRegion()) && Objects.equals(this.resource, that.getResource());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.project, this.region, this.resource);
    }

    public static class Builder {
        private String project;
        private String region;
        private String resource;

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public String getResource() {
            return this.resource;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setResource(String resource) {
            this.resource = resource;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectRegionSubnetworkResourceName projectRegionSubnetworkResourceName) {
            this.project = projectRegionSubnetworkResourceName.project;
            this.region = projectRegionSubnetworkResourceName.region;
            this.resource = projectRegionSubnetworkResourceName.resource;
        }

        public ProjectRegionSubnetworkResourceName build() {
            return new ProjectRegionSubnetworkResourceName(this);
        }
    }
}

