/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddInstancesInstanceGroupHttpRequest;
import com.google.cloud.compute.v1.AggregatedListInstanceGroupsHttpRequest;
import com.google.cloud.compute.v1.DeleteInstanceGroupHttpRequest;
import com.google.cloud.compute.v1.GetInstanceGroupHttpRequest;
import com.google.cloud.compute.v1.InsertInstanceGroupHttpRequest;
import com.google.cloud.compute.v1.InstanceGroup;
import com.google.cloud.compute.v1.InstanceGroupAggregatedList;
import com.google.cloud.compute.v1.InstanceGroupClient;
import com.google.cloud.compute.v1.InstanceGroupList;
import com.google.cloud.compute.v1.InstanceGroupsListInstances;
import com.google.cloud.compute.v1.InstanceGroupsScopedList;
import com.google.cloud.compute.v1.InstanceWithNamedPorts;
import com.google.cloud.compute.v1.ListInstanceGroupsHttpRequest;
import com.google.cloud.compute.v1.ListInstancesInstanceGroupsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RemoveInstancesInstanceGroupHttpRequest;
import com.google.cloud.compute.v1.SetNamedPortsInstanceGroupHttpRequest;
import com.google.cloud.compute.v1.stub.HttpJsonInstanceGroupStub;
import com.google.cloud.compute.v1.stub.InstanceGroupStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class InstanceGroupStubSettings
extends StubSettings<InstanceGroupStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<AddInstancesInstanceGroupHttpRequest, Operation> addInstancesInstanceGroupSettings;
    private final PagedCallSettings<AggregatedListInstanceGroupsHttpRequest, InstanceGroupAggregatedList, InstanceGroupClient.AggregatedListInstanceGroupsPagedResponse> aggregatedListInstanceGroupsSettings;
    private final UnaryCallSettings<DeleteInstanceGroupHttpRequest, Operation> deleteInstanceGroupSettings;
    private final UnaryCallSettings<GetInstanceGroupHttpRequest, InstanceGroup> getInstanceGroupSettings;
    private final UnaryCallSettings<InsertInstanceGroupHttpRequest, Operation> insertInstanceGroupSettings;
    private final PagedCallSettings<ListInstanceGroupsHttpRequest, InstanceGroupList, InstanceGroupClient.ListInstanceGroupsPagedResponse> listInstanceGroupsSettings;
    private final PagedCallSettings<ListInstancesInstanceGroupsHttpRequest, InstanceGroupsListInstances, InstanceGroupClient.ListInstancesInstanceGroupsPagedResponse> listInstancesInstanceGroupsSettings;
    private final UnaryCallSettings<RemoveInstancesInstanceGroupHttpRequest, Operation> removeInstancesInstanceGroupSettings;
    private final UnaryCallSettings<SetNamedPortsInstanceGroupHttpRequest, Operation> setNamedPortsInstanceGroupSettings;
    private static final PagedListDescriptor<AggregatedListInstanceGroupsHttpRequest, InstanceGroupAggregatedList, InstanceGroupsScopedList> AGGREGATED_LIST_INSTANCE_GROUPS_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListInstanceGroupsHttpRequest, InstanceGroupAggregatedList, InstanceGroupsScopedList>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListInstanceGroupsHttpRequest injectToken(AggregatedListInstanceGroupsHttpRequest payload, String token) {
            return AggregatedListInstanceGroupsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public AggregatedListInstanceGroupsHttpRequest injectPageSize(AggregatedListInstanceGroupsHttpRequest payload, int pageSize) {
            return AggregatedListInstanceGroupsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListInstanceGroupsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(InstanceGroupAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<InstanceGroupsScopedList> extractResources(InstanceGroupAggregatedList payload) {
            return payload.getItemsMap() != null ? payload.getItemsMap().values() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListInstanceGroupsHttpRequest, InstanceGroupList, InstanceGroup> LIST_INSTANCE_GROUPS_PAGE_STR_DESC = new PagedListDescriptor<ListInstanceGroupsHttpRequest, InstanceGroupList, InstanceGroup>(){

        public String emptyToken() {
            return "";
        }

        public ListInstanceGroupsHttpRequest injectToken(ListInstanceGroupsHttpRequest payload, String token) {
            return ListInstanceGroupsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListInstanceGroupsHttpRequest injectPageSize(ListInstanceGroupsHttpRequest payload, int pageSize) {
            return ListInstanceGroupsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListInstanceGroupsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(InstanceGroupList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<InstanceGroup> extractResources(InstanceGroupList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListInstancesInstanceGroupsHttpRequest, InstanceGroupsListInstances, InstanceWithNamedPorts> LIST_INSTANCES_INSTANCE_GROUPS_PAGE_STR_DESC = new PagedListDescriptor<ListInstancesInstanceGroupsHttpRequest, InstanceGroupsListInstances, InstanceWithNamedPorts>(){

        public String emptyToken() {
            return "";
        }

        public ListInstancesInstanceGroupsHttpRequest injectToken(ListInstancesInstanceGroupsHttpRequest payload, String token) {
            return ListInstancesInstanceGroupsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListInstancesInstanceGroupsHttpRequest injectPageSize(ListInstancesInstanceGroupsHttpRequest payload, int pageSize) {
            return ListInstancesInstanceGroupsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListInstancesInstanceGroupsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(InstanceGroupsListInstances payload) {
            return payload.getNextPageToken();
        }

        public Iterable<InstanceWithNamedPorts> extractResources(InstanceGroupsListInstances payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<AggregatedListInstanceGroupsHttpRequest, InstanceGroupAggregatedList, InstanceGroupClient.AggregatedListInstanceGroupsPagedResponse> AGGREGATED_LIST_INSTANCE_GROUPS_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListInstanceGroupsHttpRequest, InstanceGroupAggregatedList, InstanceGroupClient.AggregatedListInstanceGroupsPagedResponse>(){

        public ApiFuture<InstanceGroupClient.AggregatedListInstanceGroupsPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListInstanceGroupsHttpRequest, InstanceGroupAggregatedList> callable, AggregatedListInstanceGroupsHttpRequest request, ApiCallContext context, ApiFuture<InstanceGroupAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_INSTANCE_GROUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InstanceGroupClient.AggregatedListInstanceGroupsPagedResponse.createAsync((PageContext<AggregatedListInstanceGroupsHttpRequest, InstanceGroupAggregatedList, InstanceGroupsScopedList>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListInstanceGroupsHttpRequest, InstanceGroupList, InstanceGroupClient.ListInstanceGroupsPagedResponse> LIST_INSTANCE_GROUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListInstanceGroupsHttpRequest, InstanceGroupList, InstanceGroupClient.ListInstanceGroupsPagedResponse>(){

        public ApiFuture<InstanceGroupClient.ListInstanceGroupsPagedResponse> getFuturePagedResponse(UnaryCallable<ListInstanceGroupsHttpRequest, InstanceGroupList> callable, ListInstanceGroupsHttpRequest request, ApiCallContext context, ApiFuture<InstanceGroupList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INSTANCE_GROUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InstanceGroupClient.ListInstanceGroupsPagedResponse.createAsync((PageContext<ListInstanceGroupsHttpRequest, InstanceGroupList, InstanceGroup>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListInstancesInstanceGroupsHttpRequest, InstanceGroupsListInstances, InstanceGroupClient.ListInstancesInstanceGroupsPagedResponse> LIST_INSTANCES_INSTANCE_GROUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListInstancesInstanceGroupsHttpRequest, InstanceGroupsListInstances, InstanceGroupClient.ListInstancesInstanceGroupsPagedResponse>(){

        public ApiFuture<InstanceGroupClient.ListInstancesInstanceGroupsPagedResponse> getFuturePagedResponse(UnaryCallable<ListInstancesInstanceGroupsHttpRequest, InstanceGroupsListInstances> callable, ListInstancesInstanceGroupsHttpRequest request, ApiCallContext context, ApiFuture<InstanceGroupsListInstances> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INSTANCES_INSTANCE_GROUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InstanceGroupClient.ListInstancesInstanceGroupsPagedResponse.createAsync((PageContext<ListInstancesInstanceGroupsHttpRequest, InstanceGroupsListInstances, InstanceWithNamedPorts>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<AddInstancesInstanceGroupHttpRequest, Operation> addInstancesInstanceGroupSettings() {
        return this.addInstancesInstanceGroupSettings;
    }

    public PagedCallSettings<AggregatedListInstanceGroupsHttpRequest, InstanceGroupAggregatedList, InstanceGroupClient.AggregatedListInstanceGroupsPagedResponse> aggregatedListInstanceGroupsSettings() {
        return this.aggregatedListInstanceGroupsSettings;
    }

    public UnaryCallSettings<DeleteInstanceGroupHttpRequest, Operation> deleteInstanceGroupSettings() {
        return this.deleteInstanceGroupSettings;
    }

    public UnaryCallSettings<GetInstanceGroupHttpRequest, InstanceGroup> getInstanceGroupSettings() {
        return this.getInstanceGroupSettings;
    }

    public UnaryCallSettings<InsertInstanceGroupHttpRequest, Operation> insertInstanceGroupSettings() {
        return this.insertInstanceGroupSettings;
    }

    public PagedCallSettings<ListInstanceGroupsHttpRequest, InstanceGroupList, InstanceGroupClient.ListInstanceGroupsPagedResponse> listInstanceGroupsSettings() {
        return this.listInstanceGroupsSettings;
    }

    public PagedCallSettings<ListInstancesInstanceGroupsHttpRequest, InstanceGroupsListInstances, InstanceGroupClient.ListInstancesInstanceGroupsPagedResponse> listInstancesInstanceGroupsSettings() {
        return this.listInstancesInstanceGroupsSettings;
    }

    public UnaryCallSettings<RemoveInstancesInstanceGroupHttpRequest, Operation> removeInstancesInstanceGroupSettings() {
        return this.removeInstancesInstanceGroupSettings;
    }

    public UnaryCallSettings<SetNamedPortsInstanceGroupHttpRequest, Operation> setNamedPortsInstanceGroupSettings() {
        return this.setNamedPortsInstanceGroupSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public InstanceGroupStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonInstanceGroupStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return InstanceGroupStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(InstanceGroupStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected InstanceGroupStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.addInstancesInstanceGroupSettings = settingsBuilder.addInstancesInstanceGroupSettings().build();
        this.aggregatedListInstanceGroupsSettings = settingsBuilder.aggregatedListInstanceGroupsSettings().build();
        this.deleteInstanceGroupSettings = settingsBuilder.deleteInstanceGroupSettings().build();
        this.getInstanceGroupSettings = settingsBuilder.getInstanceGroupSettings().build();
        this.insertInstanceGroupSettings = settingsBuilder.insertInstanceGroupSettings().build();
        this.listInstanceGroupsSettings = settingsBuilder.listInstanceGroupsSettings().build();
        this.listInstancesInstanceGroupsSettings = settingsBuilder.listInstancesInstanceGroupsSettings().build();
        this.removeInstancesInstanceGroupSettings = settingsBuilder.removeInstancesInstanceGroupSettings().build();
        this.setNamedPortsInstanceGroupSettings = settingsBuilder.setNamedPortsInstanceGroupSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<InstanceGroupStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AddInstancesInstanceGroupHttpRequest, Operation> addInstancesInstanceGroupSettings;
        private final PagedCallSettings.Builder<AggregatedListInstanceGroupsHttpRequest, InstanceGroupAggregatedList, InstanceGroupClient.AggregatedListInstanceGroupsPagedResponse> aggregatedListInstanceGroupsSettings;
        private final UnaryCallSettings.Builder<DeleteInstanceGroupHttpRequest, Operation> deleteInstanceGroupSettings;
        private final UnaryCallSettings.Builder<GetInstanceGroupHttpRequest, InstanceGroup> getInstanceGroupSettings;
        private final UnaryCallSettings.Builder<InsertInstanceGroupHttpRequest, Operation> insertInstanceGroupSettings;
        private final PagedCallSettings.Builder<ListInstanceGroupsHttpRequest, InstanceGroupList, InstanceGroupClient.ListInstanceGroupsPagedResponse> listInstanceGroupsSettings;
        private final PagedCallSettings.Builder<ListInstancesInstanceGroupsHttpRequest, InstanceGroupsListInstances, InstanceGroupClient.ListInstancesInstanceGroupsPagedResponse> listInstancesInstanceGroupsSettings;
        private final UnaryCallSettings.Builder<RemoveInstancesInstanceGroupHttpRequest, Operation> removeInstancesInstanceGroupSettings;
        private final UnaryCallSettings.Builder<SetNamedPortsInstanceGroupHttpRequest, Operation> setNamedPortsInstanceGroupSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.addInstancesInstanceGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.aggregatedListInstanceGroupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_INSTANCE_GROUPS_PAGE_STR_FACT);
            this.deleteInstanceGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getInstanceGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertInstanceGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listInstanceGroupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INSTANCE_GROUPS_PAGE_STR_FACT);
            this.listInstancesInstanceGroupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INSTANCES_INSTANCE_GROUPS_PAGE_STR_FACT);
            this.removeInstancesInstanceGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setNamedPortsInstanceGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addInstancesInstanceGroupSettings, this.aggregatedListInstanceGroupsSettings, this.deleteInstanceGroupSettings, this.getInstanceGroupSettings, this.insertInstanceGroupSettings, this.listInstanceGroupsSettings, this.listInstancesInstanceGroupsSettings, this.removeInstancesInstanceGroupSettings, this.setNamedPortsInstanceGroupSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(InstanceGroupStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)InstanceGroupStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)InstanceGroupStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(InstanceGroupStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.addInstancesInstanceGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.aggregatedListInstanceGroupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteInstanceGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getInstanceGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertInstanceGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listInstanceGroupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listInstancesInstanceGroupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.removeInstancesInstanceGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setNamedPortsInstanceGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(InstanceGroupStubSettings settings) {
            super((StubSettings)settings);
            this.addInstancesInstanceGroupSettings = settings.addInstancesInstanceGroupSettings.toBuilder();
            this.aggregatedListInstanceGroupsSettings = settings.aggregatedListInstanceGroupsSettings.toBuilder();
            this.deleteInstanceGroupSettings = settings.deleteInstanceGroupSettings.toBuilder();
            this.getInstanceGroupSettings = settings.getInstanceGroupSettings.toBuilder();
            this.insertInstanceGroupSettings = settings.insertInstanceGroupSettings.toBuilder();
            this.listInstanceGroupsSettings = settings.listInstanceGroupsSettings.toBuilder();
            this.listInstancesInstanceGroupsSettings = settings.listInstancesInstanceGroupsSettings.toBuilder();
            this.removeInstancesInstanceGroupSettings = settings.removeInstancesInstanceGroupSettings.toBuilder();
            this.setNamedPortsInstanceGroupSettings = settings.setNamedPortsInstanceGroupSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addInstancesInstanceGroupSettings, this.aggregatedListInstanceGroupsSettings, this.deleteInstanceGroupSettings, this.getInstanceGroupSettings, this.insertInstanceGroupSettings, this.listInstanceGroupsSettings, this.listInstancesInstanceGroupsSettings, this.removeInstancesInstanceGroupSettings, this.setNamedPortsInstanceGroupSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AddInstancesInstanceGroupHttpRequest, Operation> addInstancesInstanceGroupSettings() {
            return this.addInstancesInstanceGroupSettings;
        }

        public PagedCallSettings.Builder<AggregatedListInstanceGroupsHttpRequest, InstanceGroupAggregatedList, InstanceGroupClient.AggregatedListInstanceGroupsPagedResponse> aggregatedListInstanceGroupsSettings() {
            return this.aggregatedListInstanceGroupsSettings;
        }

        public UnaryCallSettings.Builder<DeleteInstanceGroupHttpRequest, Operation> deleteInstanceGroupSettings() {
            return this.deleteInstanceGroupSettings;
        }

        public UnaryCallSettings.Builder<GetInstanceGroupHttpRequest, InstanceGroup> getInstanceGroupSettings() {
            return this.getInstanceGroupSettings;
        }

        public UnaryCallSettings.Builder<InsertInstanceGroupHttpRequest, Operation> insertInstanceGroupSettings() {
            return this.insertInstanceGroupSettings;
        }

        public PagedCallSettings.Builder<ListInstanceGroupsHttpRequest, InstanceGroupList, InstanceGroupClient.ListInstanceGroupsPagedResponse> listInstanceGroupsSettings() {
            return this.listInstanceGroupsSettings;
        }

        public PagedCallSettings.Builder<ListInstancesInstanceGroupsHttpRequest, InstanceGroupsListInstances, InstanceGroupClient.ListInstancesInstanceGroupsPagedResponse> listInstancesInstanceGroupsSettings() {
            return this.listInstancesInstanceGroupsSettings;
        }

        public UnaryCallSettings.Builder<RemoveInstancesInstanceGroupHttpRequest, Operation> removeInstancesInstanceGroupSettings() {
            return this.removeInstancesInstanceGroupSettings;
        }

        public UnaryCallSettings.Builder<SetNamedPortsInstanceGroupHttpRequest, Operation> setNamedPortsInstanceGroupSettings() {
            return this.setNamedPortsInstanceGroupSettings;
        }

        public InstanceGroupStubSettings build() throws IOException {
            return new InstanceGroupStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

