/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.Subnetwork;
import com.google.cloud.compute.v1.Warning;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class SubnetworksScopedList
implements ApiMessage {
    private final List<Subnetwork> subnetworks;
    private final Warning warning;
    private static final SubnetworksScopedList DEFAULT_INSTANCE = new SubnetworksScopedList();

    private SubnetworksScopedList() {
        this.subnetworks = null;
        this.warning = null;
    }

    private SubnetworksScopedList(List<Subnetwork> subnetworks, Warning warning) {
        this.subnetworks = subnetworks;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("subnetworks")) {
            return this.subnetworks;
        }
        if (fieldName.equals("warning")) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<Subnetwork> getSubnetworksList() {
        return this.subnetworks;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(SubnetworksScopedList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static SubnetworksScopedList getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "SubnetworksScopedList{subnetworks=" + this.subnetworks + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SubnetworksScopedList) {
            SubnetworksScopedList that = (SubnetworksScopedList)o;
            return Objects.equals(this.subnetworks, that.getSubnetworksList()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.subnetworks, this.warning);
    }

    public static class Builder {
        private List<Subnetwork> subnetworks;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(SubnetworksScopedList other) {
            if (other == SubnetworksScopedList.getDefaultInstance()) {
                return this;
            }
            if (other.getSubnetworksList() != null) {
                this.subnetworks = other.subnetworks;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(SubnetworksScopedList source) {
            this.subnetworks = source.subnetworks;
            this.warning = source.warning;
        }

        public List<Subnetwork> getSubnetworksList() {
            return this.subnetworks;
        }

        public Builder addAllSubnetworks(List<Subnetwork> subnetworks) {
            if (this.subnetworks == null) {
                this.subnetworks = new LinkedList<Subnetwork>();
            }
            this.subnetworks.addAll(subnetworks);
            return this;
        }

        public Builder addSubnetworks(Subnetwork subnetworks) {
            if (this.subnetworks == null) {
                this.subnetworks = new LinkedList<Subnetwork>();
            }
            this.subnetworks.add(subnetworks);
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public SubnetworksScopedList build() {
            return new SubnetworksScopedList(this.subnetworks, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllSubnetworks(this.subnetworks);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

