/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.SecurityPolicyRuleMatcher;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class SecurityPolicyRule
implements ApiMessage {
    private final String action;
    private final String description;
    private final String kind;
    private final SecurityPolicyRuleMatcher match;
    private final Boolean preview;
    private final Integer priority;
    private static final SecurityPolicyRule DEFAULT_INSTANCE = new SecurityPolicyRule();

    private SecurityPolicyRule() {
        this.action = null;
        this.description = null;
        this.kind = null;
        this.match = null;
        this.preview = null;
        this.priority = null;
    }

    private SecurityPolicyRule(String action, String description, String kind, SecurityPolicyRuleMatcher match, Boolean preview, Integer priority) {
        this.action = action;
        this.description = description;
        this.kind = kind;
        this.match = match;
        this.preview = preview;
        this.priority = priority;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("action")) {
            return this.action;
        }
        if (fieldName.equals("description")) {
            return this.description;
        }
        if (fieldName.equals("kind")) {
            return this.kind;
        }
        if (fieldName.equals("match")) {
            return this.match;
        }
        if (fieldName.equals("preview")) {
            return this.preview;
        }
        if (fieldName.equals("priority")) {
            return this.priority;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getAction() {
        return this.action;
    }

    public String getDescription() {
        return this.description;
    }

    public String getKind() {
        return this.kind;
    }

    public SecurityPolicyRuleMatcher getMatch() {
        return this.match;
    }

    public Boolean getPreview() {
        return this.preview;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(SecurityPolicyRule prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static SecurityPolicyRule getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "SecurityPolicyRule{action=" + this.action + ", description=" + this.description + ", kind=" + this.kind + ", match=" + this.match + ", preview=" + this.preview + ", priority=" + this.priority + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SecurityPolicyRule) {
            SecurityPolicyRule that = (SecurityPolicyRule)o;
            return Objects.equals(this.action, that.getAction()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.match, that.getMatch()) && Objects.equals(this.preview, that.getPreview()) && Objects.equals(this.priority, that.getPriority());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.action, this.description, this.kind, this.match, this.preview, this.priority);
    }

    public static class Builder {
        private String action;
        private String description;
        private String kind;
        private SecurityPolicyRuleMatcher match;
        private Boolean preview;
        private Integer priority;

        Builder() {
        }

        public Builder mergeFrom(SecurityPolicyRule other) {
            if (other == SecurityPolicyRule.getDefaultInstance()) {
                return this;
            }
            if (other.getAction() != null) {
                this.action = other.action;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getMatch() != null) {
                this.match = other.match;
            }
            if (other.getPreview() != null) {
                this.preview = other.preview;
            }
            if (other.getPriority() != null) {
                this.priority = other.priority;
            }
            return this;
        }

        Builder(SecurityPolicyRule source) {
            this.action = source.action;
            this.description = source.description;
            this.kind = source.kind;
            this.match = source.match;
            this.preview = source.preview;
            this.priority = source.priority;
        }

        public String getAction() {
            return this.action;
        }

        public Builder setAction(String action) {
            this.action = action;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public SecurityPolicyRuleMatcher getMatch() {
            return this.match;
        }

        public Builder setMatch(SecurityPolicyRuleMatcher match) {
            this.match = match;
            return this;
        }

        public Boolean getPreview() {
            return this.preview;
        }

        public Builder setPreview(Boolean preview) {
            this.preview = preview;
            return this;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public Builder setPriority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public SecurityPolicyRule build() {
            return new SecurityPolicyRule(this.action, this.description, this.kind, this.match, this.preview, this.priority);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setAction(this.action);
            newBuilder.setDescription(this.description);
            newBuilder.setKind(this.kind);
            newBuilder.setMatch(this.match);
            newBuilder.setPreview(this.preview);
            newBuilder.setPriority(this.priority);
            return newBuilder;
        }
    }
}

