/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.SecurityPolicyRule;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class SecurityPolicy
implements ApiMessage {
    private final String creationTimestamp;
    private final String description;
    private final String fingerprint;
    private final String id;
    private final String kind;
    private final String name;
    private final List<SecurityPolicyRule> rules;
    private final String selfLink;
    private static final SecurityPolicy DEFAULT_INSTANCE = new SecurityPolicy();

    private SecurityPolicy() {
        this.creationTimestamp = null;
        this.description = null;
        this.fingerprint = null;
        this.id = null;
        this.kind = null;
        this.name = null;
        this.rules = null;
        this.selfLink = null;
    }

    private SecurityPolicy(String creationTimestamp, String description, String fingerprint, String id, String kind, String name, List<SecurityPolicyRule> rules, String selfLink) {
        this.creationTimestamp = creationTimestamp;
        this.description = description;
        this.fingerprint = fingerprint;
        this.id = id;
        this.kind = kind;
        this.name = name;
        this.rules = rules;
        this.selfLink = selfLink;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("creationTimestamp")) {
            return this.creationTimestamp;
        }
        if (fieldName.equals("description")) {
            return this.description;
        }
        if (fieldName.equals("fingerprint")) {
            return this.fingerprint;
        }
        if (fieldName.equals("id")) {
            return this.id;
        }
        if (fieldName.equals("kind")) {
            return this.kind;
        }
        if (fieldName.equals("name")) {
            return this.name;
        }
        if (fieldName.equals("rules")) {
            return this.rules;
        }
        if (fieldName.equals("selfLink")) {
            return this.selfLink;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public List<SecurityPolicyRule> getRulesList() {
        return this.rules;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(SecurityPolicy prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static SecurityPolicy getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "SecurityPolicy{creationTimestamp=" + this.creationTimestamp + ", description=" + this.description + ", fingerprint=" + this.fingerprint + ", id=" + this.id + ", kind=" + this.kind + ", name=" + this.name + ", rules=" + this.rules + ", selfLink=" + this.selfLink + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SecurityPolicy) {
            SecurityPolicy that = (SecurityPolicy)o;
            return Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.fingerprint, that.getFingerprint()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.rules, that.getRulesList()) && Objects.equals(this.selfLink, that.getSelfLink());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.creationTimestamp, this.description, this.fingerprint, this.id, this.kind, this.name, this.rules, this.selfLink);
    }

    public static class Builder {
        private String creationTimestamp;
        private String description;
        private String fingerprint;
        private String id;
        private String kind;
        private String name;
        private List<SecurityPolicyRule> rules;
        private String selfLink;

        Builder() {
        }

        public Builder mergeFrom(SecurityPolicy other) {
            if (other == SecurityPolicy.getDefaultInstance()) {
                return this;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getFingerprint() != null) {
                this.fingerprint = other.fingerprint;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getRulesList() != null) {
                this.rules = other.rules;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            return this;
        }

        Builder(SecurityPolicy source) {
            this.creationTimestamp = source.creationTimestamp;
            this.description = source.description;
            this.fingerprint = source.fingerprint;
            this.id = source.id;
            this.kind = source.kind;
            this.name = source.name;
            this.rules = source.rules;
            this.selfLink = source.selfLink;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getFingerprint() {
            return this.fingerprint;
        }

        public Builder setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public List<SecurityPolicyRule> getRulesList() {
            return this.rules;
        }

        public Builder addAllRules(List<SecurityPolicyRule> rules) {
            if (this.rules == null) {
                this.rules = new LinkedList<SecurityPolicyRule>();
            }
            this.rules.addAll(rules);
            return this;
        }

        public Builder addRules(SecurityPolicyRule rules) {
            if (this.rules == null) {
                this.rules = new LinkedList<SecurityPolicyRule>();
            }
            this.rules.add(rules);
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public SecurityPolicy build() {
            return new SecurityPolicy(this.creationTimestamp, this.description, this.fingerprint, this.id, this.kind, this.name, this.rules, this.selfLink);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDescription(this.description);
            newBuilder.setFingerprint(this.fingerprint);
            newBuilder.setId(this.id);
            newBuilder.setKind(this.kind);
            newBuilder.setName(this.name);
            newBuilder.addAllRules(this.rules);
            newBuilder.setSelfLink(this.selfLink);
            return newBuilder;
        }
    }
}

