/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectGlobalFirewallName
implements ResourceName {
    private final String firewall;
    private final String project;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/global/firewalls/{firewall}");
    public static final String SERVICE_ADDRESS = "https://www.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectGlobalFirewallName(Builder builder) {
        this.firewall = (String)Preconditions.checkNotNull((Object)builder.getFirewall());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
    }

    public static ProjectGlobalFirewallName of(String firewall, String project) {
        return ProjectGlobalFirewallName.newBuilder().setFirewall(firewall).setProject(project).build();
    }

    public static String format(String firewall, String project) {
        return ProjectGlobalFirewallName.of(firewall, project).toString();
    }

    public String getFirewall() {
        return this.firewall;
    }

    public String getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectGlobalFirewallName projectGlobalFirewallName = this;
            synchronized (projectGlobalFirewallName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"firewall", (Object)this.firewall);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectGlobalFirewallName> newFactory() {
        return new ResourceNameFactory<ProjectGlobalFirewallName>(){

            public ProjectGlobalFirewallName parse(String formattedString) {
                return ProjectGlobalFirewallName.parse(formattedString);
            }
        };
    }

    public static ProjectGlobalFirewallName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectGlobalFirewallName.parse: formattedString not in valid format");
        return ProjectGlobalFirewallName.of((String)matchMap.get("firewall"), (String)matchMap.get("project"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"firewall", this.firewall, "project", this.project});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectGlobalFirewallName) {
            ProjectGlobalFirewallName that = (ProjectGlobalFirewallName)o;
            return Objects.equals(this.firewall, that.getFirewall()) && Objects.equals(this.project, that.getProject());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.firewall, this.project);
    }

    public static class Builder {
        private String firewall;
        private String project;

        public String getFirewall() {
            return this.firewall;
        }

        public String getProject() {
            return this.project;
        }

        public Builder setFirewall(String firewall) {
            this.firewall = firewall;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectGlobalFirewallName projectGlobalFirewallName) {
            this.firewall = projectGlobalFirewallName.firewall;
            this.project = projectGlobalFirewallName.project;
        }

        public ProjectGlobalFirewallName build() {
            return new ProjectGlobalFirewallName(this);
        }
    }
}

