/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteHealthCheckHttpRequest;
import com.google.cloud.compute.v1.GetHealthCheckHttpRequest;
import com.google.cloud.compute.v1.HealthCheck;
import com.google.cloud.compute.v1.HealthCheckList;
import com.google.cloud.compute.v1.HealthCheckSettings;
import com.google.cloud.compute.v1.InsertHealthCheckHttpRequest;
import com.google.cloud.compute.v1.ListHealthChecksHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchHealthCheckHttpRequest;
import com.google.cloud.compute.v1.ProjectGlobalHealthCheckName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.UpdateHealthCheckHttpRequest;
import com.google.cloud.compute.v1.stub.HealthCheckStub;
import com.google.cloud.compute.v1.stub.HealthCheckStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HealthCheckClient
implements BackgroundResource {
    private final HealthCheckSettings settings;
    private final HealthCheckStub stub;

    public static final HealthCheckClient create() throws IOException {
        return HealthCheckClient.create(HealthCheckSettings.newBuilder().build());
    }

    public static final HealthCheckClient create(HealthCheckSettings settings) throws IOException {
        return new HealthCheckClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final HealthCheckClient create(HealthCheckStub stub) {
        return new HealthCheckClient(stub);
    }

    protected HealthCheckClient(HealthCheckSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((HealthCheckStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected HealthCheckClient(HealthCheckStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final HealthCheckSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public HealthCheckStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation deleteHealthCheck(ProjectGlobalHealthCheckName healthCheck) {
        DeleteHealthCheckHttpRequest request = DeleteHealthCheckHttpRequest.newBuilder().setHealthCheck(healthCheck == null ? null : healthCheck.toString()).build();
        return this.deleteHealthCheck(request);
    }

    @BetaApi
    public final Operation deleteHealthCheck(String healthCheck) {
        DeleteHealthCheckHttpRequest request = DeleteHealthCheckHttpRequest.newBuilder().setHealthCheck(healthCheck).build();
        return this.deleteHealthCheck(request);
    }

    @BetaApi
    public final Operation deleteHealthCheck(DeleteHealthCheckHttpRequest request) {
        return (Operation)this.deleteHealthCheckCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteHealthCheckHttpRequest, Operation> deleteHealthCheckCallable() {
        return this.stub.deleteHealthCheckCallable();
    }

    @BetaApi
    public final HealthCheck getHealthCheck(ProjectGlobalHealthCheckName healthCheck) {
        GetHealthCheckHttpRequest request = GetHealthCheckHttpRequest.newBuilder().setHealthCheck(healthCheck == null ? null : healthCheck.toString()).build();
        return this.getHealthCheck(request);
    }

    @BetaApi
    public final HealthCheck getHealthCheck(String healthCheck) {
        GetHealthCheckHttpRequest request = GetHealthCheckHttpRequest.newBuilder().setHealthCheck(healthCheck).build();
        return this.getHealthCheck(request);
    }

    @BetaApi
    public final HealthCheck getHealthCheck(GetHealthCheckHttpRequest request) {
        return (HealthCheck)this.getHealthCheckCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetHealthCheckHttpRequest, HealthCheck> getHealthCheckCallable() {
        return this.stub.getHealthCheckCallable();
    }

    @BetaApi
    public final Operation insertHealthCheck(ProjectName project, HealthCheck healthCheckResource) {
        InsertHealthCheckHttpRequest request = InsertHealthCheckHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).setHealthCheckResource(healthCheckResource).build();
        return this.insertHealthCheck(request);
    }

    @BetaApi
    public final Operation insertHealthCheck(String project, HealthCheck healthCheckResource) {
        InsertHealthCheckHttpRequest request = InsertHealthCheckHttpRequest.newBuilder().setProject(project).setHealthCheckResource(healthCheckResource).build();
        return this.insertHealthCheck(request);
    }

    @BetaApi
    public final Operation insertHealthCheck(InsertHealthCheckHttpRequest request) {
        return (Operation)this.insertHealthCheckCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertHealthCheckHttpRequest, Operation> insertHealthCheckCallable() {
        return this.stub.insertHealthCheckCallable();
    }

    @BetaApi
    public final ListHealthChecksPagedResponse listHealthChecks(ProjectName project) {
        ListHealthChecksHttpRequest request = ListHealthChecksHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listHealthChecks(request);
    }

    @BetaApi
    public final ListHealthChecksPagedResponse listHealthChecks(String project) {
        ListHealthChecksHttpRequest request = ListHealthChecksHttpRequest.newBuilder().setProject(project).build();
        return this.listHealthChecks(request);
    }

    @BetaApi
    public final ListHealthChecksPagedResponse listHealthChecks(ListHealthChecksHttpRequest request) {
        return (ListHealthChecksPagedResponse)((Object)this.listHealthChecksPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListHealthChecksHttpRequest, ListHealthChecksPagedResponse> listHealthChecksPagedCallable() {
        return this.stub.listHealthChecksPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListHealthChecksHttpRequest, HealthCheckList> listHealthChecksCallable() {
        return this.stub.listHealthChecksCallable();
    }

    @BetaApi
    public final Operation patchHealthCheck(ProjectGlobalHealthCheckName healthCheck, HealthCheck healthCheckResource, List<String> fieldMask) {
        PatchHealthCheckHttpRequest request = PatchHealthCheckHttpRequest.newBuilder().setHealthCheck(healthCheck == null ? null : healthCheck.toString()).setHealthCheckResource(healthCheckResource).addAllFieldMask(fieldMask).build();
        return this.patchHealthCheck(request);
    }

    @BetaApi
    public final Operation patchHealthCheck(String healthCheck, HealthCheck healthCheckResource, List<String> fieldMask) {
        PatchHealthCheckHttpRequest request = PatchHealthCheckHttpRequest.newBuilder().setHealthCheck(healthCheck).setHealthCheckResource(healthCheckResource).addAllFieldMask(fieldMask).build();
        return this.patchHealthCheck(request);
    }

    @BetaApi
    public final Operation patchHealthCheck(PatchHealthCheckHttpRequest request) {
        return (Operation)this.patchHealthCheckCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<PatchHealthCheckHttpRequest, Operation> patchHealthCheckCallable() {
        return this.stub.patchHealthCheckCallable();
    }

    @BetaApi
    public final Operation updateHealthCheck(ProjectGlobalHealthCheckName healthCheck, HealthCheck healthCheckResource, List<String> fieldMask) {
        UpdateHealthCheckHttpRequest request = UpdateHealthCheckHttpRequest.newBuilder().setHealthCheck(healthCheck == null ? null : healthCheck.toString()).setHealthCheckResource(healthCheckResource).addAllFieldMask(fieldMask).build();
        return this.updateHealthCheck(request);
    }

    @BetaApi
    public final Operation updateHealthCheck(String healthCheck, HealthCheck healthCheckResource, List<String> fieldMask) {
        UpdateHealthCheckHttpRequest request = UpdateHealthCheckHttpRequest.newBuilder().setHealthCheck(healthCheck).setHealthCheckResource(healthCheckResource).addAllFieldMask(fieldMask).build();
        return this.updateHealthCheck(request);
    }

    @BetaApi
    public final Operation updateHealthCheck(UpdateHealthCheckHttpRequest request) {
        return (Operation)this.updateHealthCheckCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<UpdateHealthCheckHttpRequest, Operation> updateHealthCheckCallable() {
        return this.stub.updateHealthCheckCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListHealthChecksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListHealthChecksHttpRequest, HealthCheckList, HealthCheck, ListHealthChecksPage, ListHealthChecksFixedSizeCollection> {
        private ListHealthChecksFixedSizeCollection(List<ListHealthChecksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListHealthChecksFixedSizeCollection createEmptyCollection() {
            return new ListHealthChecksFixedSizeCollection(null, 0);
        }

        protected ListHealthChecksFixedSizeCollection createCollection(List<ListHealthChecksPage> pages, int collectionSize) {
            return new ListHealthChecksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListHealthChecksPage
    extends AbstractPage<ListHealthChecksHttpRequest, HealthCheckList, HealthCheck, ListHealthChecksPage> {
        private ListHealthChecksPage(PageContext<ListHealthChecksHttpRequest, HealthCheckList, HealthCheck> context, HealthCheckList response) {
            super(context, (Object)response);
        }

        private static ListHealthChecksPage createEmptyPage() {
            return new ListHealthChecksPage(null, null);
        }

        protected ListHealthChecksPage createPage(PageContext<ListHealthChecksHttpRequest, HealthCheckList, HealthCheck> context, HealthCheckList response) {
            return new ListHealthChecksPage(context, response);
        }

        public ApiFuture<ListHealthChecksPage> createPageAsync(PageContext<ListHealthChecksHttpRequest, HealthCheckList, HealthCheck> context, ApiFuture<HealthCheckList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListHealthChecksPagedResponse
    extends AbstractPagedListResponse<ListHealthChecksHttpRequest, HealthCheckList, HealthCheck, ListHealthChecksPage, ListHealthChecksFixedSizeCollection> {
        public static ApiFuture<ListHealthChecksPagedResponse> createAsync(PageContext<ListHealthChecksHttpRequest, HealthCheckList, HealthCheck> context, ApiFuture<HealthCheckList> futureResponse) {
            ApiFuture<ListHealthChecksPage> futurePage = ListHealthChecksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListHealthChecksPage, ListHealthChecksPagedResponse>(){

                public ListHealthChecksPagedResponse apply(ListHealthChecksPage input) {
                    return new ListHealthChecksPagedResponse(input);
                }
            });
        }

        private ListHealthChecksPagedResponse(ListHealthChecksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListHealthChecksFixedSizeCollection.createEmptyCollection());
        }
    }
}

