/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.TargetPool;
import com.google.cloud.compute.v1.Warning;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class TargetPoolsScopedList
implements ApiMessage {
    private final List<TargetPool> targetPools;
    private final Warning warning;
    private static final TargetPoolsScopedList DEFAULT_INSTANCE = new TargetPoolsScopedList();

    private TargetPoolsScopedList() {
        this.targetPools = null;
        this.warning = null;
    }

    private TargetPoolsScopedList(List<TargetPool> targetPools, Warning warning) {
        this.targetPools = targetPools;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("targetPools")) {
            return this.targetPools;
        }
        if (fieldName.equals("warning")) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<TargetPool> getTargetPoolsList() {
        return this.targetPools;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(TargetPoolsScopedList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static TargetPoolsScopedList getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "TargetPoolsScopedList{targetPools=" + this.targetPools + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TargetPoolsScopedList) {
            TargetPoolsScopedList that = (TargetPoolsScopedList)o;
            return Objects.equals(this.targetPools, that.getTargetPoolsList()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.targetPools, this.warning);
    }

    public static class Builder {
        private List<TargetPool> targetPools;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(TargetPoolsScopedList other) {
            if (other == TargetPoolsScopedList.getDefaultInstance()) {
                return this;
            }
            if (other.getTargetPoolsList() != null) {
                this.targetPools = other.targetPools;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(TargetPoolsScopedList source) {
            this.targetPools = source.targetPools;
            this.warning = source.warning;
        }

        public List<TargetPool> getTargetPoolsList() {
            return this.targetPools;
        }

        public Builder addAllTargetPools(List<TargetPool> targetPools) {
            if (this.targetPools == null) {
                this.targetPools = new LinkedList<TargetPool>();
            }
            this.targetPools.addAll(targetPools);
            return this;
        }

        public Builder addTargetPools(TargetPool targetPools) {
            if (this.targetPools == null) {
                this.targetPools = new LinkedList<TargetPool>();
            }
            this.targetPools.add(targetPools);
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public TargetPoolsScopedList build() {
            return new TargetPoolsScopedList(this.targetPools, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllTargetPools(this.targetPools);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

