/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectRegionSubnetworkName
implements ResourceName {
    private final String project;
    private final String region;
    private final String subnetwork;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/regions/{region}/subnetworks/{subnetwork}");
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectRegionSubnetworkName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
        this.subnetwork = (String)Preconditions.checkNotNull((Object)builder.getSubnetwork());
    }

    public static ProjectRegionSubnetworkName of(String project, String region, String subnetwork) {
        return ProjectRegionSubnetworkName.newBuilder().setProject(project).setRegion(region).setSubnetwork(subnetwork).build();
    }

    public static String format(String project, String region, String subnetwork) {
        return ProjectRegionSubnetworkName.of(project, region, subnetwork).toString();
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    public String getSubnetwork() {
        return this.subnetwork;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectRegionSubnetworkName projectRegionSubnetworkName = this;
            synchronized (projectRegionSubnetworkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"region", (Object)this.region);
                    fieldMapBuilder.put((Object)"subnetwork", (Object)this.subnetwork);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectRegionSubnetworkName> newFactory() {
        return new ResourceNameFactory<ProjectRegionSubnetworkName>(){

            public ProjectRegionSubnetworkName parse(String formattedString) {
                return ProjectRegionSubnetworkName.parse(formattedString);
            }
        };
    }

    public static ProjectRegionSubnetworkName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ProjectRegionSubnetworkName.parse: formattedString not in valid format");
        return ProjectRegionSubnetworkName.of((String)matchMap.get("project"), (String)matchMap.get("region"), (String)matchMap.get("subnetwork"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "region", this.region, "subnetwork", this.subnetwork});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectRegionSubnetworkName) {
            ProjectRegionSubnetworkName that = (ProjectRegionSubnetworkName)o;
            return Objects.equals(this.project, that.getProject()) && Objects.equals(this.region, that.getRegion()) && Objects.equals(this.subnetwork, that.getSubnetwork());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.project, this.region, this.subnetwork);
    }

    public static class Builder {
        private String project;
        private String region;
        private String subnetwork;

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public String getSubnetwork() {
            return this.subnetwork;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setSubnetwork(String subnetwork) {
            this.subnetwork = subnetwork;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectRegionSubnetworkName projectRegionSubnetworkName) {
            this.project = projectRegionSubnetworkName.project;
            this.region = projectRegionSubnetworkName.region;
            this.subnetwork = projectRegionSubnetworkName.subnetwork;
        }

        public ProjectRegionSubnetworkName build() {
            return new ProjectRegionSubnetworkName(this);
        }
    }
}

