/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.DistributionPolicyZoneConfiguration;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class DistributionPolicy
implements ApiMessage {
    private final List<DistributionPolicyZoneConfiguration> zones;
    private static final DistributionPolicy DEFAULT_INSTANCE = new DistributionPolicy();

    private DistributionPolicy() {
        this.zones = null;
    }

    private DistributionPolicy(List<DistributionPolicyZoneConfiguration> zones) {
        this.zones = zones;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("zones")) {
            return this.zones;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<DistributionPolicyZoneConfiguration> getZonesList() {
        return this.zones;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(DistributionPolicy prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static DistributionPolicy getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "DistributionPolicy{zones=" + this.zones + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DistributionPolicy) {
            DistributionPolicy that = (DistributionPolicy)o;
            return Objects.equals(this.zones, that.getZonesList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.zones);
    }

    public static class Builder {
        private List<DistributionPolicyZoneConfiguration> zones;

        Builder() {
        }

        public Builder mergeFrom(DistributionPolicy other) {
            if (other == DistributionPolicy.getDefaultInstance()) {
                return this;
            }
            if (other.getZonesList() != null) {
                this.zones = other.zones;
            }
            return this;
        }

        Builder(DistributionPolicy source) {
            this.zones = source.zones;
        }

        public List<DistributionPolicyZoneConfiguration> getZonesList() {
            return this.zones;
        }

        public Builder addAllZones(List<DistributionPolicyZoneConfiguration> zones) {
            if (this.zones == null) {
                this.zones = new LinkedList<DistributionPolicyZoneConfiguration>();
            }
            this.zones.addAll(zones);
            return this;
        }

        public Builder addZones(DistributionPolicyZoneConfiguration zones) {
            if (this.zones == null) {
                this.zones = new LinkedList<DistributionPolicyZoneConfiguration>();
            }
            this.zones.add(zones);
            return this;
        }

        public DistributionPolicy build() {
            return new DistributionPolicy(this.zones);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllZones(this.zones);
            return newBuilder;
        }
    }
}

