/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteInstanceTemplateHttpRequest;
import com.google.cloud.compute.v1.GetInstanceTemplateHttpRequest;
import com.google.cloud.compute.v1.InsertInstanceTemplateHttpRequest;
import com.google.cloud.compute.v1.InstanceTemplate;
import com.google.cloud.compute.v1.InstanceTemplateClient;
import com.google.cloud.compute.v1.InstanceTemplateList;
import com.google.cloud.compute.v1.ListInstanceTemplatesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.stub.HttpJsonInstanceTemplateStub;
import com.google.cloud.compute.v1.stub.InstanceTemplateStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class InstanceTemplateStubSettings
extends StubSettings<InstanceTemplateStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DeleteInstanceTemplateHttpRequest, Operation> deleteInstanceTemplateSettings;
    private final UnaryCallSettings<GetInstanceTemplateHttpRequest, InstanceTemplate> getInstanceTemplateSettings;
    private final UnaryCallSettings<InsertInstanceTemplateHttpRequest, Operation> insertInstanceTemplateSettings;
    private final PagedCallSettings<ListInstanceTemplatesHttpRequest, InstanceTemplateList, InstanceTemplateClient.ListInstanceTemplatesPagedResponse> listInstanceTemplatesSettings;
    private static final PagedListDescriptor<ListInstanceTemplatesHttpRequest, InstanceTemplateList, InstanceTemplate> LIST_INSTANCE_TEMPLATES_PAGE_STR_DESC = new PagedListDescriptor<ListInstanceTemplatesHttpRequest, InstanceTemplateList, InstanceTemplate>(){

        public String emptyToken() {
            return "";
        }

        public ListInstanceTemplatesHttpRequest injectToken(ListInstanceTemplatesHttpRequest payload, String token) {
            return ListInstanceTemplatesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListInstanceTemplatesHttpRequest injectPageSize(ListInstanceTemplatesHttpRequest payload, int pageSize) {
            return ListInstanceTemplatesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListInstanceTemplatesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(InstanceTemplateList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<InstanceTemplate> extractResources(InstanceTemplateList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListInstanceTemplatesHttpRequest, InstanceTemplateList, InstanceTemplateClient.ListInstanceTemplatesPagedResponse> LIST_INSTANCE_TEMPLATES_PAGE_STR_FACT = new PagedListResponseFactory<ListInstanceTemplatesHttpRequest, InstanceTemplateList, InstanceTemplateClient.ListInstanceTemplatesPagedResponse>(){

        public ApiFuture<InstanceTemplateClient.ListInstanceTemplatesPagedResponse> getFuturePagedResponse(UnaryCallable<ListInstanceTemplatesHttpRequest, InstanceTemplateList> callable, ListInstanceTemplatesHttpRequest request, ApiCallContext context, ApiFuture<InstanceTemplateList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INSTANCE_TEMPLATES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InstanceTemplateClient.ListInstanceTemplatesPagedResponse.createAsync((PageContext<ListInstanceTemplatesHttpRequest, InstanceTemplateList, InstanceTemplate>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteInstanceTemplateHttpRequest, Operation> deleteInstanceTemplateSettings() {
        return this.deleteInstanceTemplateSettings;
    }

    public UnaryCallSettings<GetInstanceTemplateHttpRequest, InstanceTemplate> getInstanceTemplateSettings() {
        return this.getInstanceTemplateSettings;
    }

    public UnaryCallSettings<InsertInstanceTemplateHttpRequest, Operation> insertInstanceTemplateSettings() {
        return this.insertInstanceTemplateSettings;
    }

    public PagedCallSettings<ListInstanceTemplatesHttpRequest, InstanceTemplateList, InstanceTemplateClient.ListInstanceTemplatesPagedResponse> listInstanceTemplatesSettings() {
        return this.listInstanceTemplatesSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public InstanceTemplateStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonInstanceTemplateStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return InstanceTemplateStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(InstanceTemplateStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected InstanceTemplateStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteInstanceTemplateSettings = settingsBuilder.deleteInstanceTemplateSettings().build();
        this.getInstanceTemplateSettings = settingsBuilder.getInstanceTemplateSettings().build();
        this.insertInstanceTemplateSettings = settingsBuilder.insertInstanceTemplateSettings().build();
        this.listInstanceTemplatesSettings = settingsBuilder.listInstanceTemplatesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<InstanceTemplateStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteInstanceTemplateHttpRequest, Operation> deleteInstanceTemplateSettings;
        private final UnaryCallSettings.Builder<GetInstanceTemplateHttpRequest, InstanceTemplate> getInstanceTemplateSettings;
        private final UnaryCallSettings.Builder<InsertInstanceTemplateHttpRequest, Operation> insertInstanceTemplateSettings;
        private final PagedCallSettings.Builder<ListInstanceTemplatesHttpRequest, InstanceTemplateList, InstanceTemplateClient.ListInstanceTemplatesPagedResponse> listInstanceTemplatesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteInstanceTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getInstanceTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertInstanceTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listInstanceTemplatesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INSTANCE_TEMPLATES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteInstanceTemplateSettings, this.getInstanceTemplateSettings, this.insertInstanceTemplateSettings, this.listInstanceTemplatesSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(InstanceTemplateStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)InstanceTemplateStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)InstanceTemplateStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(InstanceTemplateStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteInstanceTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getInstanceTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertInstanceTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listInstanceTemplatesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(InstanceTemplateStubSettings settings) {
            super((StubSettings)settings);
            this.deleteInstanceTemplateSettings = settings.deleteInstanceTemplateSettings.toBuilder();
            this.getInstanceTemplateSettings = settings.getInstanceTemplateSettings.toBuilder();
            this.insertInstanceTemplateSettings = settings.insertInstanceTemplateSettings.toBuilder();
            this.listInstanceTemplatesSettings = settings.listInstanceTemplatesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteInstanceTemplateSettings, this.getInstanceTemplateSettings, this.insertInstanceTemplateSettings, this.listInstanceTemplatesSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteInstanceTemplateHttpRequest, Operation> deleteInstanceTemplateSettings() {
            return this.deleteInstanceTemplateSettings;
        }

        public UnaryCallSettings.Builder<GetInstanceTemplateHttpRequest, InstanceTemplate> getInstanceTemplateSettings() {
            return this.getInstanceTemplateSettings;
        }

        public UnaryCallSettings.Builder<InsertInstanceTemplateHttpRequest, Operation> insertInstanceTemplateSettings() {
            return this.insertInstanceTemplateSettings;
        }

        public PagedCallSettings.Builder<ListInstanceTemplatesHttpRequest, InstanceTemplateList, InstanceTemplateClient.ListInstanceTemplatesPagedResponse> listInstanceTemplatesSettings() {
            return this.listInstanceTemplatesSettings;
        }

        public InstanceTemplateStubSettings build() throws IOException {
            return new InstanceTemplateStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

