/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.RouterBgp;
import com.google.cloud.compute.v1.RouterBgpPeer;
import com.google.cloud.compute.v1.RouterInterface;
import com.google.cloud.compute.v1.RouterNat;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class Router
implements ApiMessage {
    private final RouterBgp bgp;
    private final List<RouterBgpPeer> bgpPeers;
    private final String creationTimestamp;
    private final String description;
    private final String id;
    private final List<RouterInterface> interfaces;
    private final String kind;
    private final String name;
    private final List<RouterNat> nats;
    private final String network;
    private final String region;
    private final String selfLink;
    private static final Router DEFAULT_INSTANCE = new Router();

    private Router() {
        this.bgp = null;
        this.bgpPeers = null;
        this.creationTimestamp = null;
        this.description = null;
        this.id = null;
        this.interfaces = null;
        this.kind = null;
        this.name = null;
        this.nats = null;
        this.network = null;
        this.region = null;
        this.selfLink = null;
    }

    private Router(RouterBgp bgp, List<RouterBgpPeer> bgpPeers, String creationTimestamp, String description, String id, List<RouterInterface> interfaces, String kind, String name, List<RouterNat> nats, String network, String region, String selfLink) {
        this.bgp = bgp;
        this.bgpPeers = bgpPeers;
        this.creationTimestamp = creationTimestamp;
        this.description = description;
        this.id = id;
        this.interfaces = interfaces;
        this.kind = kind;
        this.name = name;
        this.nats = nats;
        this.network = network;
        this.region = region;
        this.selfLink = selfLink;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("bgp")) {
            return this.bgp;
        }
        if (fieldName.equals("bgpPeers")) {
            return this.bgpPeers;
        }
        if (fieldName.equals("creationTimestamp")) {
            return this.creationTimestamp;
        }
        if (fieldName.equals("description")) {
            return this.description;
        }
        if (fieldName.equals("id")) {
            return this.id;
        }
        if (fieldName.equals("interfaces")) {
            return this.interfaces;
        }
        if (fieldName.equals("kind")) {
            return this.kind;
        }
        if (fieldName.equals("name")) {
            return this.name;
        }
        if (fieldName.equals("nats")) {
            return this.nats;
        }
        if (fieldName.equals("network")) {
            return this.network;
        }
        if (fieldName.equals("region")) {
            return this.region;
        }
        if (fieldName.equals("selfLink")) {
            return this.selfLink;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public RouterBgp getBgp() {
        return this.bgp;
    }

    public List<RouterBgpPeer> getBgpPeersList() {
        return this.bgpPeers;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public List<RouterInterface> getInterfacesList() {
        return this.interfaces;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public List<RouterNat> getNatsList() {
        return this.nats;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getRegion() {
        return this.region;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Router prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static Router getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "Router{bgp=" + this.bgp + ", bgpPeers=" + this.bgpPeers + ", creationTimestamp=" + this.creationTimestamp + ", description=" + this.description + ", id=" + this.id + ", interfaces=" + this.interfaces + ", kind=" + this.kind + ", name=" + this.name + ", nats=" + this.nats + ", network=" + this.network + ", region=" + this.region + ", selfLink=" + this.selfLink + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Router) {
            Router that = (Router)o;
            return Objects.equals(this.bgp, that.getBgp()) && Objects.equals(this.bgpPeers, that.getBgpPeersList()) && Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.interfaces, that.getInterfacesList()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.nats, that.getNatsList()) && Objects.equals(this.network, that.getNetwork()) && Objects.equals(this.region, that.getRegion()) && Objects.equals(this.selfLink, that.getSelfLink());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.bgp, this.bgpPeers, this.creationTimestamp, this.description, this.id, this.interfaces, this.kind, this.name, this.nats, this.network, this.region, this.selfLink);
    }

    public static class Builder {
        private RouterBgp bgp;
        private List<RouterBgpPeer> bgpPeers;
        private String creationTimestamp;
        private String description;
        private String id;
        private List<RouterInterface> interfaces;
        private String kind;
        private String name;
        private List<RouterNat> nats;
        private String network;
        private String region;
        private String selfLink;

        Builder() {
        }

        public Builder mergeFrom(Router other) {
            if (other == Router.getDefaultInstance()) {
                return this;
            }
            if (other.getBgp() != null) {
                this.bgp = other.bgp;
            }
            if (other.getBgpPeersList() != null) {
                this.bgpPeers = other.bgpPeers;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getInterfacesList() != null) {
                this.interfaces = other.interfaces;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getNatsList() != null) {
                this.nats = other.nats;
            }
            if (other.getNetwork() != null) {
                this.network = other.network;
            }
            if (other.getRegion() != null) {
                this.region = other.region;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            return this;
        }

        Builder(Router source) {
            this.bgp = source.bgp;
            this.bgpPeers = source.bgpPeers;
            this.creationTimestamp = source.creationTimestamp;
            this.description = source.description;
            this.id = source.id;
            this.interfaces = source.interfaces;
            this.kind = source.kind;
            this.name = source.name;
            this.nats = source.nats;
            this.network = source.network;
            this.region = source.region;
            this.selfLink = source.selfLink;
        }

        public RouterBgp getBgp() {
            return this.bgp;
        }

        public Builder setBgp(RouterBgp bgp) {
            this.bgp = bgp;
            return this;
        }

        public List<RouterBgpPeer> getBgpPeersList() {
            return this.bgpPeers;
        }

        public Builder addAllBgpPeers(List<RouterBgpPeer> bgpPeers) {
            if (this.bgpPeers == null) {
                this.bgpPeers = new LinkedList<RouterBgpPeer>();
            }
            this.bgpPeers.addAll(bgpPeers);
            return this;
        }

        public Builder addBgpPeers(RouterBgpPeer bgpPeers) {
            if (this.bgpPeers == null) {
                this.bgpPeers = new LinkedList<RouterBgpPeer>();
            }
            this.bgpPeers.add(bgpPeers);
            return this;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public List<RouterInterface> getInterfacesList() {
            return this.interfaces;
        }

        public Builder addAllInterfaces(List<RouterInterface> interfaces) {
            if (this.interfaces == null) {
                this.interfaces = new LinkedList<RouterInterface>();
            }
            this.interfaces.addAll(interfaces);
            return this;
        }

        public Builder addInterfaces(RouterInterface interfaces) {
            if (this.interfaces == null) {
                this.interfaces = new LinkedList<RouterInterface>();
            }
            this.interfaces.add(interfaces);
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public List<RouterNat> getNatsList() {
            return this.nats;
        }

        public Builder addAllNats(List<RouterNat> nats) {
            if (this.nats == null) {
                this.nats = new LinkedList<RouterNat>();
            }
            this.nats.addAll(nats);
            return this;
        }

        public Builder addNats(RouterNat nats) {
            if (this.nats == null) {
                this.nats = new LinkedList<RouterNat>();
            }
            this.nats.add(nats);
            return this;
        }

        public String getNetwork() {
            return this.network;
        }

        public Builder setNetwork(String network) {
            this.network = network;
            return this;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public Router build() {
            return new Router(this.bgp, this.bgpPeers, this.creationTimestamp, this.description, this.id, this.interfaces, this.kind, this.name, this.nats, this.network, this.region, this.selfLink);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setBgp(this.bgp);
            newBuilder.addAllBgpPeers(this.bgpPeers);
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDescription(this.description);
            newBuilder.setId(this.id);
            newBuilder.addAllInterfaces(this.interfaces);
            newBuilder.setKind(this.kind);
            newBuilder.setName(this.name);
            newBuilder.addAllNats(this.nats);
            newBuilder.setNetwork(this.network);
            newBuilder.setRegion(this.region);
            newBuilder.setSelfLink(this.selfLink);
            return newBuilder;
        }
    }
}

