/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectRegionDiskName
implements ResourceName {
    private final String disk;
    private final String project;
    private final String region;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/regions/{region}/disks/{disk}");
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectRegionDiskName(Builder builder) {
        this.disk = (String)Preconditions.checkNotNull((Object)builder.getDisk());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
    }

    public static ProjectRegionDiskName of(String disk, String project, String region) {
        return ProjectRegionDiskName.newBuilder().setDisk(disk).setProject(project).setRegion(region).build();
    }

    public static String format(String disk, String project, String region) {
        return ProjectRegionDiskName.of(disk, project, region).toString();
    }

    public String getDisk() {
        return this.disk;
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectRegionDiskName projectRegionDiskName = this;
            synchronized (projectRegionDiskName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"disk", (Object)this.disk);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"region", (Object)this.region);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectRegionDiskName> newFactory() {
        return new ResourceNameFactory<ProjectRegionDiskName>(){

            public ProjectRegionDiskName parse(String formattedString) {
                return ProjectRegionDiskName.parse(formattedString);
            }
        };
    }

    public static ProjectRegionDiskName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ProjectRegionDiskName.parse: formattedString not in valid format");
        return ProjectRegionDiskName.of((String)matchMap.get("disk"), (String)matchMap.get("project"), (String)matchMap.get("region"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"disk", this.disk, "project", this.project, "region", this.region});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectRegionDiskName) {
            ProjectRegionDiskName that = (ProjectRegionDiskName)o;
            return Objects.equals(this.disk, that.getDisk()) && Objects.equals(this.project, that.getProject()) && Objects.equals(this.region, that.getRegion());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.disk, this.project, this.region);
    }

    public static class Builder {
        private String disk;
        private String project;
        private String region;

        public String getDisk() {
            return this.disk;
        }

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setDisk(String disk) {
            this.disk = disk;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectRegionDiskName projectRegionDiskName) {
            this.disk = projectRegionDiskName.disk;
            this.project = projectRegionDiskName.project;
            this.region = projectRegionDiskName.region;
        }

        public ProjectRegionDiskName build() {
            return new ProjectRegionDiskName(this);
        }
    }
}

