/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectGlobalImageFamilyName
implements ResourceName {
    private final String family;
    private final String project;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/global/images/family/{family}");
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectGlobalImageFamilyName(Builder builder) {
        this.family = (String)Preconditions.checkNotNull((Object)builder.getFamily());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
    }

    public static ProjectGlobalImageFamilyName of(String family, String project) {
        return ProjectGlobalImageFamilyName.newBuilder().setFamily(family).setProject(project).build();
    }

    public static String format(String family, String project) {
        return ProjectGlobalImageFamilyName.of(family, project).toString();
    }

    public String getFamily() {
        return this.family;
    }

    public String getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectGlobalImageFamilyName projectGlobalImageFamilyName = this;
            synchronized (projectGlobalImageFamilyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"family", (Object)this.family);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectGlobalImageFamilyName> newFactory() {
        return new ResourceNameFactory<ProjectGlobalImageFamilyName>(){

            public ProjectGlobalImageFamilyName parse(String formattedString) {
                return ProjectGlobalImageFamilyName.parse(formattedString);
            }
        };
    }

    public static ProjectGlobalImageFamilyName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ProjectGlobalImageFamilyName.parse: formattedString not in valid format");
        return ProjectGlobalImageFamilyName.of((String)matchMap.get("family"), (String)matchMap.get("project"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"family", this.family, "project", this.project});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectGlobalImageFamilyName) {
            ProjectGlobalImageFamilyName that = (ProjectGlobalImageFamilyName)o;
            return Objects.equals(this.family, that.getFamily()) && Objects.equals(this.project, that.getProject());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.family, this.project);
    }

    public static class Builder {
        private String family;
        private String project;

        public String getFamily() {
            return this.family;
        }

        public String getProject() {
            return this.project;
        }

        public Builder setFamily(String family) {
            this.family = family;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectGlobalImageFamilyName projectGlobalImageFamilyName) {
            this.family = projectGlobalImageFamilyName.family;
            this.project = projectGlobalImageFamilyName.project;
        }

        public ProjectGlobalImageFamilyName build() {
            return new ProjectGlobalImageFamilyName(this);
        }
    }
}

