/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.deprecated;

import com.google.api.core.ApiFunction;
import com.google.api.services.compute.model.Scheduling;
import com.google.cloud.StringEnumType;
import com.google.cloud.StringEnumValue;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;

public final class SchedulingOptions
implements Serializable {
    private static final long serialVersionUID = 4199610694227857331L;
    private final boolean automaticRestart;
    private final Maintenance maintenance;
    private final boolean isPreemptible;

    private SchedulingOptions(Boolean automaticRestart, Maintenance maintenance, Boolean isPreemptible) {
        this.automaticRestart = automaticRestart;
        this.maintenance = maintenance;
        this.isPreemptible = isPreemptible;
    }

    public Boolean automaticRestart() {
        return this.automaticRestart;
    }

    public Maintenance getMaintenance() {
        return this.maintenance;
    }

    public boolean isPreemptible() {
        return this.isPreemptible;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("automaticRestart", this.automaticRestart).add("maintenance", (Object)this.maintenance).add("isPreemptible", this.isPreemptible).toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.automaticRestart, this.maintenance, this.isPreemptible});
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof SchedulingOptions && Objects.equals(this.toPb(), ((SchedulingOptions)obj).toPb());
    }

    Scheduling toPb() {
        Scheduling schedulingPb = new Scheduling();
        schedulingPb.setAutomaticRestart(Boolean.valueOf(this.automaticRestart));
        schedulingPb.setPreemptible(Boolean.valueOf(this.isPreemptible));
        if (this.maintenance != null) {
            schedulingPb.setOnHostMaintenance(this.maintenance.name());
        }
        return schedulingPb;
    }

    public static SchedulingOptions preemptible() {
        return new SchedulingOptions(false, Maintenance.TERMINATE, true);
    }

    public static SchedulingOptions standard(boolean automaticRestart, Maintenance maintenance) {
        return new SchedulingOptions(automaticRestart, maintenance, false);
    }

    static SchedulingOptions fromPb(Scheduling schedPb) {
        Maintenance maintenance = null;
        if (schedPb.getOnHostMaintenance() != null) {
            maintenance = Maintenance.valueOf(schedPb.getOnHostMaintenance());
        }
        return new SchedulingOptions(schedPb.getAutomaticRestart(), maintenance, schedPb.getPreemptible());
    }

    public static final class Maintenance
    extends StringEnumValue {
        private static final long serialVersionUID = 1041388027965833378L;
        private static final ApiFunction<String, Maintenance> CONSTRUCTOR = new ApiFunction<String, Maintenance>(){

            public Maintenance apply(String constant) {
                return new Maintenance(constant);
            }
        };
        private static final StringEnumType<Maintenance> type = new StringEnumType(Maintenance.class, CONSTRUCTOR);
        public static final Maintenance MIGRATE = (Maintenance)((Object)type.createAndRegister("MIGRATE"));
        public static final Maintenance TERMINATE = (Maintenance)((Object)type.createAndRegister("TERMINATE"));

        private Maintenance(String constant) {
            super(constant);
        }

        public static Maintenance valueOfStrict(String constant) {
            return (Maintenance)((Object)type.valueOfStrict(constant));
        }

        public static Maintenance valueOf(String constant) {
            return (Maintenance)((Object)type.valueOf(constant));
        }

        public static Maintenance[] values() {
            return (Maintenance[])type.values();
        }
    }
}

