/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class DiskInstantiationConfig
implements ApiMessage {
    private final Boolean autoDelete;
    private final String customImage;
    private final String deviceName;
    private final String instantiateFrom;
    private static final DiskInstantiationConfig DEFAULT_INSTANCE = new DiskInstantiationConfig();

    private DiskInstantiationConfig() {
        this.autoDelete = null;
        this.customImage = null;
        this.deviceName = null;
        this.instantiateFrom = null;
    }

    private DiskInstantiationConfig(Boolean autoDelete, String customImage, String deviceName, String instantiateFrom) {
        this.autoDelete = autoDelete;
        this.customImage = customImage;
        this.deviceName = deviceName;
        this.instantiateFrom = instantiateFrom;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("autoDelete")) {
            return this.autoDelete;
        }
        if (fieldName.equals("customImage")) {
            return this.customImage;
        }
        if (fieldName.equals("deviceName")) {
            return this.deviceName;
        }
        if (fieldName.equals("instantiateFrom")) {
            return this.instantiateFrom;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Boolean getAutoDelete() {
        return this.autoDelete;
    }

    public String getCustomImage() {
        return this.customImage;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getInstantiateFrom() {
        return this.instantiateFrom;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(DiskInstantiationConfig prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static DiskInstantiationConfig getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "DiskInstantiationConfig{autoDelete=" + this.autoDelete + ", customImage=" + this.customImage + ", deviceName=" + this.deviceName + ", instantiateFrom=" + this.instantiateFrom + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DiskInstantiationConfig) {
            DiskInstantiationConfig that = (DiskInstantiationConfig)o;
            return Objects.equals(this.autoDelete, that.getAutoDelete()) && Objects.equals(this.customImage, that.getCustomImage()) && Objects.equals(this.deviceName, that.getDeviceName()) && Objects.equals(this.instantiateFrom, that.getInstantiateFrom());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.autoDelete, this.customImage, this.deviceName, this.instantiateFrom);
    }

    public static class Builder {
        private Boolean autoDelete;
        private String customImage;
        private String deviceName;
        private String instantiateFrom;

        Builder() {
        }

        public Builder mergeFrom(DiskInstantiationConfig other) {
            if (other == DiskInstantiationConfig.getDefaultInstance()) {
                return this;
            }
            if (other.getAutoDelete() != null) {
                this.autoDelete = other.autoDelete;
            }
            if (other.getCustomImage() != null) {
                this.customImage = other.customImage;
            }
            if (other.getDeviceName() != null) {
                this.deviceName = other.deviceName;
            }
            if (other.getInstantiateFrom() != null) {
                this.instantiateFrom = other.instantiateFrom;
            }
            return this;
        }

        Builder(DiskInstantiationConfig source) {
            this.autoDelete = source.autoDelete;
            this.customImage = source.customImage;
            this.deviceName = source.deviceName;
            this.instantiateFrom = source.instantiateFrom;
        }

        public Boolean getAutoDelete() {
            return this.autoDelete;
        }

        public Builder setAutoDelete(Boolean autoDelete) {
            this.autoDelete = autoDelete;
            return this;
        }

        public String getCustomImage() {
            return this.customImage;
        }

        public Builder setCustomImage(String customImage) {
            this.customImage = customImage;
            return this;
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public Builder setDeviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public String getInstantiateFrom() {
            return this.instantiateFrom;
        }

        public Builder setInstantiateFrom(String instantiateFrom) {
            this.instantiateFrom = instantiateFrom;
            return this;
        }

        public DiskInstantiationConfig build() {
            return new DiskInstantiationConfig(this.autoDelete, this.customImage, this.deviceName, this.instantiateFrom);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setAutoDelete(this.autoDelete);
            newBuilder.setCustomImage(this.customImage);
            newBuilder.setDeviceName(this.deviceName);
            newBuilder.setInstantiateFrom(this.instantiateFrom);
            return newBuilder;
        }
    }
}

