/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.Disk;
import com.google.cloud.compute.DiskConfiguration;
import com.google.cloud.compute.SnapshotId;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class SnapshotDiskConfiguration
extends DiskConfiguration {
    private static final long serialVersionUID = -1996055058706221049L;
    private final SnapshotId sourceSnapshot;
    private final String sourceSnapshotId;

    private SnapshotDiskConfiguration(Builder builder) {
        super(builder);
        this.sourceSnapshot = builder.sourceSnapshot;
        this.sourceSnapshotId = builder.sourceSnapshotId;
    }

    @Deprecated
    public SnapshotId sourceSnapshot() {
        return this.sourceSnapshot;
    }

    public SnapshotId getSourceSnapshot() {
        return this.sourceSnapshot;
    }

    @Deprecated
    public String sourceSnapshotId() {
        return this.sourceSnapshotId;
    }

    public String getSourceSnapshotId() {
        return this.sourceSnapshotId;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("sourceSnapshot", (Object)this.sourceSnapshot).add("sourceSnapshotId", (Object)this.sourceSnapshotId);
    }

    public final int hashCode() {
        return Objects.hash(this.baseHashCode(), this.sourceSnapshot, this.sourceSnapshotId);
    }

    public final boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(SnapshotDiskConfiguration.class) && this.baseEquals((SnapshotDiskConfiguration)obj);
    }

    @Override
    SnapshotDiskConfiguration setProjectId(String projectId) {
        Builder builder = this.toBuilder().setSourceSnapshot(this.sourceSnapshot.setProjectId(projectId));
        if (this.getDiskType() != null) {
            builder.setDiskType(this.getDiskType().setProjectId(projectId));
        }
        return builder.build();
    }

    @Override
    Disk toPb() {
        return super.toPb().setSourceSnapshot(this.sourceSnapshot.getSelfLink()).setSourceSnapshotId(this.sourceSnapshotId);
    }

    @Deprecated
    public static Builder builder(SnapshotId sourceSnapshot) {
        return SnapshotDiskConfiguration.newBuilder(sourceSnapshot);
    }

    public static Builder newBuilder(SnapshotId sourceSnapshot) {
        return new Builder(sourceSnapshot);
    }

    public static SnapshotDiskConfiguration of(SnapshotId sourceSnapshot) {
        return SnapshotDiskConfiguration.newBuilder(sourceSnapshot).build();
    }

    static SnapshotDiskConfiguration fromPb(Disk diskPb) {
        return new Builder(diskPb).build();
    }

    public static class Builder
    extends DiskConfiguration.Builder<SnapshotDiskConfiguration, Builder> {
        private SnapshotId sourceSnapshot;
        private String sourceSnapshotId;

        private Builder(SnapshotId sourceSnapshot) {
            super(DiskConfiguration.Type.SNAPSHOT);
            this.sourceSnapshot = (SnapshotId)Preconditions.checkNotNull((Object)sourceSnapshot);
        }

        private Builder(SnapshotDiskConfiguration configuration) {
            super(configuration);
            this.sourceSnapshot = configuration.sourceSnapshot;
            this.sourceSnapshotId = configuration.sourceSnapshotId;
        }

        private Builder(Disk diskPb) {
            super(DiskConfiguration.Type.SNAPSHOT, diskPb);
            this.sourceSnapshot = SnapshotId.fromUrl(diskPb.getSourceSnapshot());
            this.sourceSnapshotId = diskPb.getSourceSnapshotId();
        }

        @Override
        @Deprecated
        public Builder sizeGb(Long sizeGb) {
            return this.setSizeGb(sizeGb);
        }

        @Override
        public Builder setSizeGb(Long sizeGb) {
            super.setSizeGb(sizeGb);
            return this;
        }

        @Deprecated
        public Builder sourceSnapshot(SnapshotId sourceSnapshot) {
            return this.setSourceSnapshot(sourceSnapshot);
        }

        public Builder setSourceSnapshot(SnapshotId sourceSnapshot) {
            this.sourceSnapshot = (SnapshotId)Preconditions.checkNotNull((Object)sourceSnapshot);
            return this;
        }

        Builder setSourceSnapshotId(String sourceSnapshotId) {
            this.sourceSnapshotId = sourceSnapshotId;
            return this;
        }

        @Override
        public SnapshotDiskConfiguration build() {
            return new SnapshotDiskConfiguration(this);
        }
    }
}

