/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.Disk;
import com.google.cloud.compute.DiskTypeId;
import com.google.cloud.compute.ImageDiskConfiguration;
import com.google.cloud.compute.SnapshotDiskConfiguration;
import com.google.cloud.compute.StandardDiskConfiguration;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;

public abstract class DiskConfiguration
implements Serializable {
    private static final long serialVersionUID = -1783061701255428417L;
    private final Type type;
    private final Long sizeGb;
    private final DiskTypeId diskType;

    DiskConfiguration(Builder builder) {
        this.type = builder.type;
        this.sizeGb = builder.sizeGb;
        this.diskType = builder.diskType;
    }

    @Deprecated
    public Type type() {
        return this.getType();
    }

    public Type getType() {
        return this.type;
    }

    @Deprecated
    public Long sizeGb() {
        return this.getSizeGb();
    }

    public Long getSizeGb() {
        return this.sizeGb;
    }

    @Deprecated
    public DiskTypeId diskType() {
        return this.getDiskType();
    }

    public DiskTypeId getDiskType() {
        return this.diskType;
    }

    public abstract Builder toBuilder();

    MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("sizeGb", (Object)this.sizeGb).add("diskType", (Object)this.diskType);
    }

    public String toString() {
        return this.toStringHelper().toString();
    }

    final int baseHashCode() {
        return Objects.hash(new Object[]{this.type, this.sizeGb, this.diskType});
    }

    final boolean baseEquals(DiskConfiguration diskConfiguration) {
        return diskConfiguration != null && this.getClass().equals(diskConfiguration.getClass()) && Objects.equals(this.toPb(), diskConfiguration.toPb());
    }

    abstract DiskConfiguration setProjectId(String var1);

    Disk toPb() {
        Disk diskPb = new Disk();
        diskPb.setSizeGb(this.sizeGb);
        if (this.diskType != null) {
            diskPb.setType(this.diskType.getSelfLink());
        }
        return diskPb;
    }

    static <T extends DiskConfiguration> T fromPb(Disk diskPb) {
        if (diskPb.getSourceImage() != null) {
            return (T)ImageDiskConfiguration.fromPb(diskPb);
        }
        if (diskPb.getSourceSnapshot() != null) {
            return (T)SnapshotDiskConfiguration.fromPb(diskPb);
        }
        return (T)StandardDiskConfiguration.fromPb(diskPb);
    }

    public static abstract class Builder<T extends DiskConfiguration, B extends Builder<T, B>> {
        private Type type;
        private Long sizeGb;
        private DiskTypeId diskType;

        Builder(Type type) {
            this.type = type;
        }

        Builder(DiskConfiguration diskConfiguration) {
            this.type = diskConfiguration.type;
            this.sizeGb = diskConfiguration.sizeGb;
            this.diskType = diskConfiguration.diskType;
        }

        Builder(Type type, Disk diskPb) {
            this.type = type;
            this.sizeGb = diskPb.getSizeGb();
            if (diskPb.getType() != null) {
                this.diskType = DiskTypeId.fromUrl(diskPb.getType());
            }
        }

        protected B self() {
            return (B)this;
        }

        B setType(Type type) {
            this.type = type;
            return this.self();
        }

        @Deprecated
        public B sizeGb(Long sizeGb) {
            return this.setSizeGb(sizeGb);
        }

        public B setSizeGb(Long sizeGb) {
            this.sizeGb = sizeGb;
            return this.self();
        }

        @Deprecated
        public B diskType(DiskTypeId diskType) {
            return this.setDiskType(diskType);
        }

        public B setDiskType(DiskTypeId diskType) {
            this.diskType = diskType;
            return this.self();
        }

        public abstract T build();
    }

    public static enum Type {
        STANDARD,
        IMAGE,
        SNAPSHOT;

    }
}

