/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteLicenseHttpRequest;
import com.google.cloud.compute.v1.GetLicenseHttpRequest;
import com.google.cloud.compute.v1.InsertLicenseHttpRequest;
import com.google.cloud.compute.v1.License;
import com.google.cloud.compute.v1.LicenseClient;
import com.google.cloud.compute.v1.LicensesListResponse;
import com.google.cloud.compute.v1.ListLicensesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.TestIamPermissionsLicenseHttpRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.HttpJsonLicenseStub;
import com.google.cloud.compute.v1.stub.LicenseStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class LicenseStubSettings
extends StubSettings<LicenseStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DeleteLicenseHttpRequest, Operation> deleteLicenseSettings;
    private final UnaryCallSettings<GetLicenseHttpRequest, License> getLicenseSettings;
    private final UnaryCallSettings<InsertLicenseHttpRequest, Operation> insertLicenseSettings;
    private final PagedCallSettings<ListLicensesHttpRequest, LicensesListResponse, LicenseClient.ListLicensesPagedResponse> listLicensesSettings;
    private final UnaryCallSettings<TestIamPermissionsLicenseHttpRequest, TestPermissionsResponse> testIamPermissionsLicenseSettings;
    private static final PagedListDescriptor<ListLicensesHttpRequest, LicensesListResponse, License> LIST_LICENSES_PAGE_STR_DESC = new PagedListDescriptor<ListLicensesHttpRequest, LicensesListResponse, License>(){

        public String emptyToken() {
            return "";
        }

        public ListLicensesHttpRequest injectToken(ListLicensesHttpRequest payload, String token) {
            return ListLicensesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListLicensesHttpRequest injectPageSize(ListLicensesHttpRequest payload, int pageSize) {
            return ListLicensesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListLicensesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(LicensesListResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<License> extractResources(LicensesListResponse payload) {
            return payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<ListLicensesHttpRequest, LicensesListResponse, LicenseClient.ListLicensesPagedResponse> LIST_LICENSES_PAGE_STR_FACT = new PagedListResponseFactory<ListLicensesHttpRequest, LicensesListResponse, LicenseClient.ListLicensesPagedResponse>(){

        public ApiFuture<LicenseClient.ListLicensesPagedResponse> getFuturePagedResponse(UnaryCallable<ListLicensesHttpRequest, LicensesListResponse> callable, ListLicensesHttpRequest request, ApiCallContext context, ApiFuture<LicensesListResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LICENSES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return LicenseClient.ListLicensesPagedResponse.createAsync((PageContext<ListLicensesHttpRequest, LicensesListResponse, License>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteLicenseHttpRequest, Operation> deleteLicenseSettings() {
        return this.deleteLicenseSettings;
    }

    public UnaryCallSettings<GetLicenseHttpRequest, License> getLicenseSettings() {
        return this.getLicenseSettings;
    }

    public UnaryCallSettings<InsertLicenseHttpRequest, Operation> insertLicenseSettings() {
        return this.insertLicenseSettings;
    }

    public PagedCallSettings<ListLicensesHttpRequest, LicensesListResponse, LicenseClient.ListLicensesPagedResponse> listLicensesSettings() {
        return this.listLicensesSettings;
    }

    public UnaryCallSettings<TestIamPermissionsLicenseHttpRequest, TestPermissionsResponse> testIamPermissionsLicenseSettings() {
        return this.testIamPermissionsLicenseSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public LicenseStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonLicenseStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return LicenseStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(LicenseStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected LicenseStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteLicenseSettings = settingsBuilder.deleteLicenseSettings().build();
        this.getLicenseSettings = settingsBuilder.getLicenseSettings().build();
        this.insertLicenseSettings = settingsBuilder.insertLicenseSettings().build();
        this.listLicensesSettings = settingsBuilder.listLicensesSettings().build();
        this.testIamPermissionsLicenseSettings = settingsBuilder.testIamPermissionsLicenseSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<LicenseStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteLicenseHttpRequest, Operation> deleteLicenseSettings;
        private final UnaryCallSettings.Builder<GetLicenseHttpRequest, License> getLicenseSettings;
        private final UnaryCallSettings.Builder<InsertLicenseHttpRequest, Operation> insertLicenseSettings;
        private final PagedCallSettings.Builder<ListLicensesHttpRequest, LicensesListResponse, LicenseClient.ListLicensesPagedResponse> listLicensesSettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsLicenseHttpRequest, TestPermissionsResponse> testIamPermissionsLicenseSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteLicenseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getLicenseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertLicenseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLicensesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LICENSES_PAGE_STR_FACT);
            this.testIamPermissionsLicenseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteLicenseSettings, this.getLicenseSettings, this.insertLicenseSettings, this.listLicensesSettings, this.testIamPermissionsLicenseSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(LicenseStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)LicenseStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)LicenseStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(LicenseStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteLicenseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getLicenseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertLicenseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listLicensesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.testIamPermissionsLicenseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(LicenseStubSettings settings) {
            super((StubSettings)settings);
            this.deleteLicenseSettings = settings.deleteLicenseSettings.toBuilder();
            this.getLicenseSettings = settings.getLicenseSettings.toBuilder();
            this.insertLicenseSettings = settings.insertLicenseSettings.toBuilder();
            this.listLicensesSettings = settings.listLicensesSettings.toBuilder();
            this.testIamPermissionsLicenseSettings = settings.testIamPermissionsLicenseSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteLicenseSettings, this.getLicenseSettings, this.insertLicenseSettings, this.listLicensesSettings, this.testIamPermissionsLicenseSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteLicenseHttpRequest, Operation> deleteLicenseSettings() {
            return this.deleteLicenseSettings;
        }

        public UnaryCallSettings.Builder<GetLicenseHttpRequest, License> getLicenseSettings() {
            return this.getLicenseSettings;
        }

        public UnaryCallSettings.Builder<InsertLicenseHttpRequest, Operation> insertLicenseSettings() {
            return this.insertLicenseSettings;
        }

        public PagedCallSettings.Builder<ListLicensesHttpRequest, LicensesListResponse, LicenseClient.ListLicensesPagedResponse> listLicensesSettings() {
            return this.listLicensesSettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsLicenseHttpRequest, TestPermissionsResponse> testIamPermissionsLicenseSettings() {
            return this.testIamPermissionsLicenseSettings;
        }

        public LicenseStubSettings build() throws IOException {
            return new LicenseStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

