/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.GetZoneHttpRequest;
import com.google.cloud.compute.v1.ListZonesHttpRequest;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectZoneName;
import com.google.cloud.compute.v1.Zone;
import com.google.cloud.compute.v1.ZoneList;
import com.google.cloud.compute.v1.ZoneSettings;
import com.google.cloud.compute.v1.stub.ZoneStub;
import com.google.cloud.compute.v1.stub.ZoneStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ZoneClient
implements BackgroundResource {
    private final ZoneSettings settings;
    private final ZoneStub stub;

    public static final ZoneClient create() throws IOException {
        return ZoneClient.create(ZoneSettings.newBuilder().build());
    }

    public static final ZoneClient create(ZoneSettings settings) throws IOException {
        return new ZoneClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ZoneClient create(ZoneStub stub) {
        return new ZoneClient(stub);
    }

    protected ZoneClient(ZoneSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ZoneStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ZoneClient(ZoneStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ZoneSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ZoneStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Zone getZone(ProjectZoneName zone) {
        GetZoneHttpRequest request = GetZoneHttpRequest.newBuilder().setZone(zone == null ? null : zone.toString()).build();
        return this.getZone(request);
    }

    @BetaApi
    public final Zone getZone(String zone) {
        GetZoneHttpRequest request = GetZoneHttpRequest.newBuilder().setZone(zone).build();
        return this.getZone(request);
    }

    @BetaApi
    public final Zone getZone(GetZoneHttpRequest request) {
        return (Zone)this.getZoneCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetZoneHttpRequest, Zone> getZoneCallable() {
        return this.stub.getZoneCallable();
    }

    @BetaApi
    public final ListZonesPagedResponse listZones(ProjectName project) {
        ListZonesHttpRequest request = ListZonesHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listZones(request);
    }

    @BetaApi
    public final ListZonesPagedResponse listZones(String project) {
        ListZonesHttpRequest request = ListZonesHttpRequest.newBuilder().setProject(project).build();
        return this.listZones(request);
    }

    @BetaApi
    public final ListZonesPagedResponse listZones(ListZonesHttpRequest request) {
        return (ListZonesPagedResponse)((Object)this.listZonesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListZonesHttpRequest, ListZonesPagedResponse> listZonesPagedCallable() {
        return this.stub.listZonesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListZonesHttpRequest, ZoneList> listZonesCallable() {
        return this.stub.listZonesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListZonesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListZonesHttpRequest, ZoneList, Zone, ListZonesPage, ListZonesFixedSizeCollection> {
        private ListZonesFixedSizeCollection(List<ListZonesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListZonesFixedSizeCollection createEmptyCollection() {
            return new ListZonesFixedSizeCollection(null, 0);
        }

        protected ListZonesFixedSizeCollection createCollection(List<ListZonesPage> pages, int collectionSize) {
            return new ListZonesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListZonesPage
    extends AbstractPage<ListZonesHttpRequest, ZoneList, Zone, ListZonesPage> {
        private ListZonesPage(PageContext<ListZonesHttpRequest, ZoneList, Zone> context, ZoneList response) {
            super(context, (Object)response);
        }

        private static ListZonesPage createEmptyPage() {
            return new ListZonesPage(null, null);
        }

        protected ListZonesPage createPage(PageContext<ListZonesHttpRequest, ZoneList, Zone> context, ZoneList response) {
            return new ListZonesPage(context, response);
        }

        public ApiFuture<ListZonesPage> createPageAsync(PageContext<ListZonesHttpRequest, ZoneList, Zone> context, ApiFuture<ZoneList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListZonesPagedResponse
    extends AbstractPagedListResponse<ListZonesHttpRequest, ZoneList, Zone, ListZonesPage, ListZonesFixedSizeCollection> {
        public static ApiFuture<ListZonesPagedResponse> createAsync(PageContext<ListZonesHttpRequest, ZoneList, Zone> context, ApiFuture<ZoneList> futureResponse) {
            ApiFuture<ListZonesPage> futurePage = ListZonesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListZonesPage, ListZonesPagedResponse>(){

                public ListZonesPagedResponse apply(ListZonesPage input) {
                    return new ListZonesPagedResponse(input);
                }
            });
        }

        private ListZonesPagedResponse(ListZonesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListZonesFixedSizeCollection.createEmptyCollection());
        }
    }
}

