/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRouteHttpRequest;
import com.google.cloud.compute.v1.GetRouteHttpRequest;
import com.google.cloud.compute.v1.InsertRouteHttpRequest;
import com.google.cloud.compute.v1.ListRoutesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.ProjectGlobalRouteName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.Route;
import com.google.cloud.compute.v1.RouteList;
import com.google.cloud.compute.v1.RouteSettings;
import com.google.cloud.compute.v1.stub.RouteStub;
import com.google.cloud.compute.v1.stub.RouteStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class RouteClient
implements BackgroundResource {
    private final RouteSettings settings;
    private final RouteStub stub;

    public static final RouteClient create() throws IOException {
        return RouteClient.create(RouteSettings.newBuilder().build());
    }

    public static final RouteClient create(RouteSettings settings) throws IOException {
        return new RouteClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RouteClient create(RouteStub stub) {
        return new RouteClient(stub);
    }

    protected RouteClient(RouteSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RouteStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RouteClient(RouteStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RouteSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RouteStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation deleteRoute(ProjectGlobalRouteName route) {
        DeleteRouteHttpRequest request = DeleteRouteHttpRequest.newBuilder().setRoute(route == null ? null : route.toString()).build();
        return this.deleteRoute(request);
    }

    @BetaApi
    public final Operation deleteRoute(String route) {
        DeleteRouteHttpRequest request = DeleteRouteHttpRequest.newBuilder().setRoute(route).build();
        return this.deleteRoute(request);
    }

    @BetaApi
    public final Operation deleteRoute(DeleteRouteHttpRequest request) {
        return (Operation)this.deleteRouteCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteRouteHttpRequest, Operation> deleteRouteCallable() {
        return this.stub.deleteRouteCallable();
    }

    @BetaApi
    public final Route getRoute(ProjectGlobalRouteName route) {
        GetRouteHttpRequest request = GetRouteHttpRequest.newBuilder().setRoute(route == null ? null : route.toString()).build();
        return this.getRoute(request);
    }

    @BetaApi
    public final Route getRoute(String route) {
        GetRouteHttpRequest request = GetRouteHttpRequest.newBuilder().setRoute(route).build();
        return this.getRoute(request);
    }

    @BetaApi
    public final Route getRoute(GetRouteHttpRequest request) {
        return (Route)this.getRouteCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetRouteHttpRequest, Route> getRouteCallable() {
        return this.stub.getRouteCallable();
    }

    @BetaApi
    public final Operation insertRoute(ProjectName project, Route routeResource) {
        InsertRouteHttpRequest request = InsertRouteHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).setRouteResource(routeResource).build();
        return this.insertRoute(request);
    }

    @BetaApi
    public final Operation insertRoute(String project, Route routeResource) {
        InsertRouteHttpRequest request = InsertRouteHttpRequest.newBuilder().setProject(project).setRouteResource(routeResource).build();
        return this.insertRoute(request);
    }

    @BetaApi
    public final Operation insertRoute(InsertRouteHttpRequest request) {
        return (Operation)this.insertRouteCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertRouteHttpRequest, Operation> insertRouteCallable() {
        return this.stub.insertRouteCallable();
    }

    @BetaApi
    public final ListRoutesPagedResponse listRoutes(ProjectName project) {
        ListRoutesHttpRequest request = ListRoutesHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listRoutes(request);
    }

    @BetaApi
    public final ListRoutesPagedResponse listRoutes(String project) {
        ListRoutesHttpRequest request = ListRoutesHttpRequest.newBuilder().setProject(project).build();
        return this.listRoutes(request);
    }

    @BetaApi
    public final ListRoutesPagedResponse listRoutes(ListRoutesHttpRequest request) {
        return (ListRoutesPagedResponse)((Object)this.listRoutesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListRoutesHttpRequest, ListRoutesPagedResponse> listRoutesPagedCallable() {
        return this.stub.listRoutesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListRoutesHttpRequest, RouteList> listRoutesCallable() {
        return this.stub.listRoutesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListRoutesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRoutesHttpRequest, RouteList, Route, ListRoutesPage, ListRoutesFixedSizeCollection> {
        private ListRoutesFixedSizeCollection(List<ListRoutesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRoutesFixedSizeCollection createEmptyCollection() {
            return new ListRoutesFixedSizeCollection(null, 0);
        }

        protected ListRoutesFixedSizeCollection createCollection(List<ListRoutesPage> pages, int collectionSize) {
            return new ListRoutesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRoutesPage
    extends AbstractPage<ListRoutesHttpRequest, RouteList, Route, ListRoutesPage> {
        private ListRoutesPage(PageContext<ListRoutesHttpRequest, RouteList, Route> context, RouteList response) {
            super(context, (Object)response);
        }

        private static ListRoutesPage createEmptyPage() {
            return new ListRoutesPage(null, null);
        }

        protected ListRoutesPage createPage(PageContext<ListRoutesHttpRequest, RouteList, Route> context, RouteList response) {
            return new ListRoutesPage(context, response);
        }

        public ApiFuture<ListRoutesPage> createPageAsync(PageContext<ListRoutesHttpRequest, RouteList, Route> context, ApiFuture<RouteList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRoutesPagedResponse
    extends AbstractPagedListResponse<ListRoutesHttpRequest, RouteList, Route, ListRoutesPage, ListRoutesFixedSizeCollection> {
        public static ApiFuture<ListRoutesPagedResponse> createAsync(PageContext<ListRoutesHttpRequest, RouteList, Route> context, ApiFuture<RouteList> futureResponse) {
            ApiFuture<ListRoutesPage> futurePage = ListRoutesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListRoutesPage, ListRoutesPagedResponse>(){

                public ListRoutesPagedResponse apply(ListRoutesPage input) {
                    return new ListRoutesPagedResponse(input);
                }
            });
        }

        private ListRoutesPagedResponse(ListRoutesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRoutesFixedSizeCollection.createEmptyCollection());
        }
    }
}

