/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectGlobalSslCertificateName
implements ResourceName {
    private final String project;
    private final String sslCertificate;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/global/sslCertificates/{sslCertificate}");
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectGlobalSslCertificateName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.sslCertificate = (String)Preconditions.checkNotNull((Object)builder.getSslCertificate());
    }

    public static ProjectGlobalSslCertificateName of(String project, String sslCertificate) {
        return ProjectGlobalSslCertificateName.newBuilder().setProject(project).setSslCertificate(sslCertificate).build();
    }

    public static String format(String project, String sslCertificate) {
        return ProjectGlobalSslCertificateName.of(project, sslCertificate).toString();
    }

    public String getProject() {
        return this.project;
    }

    public String getSslCertificate() {
        return this.sslCertificate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectGlobalSslCertificateName projectGlobalSslCertificateName = this;
            synchronized (projectGlobalSslCertificateName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"sslCertificate", (Object)this.sslCertificate);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectGlobalSslCertificateName> newFactory() {
        return new ResourceNameFactory<ProjectGlobalSslCertificateName>(){

            public ProjectGlobalSslCertificateName parse(String formattedString) {
                return ProjectGlobalSslCertificateName.parse(formattedString);
            }
        };
    }

    public static ProjectGlobalSslCertificateName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ProjectGlobalSslCertificateName.parse: formattedString not in valid format");
        return ProjectGlobalSslCertificateName.of((String)matchMap.get("project"), (String)matchMap.get("sslCertificate"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "sslCertificate", this.sslCertificate});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectGlobalSslCertificateName) {
            ProjectGlobalSslCertificateName that = (ProjectGlobalSslCertificateName)o;
            return Objects.equals(this.project, that.getProject()) && Objects.equals(this.sslCertificate, that.getSslCertificate());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.project, this.sslCertificate);
    }

    public static class Builder {
        private String project;
        private String sslCertificate;

        public String getProject() {
            return this.project;
        }

        public String getSslCertificate() {
            return this.sslCertificate;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setSslCertificate(String sslCertificate) {
            this.sslCertificate = sslCertificate;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectGlobalSslCertificateName projectGlobalSslCertificateName) {
            this.project = projectGlobalSslCertificateName.project;
            this.sslCertificate = projectGlobalSslCertificateName.sslCertificate;
        }

        public ProjectGlobalSslCertificateName build() {
            return new ProjectGlobalSslCertificateName(this);
        }
    }
}

