/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectGlobalNetworkName
implements ResourceName {
    private final String network;
    private final String project;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/global/networks/{network}");
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectGlobalNetworkName(Builder builder) {
        this.network = (String)Preconditions.checkNotNull((Object)builder.getNetwork());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
    }

    public static ProjectGlobalNetworkName of(String network, String project) {
        return ProjectGlobalNetworkName.newBuilder().setNetwork(network).setProject(project).build();
    }

    public static String format(String network, String project) {
        return ProjectGlobalNetworkName.of(network, project).toString();
    }

    public String getNetwork() {
        return this.network;
    }

    public String getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectGlobalNetworkName projectGlobalNetworkName = this;
            synchronized (projectGlobalNetworkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"network", (Object)this.network);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectGlobalNetworkName> newFactory() {
        return new ResourceNameFactory<ProjectGlobalNetworkName>(){

            public ProjectGlobalNetworkName parse(String formattedString) {
                return ProjectGlobalNetworkName.parse(formattedString);
            }
        };
    }

    public static ProjectGlobalNetworkName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ProjectGlobalNetworkName.parse: formattedString not in valid format");
        return ProjectGlobalNetworkName.of((String)matchMap.get("network"), (String)matchMap.get("project"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"network", this.network, "project", this.project});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectGlobalNetworkName) {
            ProjectGlobalNetworkName that = (ProjectGlobalNetworkName)o;
            return Objects.equals(this.network, that.getNetwork()) && Objects.equals(this.project, that.getProject());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.network, this.project);
    }

    public static class Builder {
        private String network;
        private String project;

        public String getNetwork() {
            return this.network;
        }

        public String getProject() {
            return this.project;
        }

        public Builder setNetwork(String network) {
            this.network = network;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectGlobalNetworkName projectGlobalNetworkName) {
            this.network = projectGlobalNetworkName.network;
            this.project = projectGlobalNetworkName.project;
        }

        public ProjectGlobalNetworkName build() {
            return new ProjectGlobalNetworkName(this);
        }
    }
}

