/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.CacheKeyPolicy;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class BackendServiceCdnPolicy
implements ApiMessage {
    private final CacheKeyPolicy cacheKeyPolicy;
    private final String signedUrlCacheMaxAgeSec;
    private final List<String> signedUrlKeyNames;
    private static final BackendServiceCdnPolicy DEFAULT_INSTANCE = new BackendServiceCdnPolicy();

    private BackendServiceCdnPolicy() {
        this.cacheKeyPolicy = null;
        this.signedUrlCacheMaxAgeSec = null;
        this.signedUrlKeyNames = null;
    }

    private BackendServiceCdnPolicy(CacheKeyPolicy cacheKeyPolicy, String signedUrlCacheMaxAgeSec, List<String> signedUrlKeyNames) {
        this.cacheKeyPolicy = cacheKeyPolicy;
        this.signedUrlCacheMaxAgeSec = signedUrlCacheMaxAgeSec;
        this.signedUrlKeyNames = signedUrlKeyNames;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("cacheKeyPolicy")) {
            return this.cacheKeyPolicy;
        }
        if (fieldName.equals("signedUrlCacheMaxAgeSec")) {
            return this.signedUrlCacheMaxAgeSec;
        }
        if (fieldName.equals("signedUrlKeyNames")) {
            return this.signedUrlKeyNames;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public CacheKeyPolicy getCacheKeyPolicy() {
        return this.cacheKeyPolicy;
    }

    public String getSignedUrlCacheMaxAgeSec() {
        return this.signedUrlCacheMaxAgeSec;
    }

    public List<String> getSignedUrlKeyNamesList() {
        return this.signedUrlKeyNames;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(BackendServiceCdnPolicy prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static BackendServiceCdnPolicy getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "BackendServiceCdnPolicy{cacheKeyPolicy=" + this.cacheKeyPolicy + ", signedUrlCacheMaxAgeSec=" + this.signedUrlCacheMaxAgeSec + ", signedUrlKeyNames=" + this.signedUrlKeyNames + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BackendServiceCdnPolicy) {
            BackendServiceCdnPolicy that = (BackendServiceCdnPolicy)o;
            return Objects.equals(this.cacheKeyPolicy, that.getCacheKeyPolicy()) && Objects.equals(this.signedUrlCacheMaxAgeSec, that.getSignedUrlCacheMaxAgeSec()) && Objects.equals(this.signedUrlKeyNames, that.getSignedUrlKeyNamesList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.cacheKeyPolicy, this.signedUrlCacheMaxAgeSec, this.signedUrlKeyNames);
    }

    public static class Builder {
        private CacheKeyPolicy cacheKeyPolicy;
        private String signedUrlCacheMaxAgeSec;
        private List<String> signedUrlKeyNames;

        Builder() {
        }

        public Builder mergeFrom(BackendServiceCdnPolicy other) {
            if (other == BackendServiceCdnPolicy.getDefaultInstance()) {
                return this;
            }
            if (other.getCacheKeyPolicy() != null) {
                this.cacheKeyPolicy = other.cacheKeyPolicy;
            }
            if (other.getSignedUrlCacheMaxAgeSec() != null) {
                this.signedUrlCacheMaxAgeSec = other.signedUrlCacheMaxAgeSec;
            }
            if (other.getSignedUrlKeyNamesList() != null) {
                this.signedUrlKeyNames = other.signedUrlKeyNames;
            }
            return this;
        }

        Builder(BackendServiceCdnPolicy source) {
            this.cacheKeyPolicy = source.cacheKeyPolicy;
            this.signedUrlCacheMaxAgeSec = source.signedUrlCacheMaxAgeSec;
            this.signedUrlKeyNames = source.signedUrlKeyNames;
        }

        public CacheKeyPolicy getCacheKeyPolicy() {
            return this.cacheKeyPolicy;
        }

        public Builder setCacheKeyPolicy(CacheKeyPolicy cacheKeyPolicy) {
            this.cacheKeyPolicy = cacheKeyPolicy;
            return this;
        }

        public String getSignedUrlCacheMaxAgeSec() {
            return this.signedUrlCacheMaxAgeSec;
        }

        public Builder setSignedUrlCacheMaxAgeSec(String signedUrlCacheMaxAgeSec) {
            this.signedUrlCacheMaxAgeSec = signedUrlCacheMaxAgeSec;
            return this;
        }

        public List<String> getSignedUrlKeyNamesList() {
            return this.signedUrlKeyNames;
        }

        public Builder addAllSignedUrlKeyNames(List<String> signedUrlKeyNames) {
            if (this.signedUrlKeyNames == null) {
                this.signedUrlKeyNames = new LinkedList<String>();
            }
            this.signedUrlKeyNames.addAll(signedUrlKeyNames);
            return this;
        }

        public Builder addSignedUrlKeyNames(String signedUrlKeyNames) {
            if (this.signedUrlKeyNames == null) {
                this.signedUrlKeyNames = new LinkedList<String>();
            }
            this.signedUrlKeyNames.add(signedUrlKeyNames);
            return this;
        }

        public BackendServiceCdnPolicy build() {
            return new BackendServiceCdnPolicy(this.cacheKeyPolicy, this.signedUrlCacheMaxAgeSec, this.signedUrlKeyNames);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCacheKeyPolicy(this.cacheKeyPolicy);
            newBuilder.setSignedUrlCacheMaxAgeSec(this.signedUrlCacheMaxAgeSec);
            newBuilder.addAllSignedUrlKeyNames(this.signedUrlKeyNames);
            return newBuilder;
        }
    }
}

