/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.deprecated;

import com.google.cloud.compute.deprecated.AddressId;
import com.google.cloud.compute.deprecated.AddressInfo;
import com.google.cloud.compute.deprecated.Compute;
import com.google.cloud.compute.deprecated.ComputeOptions;
import com.google.cloud.compute.deprecated.Operation;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Objects;

public class Address
extends AddressInfo {
    private static final long serialVersionUID = 3457542817554062712L;
    private final ComputeOptions options;
    private transient Compute compute;

    Address(Compute compute, AddressInfo.BuilderImpl infoBuilder) {
        super(infoBuilder);
        this.compute = (Compute)Preconditions.checkNotNull((Object)compute);
        this.options = (ComputeOptions)compute.getOptions();
    }

    public boolean exists() {
        return this.reload(Compute.AddressOption.fields(new Compute.AddressField[0])) != null;
    }

    public Address reload(Compute.AddressOption ... options) {
        return this.compute.getAddress((AddressId)this.getAddressId(), options);
    }

    public Operation delete(Compute.OperationOption ... options) {
        return this.compute.deleteAddress((AddressId)this.getAddressId(), options);
    }

    public Compute getCompute() {
        return this.compute;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Address.class)) {
            return false;
        }
        Address other = (Address)obj;
        return Objects.equals(this.toPb(), other.toPb()) && Objects.equals((Object)this.options, (Object)other.options);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.options});
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.compute = (Compute)this.options.getService();
    }

    static Address fromPb(Compute compute, com.google.api.services.compute.model.Address addressPb) {
        return new Address(compute, new AddressInfo.BuilderImpl(addressPb));
    }

    public static class Builder
    extends AddressInfo.Builder {
        private final Compute compute;
        private final AddressInfo.BuilderImpl infoBuilder;

        Builder(Compute compute, AddressId addressId) {
            this.compute = compute;
            this.infoBuilder = new AddressInfo.BuilderImpl();
            this.infoBuilder.setAddressId(addressId);
        }

        Builder(Address address) {
            this.compute = address.compute;
            this.infoBuilder = new AddressInfo.BuilderImpl(address);
        }

        @Override
        public Builder setAddress(String address) {
            this.infoBuilder.setAddress(address);
            return this;
        }

        @Override
        Builder setCreationTimestamp(Long creationTimestamp) {
            this.infoBuilder.setCreationTimestamp(creationTimestamp);
            return this;
        }

        @Override
        public Builder setDescription(String description) {
            this.infoBuilder.setDescription(description);
            return this;
        }

        @Override
        Builder setGeneratedId(String generatedId) {
            this.infoBuilder.setGeneratedId(generatedId);
            return this;
        }

        @Override
        public Builder setAddressId(AddressId addressId) {
            this.infoBuilder.setAddressId(addressId);
            return this;
        }

        @Override
        Builder setStatus(AddressInfo.Status status) {
            this.infoBuilder.setStatus(status);
            return this;
        }

        @Override
        Builder setUsage(AddressInfo.Usage usage) {
            this.infoBuilder.setUsage(usage);
            return this;
        }

        @Override
        public Address build() {
            return new Address(this.compute, this.infoBuilder);
        }
    }
}

