/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddHealthCheckTargetPoolHttpRequest;
import com.google.cloud.compute.v1.AddInstanceTargetPoolHttpRequest;
import com.google.cloud.compute.v1.AggregatedListTargetPoolsHttpRequest;
import com.google.cloud.compute.v1.DeleteTargetPoolHttpRequest;
import com.google.cloud.compute.v1.GetHealthTargetPoolHttpRequest;
import com.google.cloud.compute.v1.GetTargetPoolHttpRequest;
import com.google.cloud.compute.v1.InsertTargetPoolHttpRequest;
import com.google.cloud.compute.v1.InstanceReference;
import com.google.cloud.compute.v1.ListTargetPoolsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.ProjectRegionTargetPoolName;
import com.google.cloud.compute.v1.RemoveHealthCheckTargetPoolHttpRequest;
import com.google.cloud.compute.v1.RemoveInstanceTargetPoolHttpRequest;
import com.google.cloud.compute.v1.SetBackupTargetPoolHttpRequest;
import com.google.cloud.compute.v1.TargetPool;
import com.google.cloud.compute.v1.TargetPoolAggregatedList;
import com.google.cloud.compute.v1.TargetPoolInstanceHealth;
import com.google.cloud.compute.v1.TargetPoolList;
import com.google.cloud.compute.v1.TargetPoolSettings;
import com.google.cloud.compute.v1.TargetPoolsAddHealthCheckRequest;
import com.google.cloud.compute.v1.TargetPoolsAddInstanceRequest;
import com.google.cloud.compute.v1.TargetPoolsRemoveHealthCheckRequest;
import com.google.cloud.compute.v1.TargetPoolsRemoveInstanceRequest;
import com.google.cloud.compute.v1.TargetPoolsScopedList;
import com.google.cloud.compute.v1.TargetReference;
import com.google.cloud.compute.v1.stub.TargetPoolStub;
import com.google.cloud.compute.v1.stub.TargetPoolStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class TargetPoolClient
implements BackgroundResource {
    private final TargetPoolSettings settings;
    private final TargetPoolStub stub;

    public static final TargetPoolClient create() throws IOException {
        return TargetPoolClient.create(TargetPoolSettings.newBuilder().build());
    }

    public static final TargetPoolClient create(TargetPoolSettings settings) throws IOException {
        return new TargetPoolClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final TargetPoolClient create(TargetPoolStub stub) {
        return new TargetPoolClient(stub);
    }

    protected TargetPoolClient(TargetPoolSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TargetPoolStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected TargetPoolClient(TargetPoolStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TargetPoolSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TargetPoolStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation addHealthCheckTargetPool(ProjectRegionTargetPoolName targetPool, TargetPoolsAddHealthCheckRequest targetPoolsAddHealthCheckRequestResource) {
        AddHealthCheckTargetPoolHttpRequest request = AddHealthCheckTargetPoolHttpRequest.newBuilder().setTargetPool(targetPool == null ? null : targetPool.toString()).setTargetPoolsAddHealthCheckRequestResource(targetPoolsAddHealthCheckRequestResource).build();
        return this.addHealthCheckTargetPool(request);
    }

    @BetaApi
    public final Operation addHealthCheckTargetPool(String targetPool, TargetPoolsAddHealthCheckRequest targetPoolsAddHealthCheckRequestResource) {
        AddHealthCheckTargetPoolHttpRequest request = AddHealthCheckTargetPoolHttpRequest.newBuilder().setTargetPool(targetPool).setTargetPoolsAddHealthCheckRequestResource(targetPoolsAddHealthCheckRequestResource).build();
        return this.addHealthCheckTargetPool(request);
    }

    @BetaApi
    public final Operation addHealthCheckTargetPool(AddHealthCheckTargetPoolHttpRequest request) {
        return (Operation)this.addHealthCheckTargetPoolCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<AddHealthCheckTargetPoolHttpRequest, Operation> addHealthCheckTargetPoolCallable() {
        return this.stub.addHealthCheckTargetPoolCallable();
    }

    @BetaApi
    public final Operation addInstanceTargetPool(ProjectRegionTargetPoolName targetPool, TargetPoolsAddInstanceRequest targetPoolsAddInstanceRequestResource) {
        AddInstanceTargetPoolHttpRequest request = AddInstanceTargetPoolHttpRequest.newBuilder().setTargetPool(targetPool == null ? null : targetPool.toString()).setTargetPoolsAddInstanceRequestResource(targetPoolsAddInstanceRequestResource).build();
        return this.addInstanceTargetPool(request);
    }

    @BetaApi
    public final Operation addInstanceTargetPool(String targetPool, TargetPoolsAddInstanceRequest targetPoolsAddInstanceRequestResource) {
        AddInstanceTargetPoolHttpRequest request = AddInstanceTargetPoolHttpRequest.newBuilder().setTargetPool(targetPool).setTargetPoolsAddInstanceRequestResource(targetPoolsAddInstanceRequestResource).build();
        return this.addInstanceTargetPool(request);
    }

    @BetaApi
    public final Operation addInstanceTargetPool(AddInstanceTargetPoolHttpRequest request) {
        return (Operation)this.addInstanceTargetPoolCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<AddInstanceTargetPoolHttpRequest, Operation> addInstanceTargetPoolCallable() {
        return this.stub.addInstanceTargetPoolCallable();
    }

    @BetaApi
    public final AggregatedListTargetPoolsPagedResponse aggregatedListTargetPools(ProjectName project) {
        AggregatedListTargetPoolsHttpRequest request = AggregatedListTargetPoolsHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.aggregatedListTargetPools(request);
    }

    @BetaApi
    public final AggregatedListTargetPoolsPagedResponse aggregatedListTargetPools(String project) {
        AggregatedListTargetPoolsHttpRequest request = AggregatedListTargetPoolsHttpRequest.newBuilder().setProject(project).build();
        return this.aggregatedListTargetPools(request);
    }

    @BetaApi
    public final AggregatedListTargetPoolsPagedResponse aggregatedListTargetPools(AggregatedListTargetPoolsHttpRequest request) {
        return (AggregatedListTargetPoolsPagedResponse)((Object)this.aggregatedListTargetPoolsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<AggregatedListTargetPoolsHttpRequest, AggregatedListTargetPoolsPagedResponse> aggregatedListTargetPoolsPagedCallable() {
        return this.stub.aggregatedListTargetPoolsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<AggregatedListTargetPoolsHttpRequest, TargetPoolAggregatedList> aggregatedListTargetPoolsCallable() {
        return this.stub.aggregatedListTargetPoolsCallable();
    }

    @BetaApi
    public final Operation deleteTargetPool(ProjectRegionTargetPoolName targetPool) {
        DeleteTargetPoolHttpRequest request = DeleteTargetPoolHttpRequest.newBuilder().setTargetPool(targetPool == null ? null : targetPool.toString()).build();
        return this.deleteTargetPool(request);
    }

    @BetaApi
    public final Operation deleteTargetPool(String targetPool) {
        DeleteTargetPoolHttpRequest request = DeleteTargetPoolHttpRequest.newBuilder().setTargetPool(targetPool).build();
        return this.deleteTargetPool(request);
    }

    @BetaApi
    public final Operation deleteTargetPool(DeleteTargetPoolHttpRequest request) {
        return (Operation)this.deleteTargetPoolCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteTargetPoolHttpRequest, Operation> deleteTargetPoolCallable() {
        return this.stub.deleteTargetPoolCallable();
    }

    @BetaApi
    public final TargetPool getTargetPool(ProjectRegionTargetPoolName targetPool) {
        GetTargetPoolHttpRequest request = GetTargetPoolHttpRequest.newBuilder().setTargetPool(targetPool == null ? null : targetPool.toString()).build();
        return this.getTargetPool(request);
    }

    @BetaApi
    public final TargetPool getTargetPool(String targetPool) {
        GetTargetPoolHttpRequest request = GetTargetPoolHttpRequest.newBuilder().setTargetPool(targetPool).build();
        return this.getTargetPool(request);
    }

    @BetaApi
    public final TargetPool getTargetPool(GetTargetPoolHttpRequest request) {
        return (TargetPool)this.getTargetPoolCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetTargetPoolHttpRequest, TargetPool> getTargetPoolCallable() {
        return this.stub.getTargetPoolCallable();
    }

    @BetaApi
    public final TargetPoolInstanceHealth getHealthTargetPool(ProjectRegionTargetPoolName targetPool, InstanceReference instanceReferenceResource) {
        GetHealthTargetPoolHttpRequest request = GetHealthTargetPoolHttpRequest.newBuilder().setTargetPool(targetPool == null ? null : targetPool.toString()).setInstanceReferenceResource(instanceReferenceResource).build();
        return this.getHealthTargetPool(request);
    }

    @BetaApi
    public final TargetPoolInstanceHealth getHealthTargetPool(String targetPool, InstanceReference instanceReferenceResource) {
        GetHealthTargetPoolHttpRequest request = GetHealthTargetPoolHttpRequest.newBuilder().setTargetPool(targetPool).setInstanceReferenceResource(instanceReferenceResource).build();
        return this.getHealthTargetPool(request);
    }

    @BetaApi
    public final TargetPoolInstanceHealth getHealthTargetPool(GetHealthTargetPoolHttpRequest request) {
        return (TargetPoolInstanceHealth)this.getHealthTargetPoolCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetHealthTargetPoolHttpRequest, TargetPoolInstanceHealth> getHealthTargetPoolCallable() {
        return this.stub.getHealthTargetPoolCallable();
    }

    @BetaApi
    public final Operation insertTargetPool(ProjectRegionName region, TargetPool targetPoolResource) {
        InsertTargetPoolHttpRequest request = InsertTargetPoolHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).setTargetPoolResource(targetPoolResource).build();
        return this.insertTargetPool(request);
    }

    @BetaApi
    public final Operation insertTargetPool(String region, TargetPool targetPoolResource) {
        InsertTargetPoolHttpRequest request = InsertTargetPoolHttpRequest.newBuilder().setRegion(region).setTargetPoolResource(targetPoolResource).build();
        return this.insertTargetPool(request);
    }

    @BetaApi
    public final Operation insertTargetPool(InsertTargetPoolHttpRequest request) {
        return (Operation)this.insertTargetPoolCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertTargetPoolHttpRequest, Operation> insertTargetPoolCallable() {
        return this.stub.insertTargetPoolCallable();
    }

    @BetaApi
    public final ListTargetPoolsPagedResponse listTargetPools(ProjectRegionName region) {
        ListTargetPoolsHttpRequest request = ListTargetPoolsHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).build();
        return this.listTargetPools(request);
    }

    @BetaApi
    public final ListTargetPoolsPagedResponse listTargetPools(String region) {
        ListTargetPoolsHttpRequest request = ListTargetPoolsHttpRequest.newBuilder().setRegion(region).build();
        return this.listTargetPools(request);
    }

    @BetaApi
    public final ListTargetPoolsPagedResponse listTargetPools(ListTargetPoolsHttpRequest request) {
        return (ListTargetPoolsPagedResponse)((Object)this.listTargetPoolsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListTargetPoolsHttpRequest, ListTargetPoolsPagedResponse> listTargetPoolsPagedCallable() {
        return this.stub.listTargetPoolsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListTargetPoolsHttpRequest, TargetPoolList> listTargetPoolsCallable() {
        return this.stub.listTargetPoolsCallable();
    }

    @BetaApi
    public final Operation removeHealthCheckTargetPool(ProjectRegionTargetPoolName targetPool, TargetPoolsRemoveHealthCheckRequest targetPoolsRemoveHealthCheckRequestResource) {
        RemoveHealthCheckTargetPoolHttpRequest request = RemoveHealthCheckTargetPoolHttpRequest.newBuilder().setTargetPool(targetPool == null ? null : targetPool.toString()).setTargetPoolsRemoveHealthCheckRequestResource(targetPoolsRemoveHealthCheckRequestResource).build();
        return this.removeHealthCheckTargetPool(request);
    }

    @BetaApi
    public final Operation removeHealthCheckTargetPool(String targetPool, TargetPoolsRemoveHealthCheckRequest targetPoolsRemoveHealthCheckRequestResource) {
        RemoveHealthCheckTargetPoolHttpRequest request = RemoveHealthCheckTargetPoolHttpRequest.newBuilder().setTargetPool(targetPool).setTargetPoolsRemoveHealthCheckRequestResource(targetPoolsRemoveHealthCheckRequestResource).build();
        return this.removeHealthCheckTargetPool(request);
    }

    @BetaApi
    public final Operation removeHealthCheckTargetPool(RemoveHealthCheckTargetPoolHttpRequest request) {
        return (Operation)this.removeHealthCheckTargetPoolCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<RemoveHealthCheckTargetPoolHttpRequest, Operation> removeHealthCheckTargetPoolCallable() {
        return this.stub.removeHealthCheckTargetPoolCallable();
    }

    @BetaApi
    public final Operation removeInstanceTargetPool(ProjectRegionTargetPoolName targetPool, TargetPoolsRemoveInstanceRequest targetPoolsRemoveInstanceRequestResource) {
        RemoveInstanceTargetPoolHttpRequest request = RemoveInstanceTargetPoolHttpRequest.newBuilder().setTargetPool(targetPool == null ? null : targetPool.toString()).setTargetPoolsRemoveInstanceRequestResource(targetPoolsRemoveInstanceRequestResource).build();
        return this.removeInstanceTargetPool(request);
    }

    @BetaApi
    public final Operation removeInstanceTargetPool(String targetPool, TargetPoolsRemoveInstanceRequest targetPoolsRemoveInstanceRequestResource) {
        RemoveInstanceTargetPoolHttpRequest request = RemoveInstanceTargetPoolHttpRequest.newBuilder().setTargetPool(targetPool).setTargetPoolsRemoveInstanceRequestResource(targetPoolsRemoveInstanceRequestResource).build();
        return this.removeInstanceTargetPool(request);
    }

    @BetaApi
    public final Operation removeInstanceTargetPool(RemoveInstanceTargetPoolHttpRequest request) {
        return (Operation)this.removeInstanceTargetPoolCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<RemoveInstanceTargetPoolHttpRequest, Operation> removeInstanceTargetPoolCallable() {
        return this.stub.removeInstanceTargetPoolCallable();
    }

    @BetaApi
    public final Operation setBackupTargetPool(ProjectRegionTargetPoolName targetPool, Float failoverRatio, TargetReference targetReferenceResource) {
        SetBackupTargetPoolHttpRequest request = SetBackupTargetPoolHttpRequest.newBuilder().setTargetPool(targetPool == null ? null : targetPool.toString()).setFailoverRatio(failoverRatio).setTargetReferenceResource(targetReferenceResource).build();
        return this.setBackupTargetPool(request);
    }

    @BetaApi
    public final Operation setBackupTargetPool(String targetPool, Float failoverRatio, TargetReference targetReferenceResource) {
        SetBackupTargetPoolHttpRequest request = SetBackupTargetPoolHttpRequest.newBuilder().setTargetPool(targetPool).setFailoverRatio(failoverRatio).setTargetReferenceResource(targetReferenceResource).build();
        return this.setBackupTargetPool(request);
    }

    @BetaApi
    public final Operation setBackupTargetPool(SetBackupTargetPoolHttpRequest request) {
        return (Operation)this.setBackupTargetPoolCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetBackupTargetPoolHttpRequest, Operation> setBackupTargetPoolCallable() {
        return this.stub.setBackupTargetPoolCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTargetPoolsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTargetPoolsHttpRequest, TargetPoolList, TargetPool, ListTargetPoolsPage, ListTargetPoolsFixedSizeCollection> {
        private ListTargetPoolsFixedSizeCollection(List<ListTargetPoolsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTargetPoolsFixedSizeCollection createEmptyCollection() {
            return new ListTargetPoolsFixedSizeCollection(null, 0);
        }

        protected ListTargetPoolsFixedSizeCollection createCollection(List<ListTargetPoolsPage> pages, int collectionSize) {
            return new ListTargetPoolsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTargetPoolsPage
    extends AbstractPage<ListTargetPoolsHttpRequest, TargetPoolList, TargetPool, ListTargetPoolsPage> {
        private ListTargetPoolsPage(PageContext<ListTargetPoolsHttpRequest, TargetPoolList, TargetPool> context, TargetPoolList response) {
            super(context, (Object)response);
        }

        private static ListTargetPoolsPage createEmptyPage() {
            return new ListTargetPoolsPage(null, null);
        }

        protected ListTargetPoolsPage createPage(PageContext<ListTargetPoolsHttpRequest, TargetPoolList, TargetPool> context, TargetPoolList response) {
            return new ListTargetPoolsPage(context, response);
        }

        public ApiFuture<ListTargetPoolsPage> createPageAsync(PageContext<ListTargetPoolsHttpRequest, TargetPoolList, TargetPool> context, ApiFuture<TargetPoolList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTargetPoolsPagedResponse
    extends AbstractPagedListResponse<ListTargetPoolsHttpRequest, TargetPoolList, TargetPool, ListTargetPoolsPage, ListTargetPoolsFixedSizeCollection> {
        public static ApiFuture<ListTargetPoolsPagedResponse> createAsync(PageContext<ListTargetPoolsHttpRequest, TargetPoolList, TargetPool> context, ApiFuture<TargetPoolList> futureResponse) {
            ApiFuture<ListTargetPoolsPage> futurePage = ListTargetPoolsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListTargetPoolsPage, ListTargetPoolsPagedResponse>(){

                public ListTargetPoolsPagedResponse apply(ListTargetPoolsPage input) {
                    return new ListTargetPoolsPagedResponse(input);
                }
            });
        }

        private ListTargetPoolsPagedResponse(ListTargetPoolsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTargetPoolsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListTargetPoolsFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListTargetPoolsHttpRequest, TargetPoolAggregatedList, TargetPoolsScopedList, AggregatedListTargetPoolsPage, AggregatedListTargetPoolsFixedSizeCollection> {
        private AggregatedListTargetPoolsFixedSizeCollection(List<AggregatedListTargetPoolsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListTargetPoolsFixedSizeCollection createEmptyCollection() {
            return new AggregatedListTargetPoolsFixedSizeCollection(null, 0);
        }

        protected AggregatedListTargetPoolsFixedSizeCollection createCollection(List<AggregatedListTargetPoolsPage> pages, int collectionSize) {
            return new AggregatedListTargetPoolsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListTargetPoolsPage
    extends AbstractPage<AggregatedListTargetPoolsHttpRequest, TargetPoolAggregatedList, TargetPoolsScopedList, AggregatedListTargetPoolsPage> {
        private AggregatedListTargetPoolsPage(PageContext<AggregatedListTargetPoolsHttpRequest, TargetPoolAggregatedList, TargetPoolsScopedList> context, TargetPoolAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListTargetPoolsPage createEmptyPage() {
            return new AggregatedListTargetPoolsPage(null, null);
        }

        protected AggregatedListTargetPoolsPage createPage(PageContext<AggregatedListTargetPoolsHttpRequest, TargetPoolAggregatedList, TargetPoolsScopedList> context, TargetPoolAggregatedList response) {
            return new AggregatedListTargetPoolsPage(context, response);
        }

        public ApiFuture<AggregatedListTargetPoolsPage> createPageAsync(PageContext<AggregatedListTargetPoolsHttpRequest, TargetPoolAggregatedList, TargetPoolsScopedList> context, ApiFuture<TargetPoolAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListTargetPoolsPagedResponse
    extends AbstractPagedListResponse<AggregatedListTargetPoolsHttpRequest, TargetPoolAggregatedList, TargetPoolsScopedList, AggregatedListTargetPoolsPage, AggregatedListTargetPoolsFixedSizeCollection> {
        public static ApiFuture<AggregatedListTargetPoolsPagedResponse> createAsync(PageContext<AggregatedListTargetPoolsHttpRequest, TargetPoolAggregatedList, TargetPoolsScopedList> context, ApiFuture<TargetPoolAggregatedList> futureResponse) {
            ApiFuture<AggregatedListTargetPoolsPage> futurePage = AggregatedListTargetPoolsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListTargetPoolsPage, AggregatedListTargetPoolsPagedResponse>(){

                public AggregatedListTargetPoolsPagedResponse apply(AggregatedListTargetPoolsPage input) {
                    return new AggregatedListTargetPoolsPagedResponse(input);
                }
            });
        }

        private AggregatedListTargetPoolsPagedResponse(AggregatedListTargetPoolsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListTargetPoolsFixedSizeCollection.createEmptyCollection());
        }
    }
}

