/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectRegionInstanceGroupManagerName
implements ResourceName {
    private final String instanceGroupManager;
    private final String project;
    private final String region;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}");
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectRegionInstanceGroupManagerName(Builder builder) {
        this.instanceGroupManager = (String)Preconditions.checkNotNull((Object)builder.getInstanceGroupManager());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
    }

    public static ProjectRegionInstanceGroupManagerName of(String instanceGroupManager, String project, String region) {
        return ProjectRegionInstanceGroupManagerName.newBuilder().setInstanceGroupManager(instanceGroupManager).setProject(project).setRegion(region).build();
    }

    public static String format(String instanceGroupManager, String project, String region) {
        return ProjectRegionInstanceGroupManagerName.of(instanceGroupManager, project, region).toString();
    }

    public String getInstanceGroupManager() {
        return this.instanceGroupManager;
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectRegionInstanceGroupManagerName projectRegionInstanceGroupManagerName = this;
            synchronized (projectRegionInstanceGroupManagerName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"instanceGroupManager", (Object)this.instanceGroupManager);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"region", (Object)this.region);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectRegionInstanceGroupManagerName> newFactory() {
        return new ResourceNameFactory<ProjectRegionInstanceGroupManagerName>(){

            public ProjectRegionInstanceGroupManagerName parse(String formattedString) {
                return ProjectRegionInstanceGroupManagerName.parse(formattedString);
            }
        };
    }

    public static ProjectRegionInstanceGroupManagerName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ProjectRegionInstanceGroupManagerName.parse: formattedString not in valid format");
        return ProjectRegionInstanceGroupManagerName.of((String)matchMap.get("instanceGroupManager"), (String)matchMap.get("project"), (String)matchMap.get("region"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"instanceGroupManager", this.instanceGroupManager, "project", this.project, "region", this.region});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectRegionInstanceGroupManagerName) {
            ProjectRegionInstanceGroupManagerName that = (ProjectRegionInstanceGroupManagerName)o;
            return Objects.equals(this.instanceGroupManager, that.getInstanceGroupManager()) && Objects.equals(this.project, that.getProject()) && Objects.equals(this.region, that.getRegion());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.instanceGroupManager, this.project, this.region);
    }

    public static class Builder {
        private String instanceGroupManager;
        private String project;
        private String region;

        public String getInstanceGroupManager() {
            return this.instanceGroupManager;
        }

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setInstanceGroupManager(String instanceGroupManager) {
            this.instanceGroupManager = instanceGroupManager;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectRegionInstanceGroupManagerName projectRegionInstanceGroupManagerName) {
            this.instanceGroupManager = projectRegionInstanceGroupManagerName.instanceGroupManager;
            this.project = projectRegionInstanceGroupManagerName.project;
            this.region = projectRegionInstanceGroupManagerName.region;
        }

        public ProjectRegionInstanceGroupManagerName build() {
            return new ProjectRegionInstanceGroupManagerName(this);
        }
    }
}

