/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class HttpSHealthCheck
implements ApiMessage {
    private final String host;
    private final Integer port;
    private final String portName;
    private final String proxyHeader;
    private final String requestPath;
    private static final HttpSHealthCheck DEFAULT_INSTANCE = new HttpSHealthCheck();

    private HttpSHealthCheck() {
        this.host = null;
        this.port = null;
        this.portName = null;
        this.proxyHeader = null;
        this.requestPath = null;
    }

    private HttpSHealthCheck(String host, Integer port, String portName, String proxyHeader, String requestPath) {
        this.host = host;
        this.port = port;
        this.portName = portName;
        this.proxyHeader = proxyHeader;
        this.requestPath = requestPath;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("host")) {
            return this.host;
        }
        if (fieldName.equals("port")) {
            return this.port;
        }
        if (fieldName.equals("portName")) {
            return this.portName;
        }
        if (fieldName.equals("proxyHeader")) {
            return this.proxyHeader;
        }
        if (fieldName.equals("requestPath")) {
            return this.requestPath;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getPortName() {
        return this.portName;
    }

    public String getProxyHeader() {
        return this.proxyHeader;
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(HttpSHealthCheck prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static HttpSHealthCheck getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "HttpSHealthCheck{host=" + this.host + ", port=" + this.port + ", portName=" + this.portName + ", proxyHeader=" + this.proxyHeader + ", requestPath=" + this.requestPath + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HttpSHealthCheck) {
            HttpSHealthCheck that = (HttpSHealthCheck)o;
            return Objects.equals(this.host, that.getHost()) && Objects.equals(this.port, that.getPort()) && Objects.equals(this.portName, that.getPortName()) && Objects.equals(this.proxyHeader, that.getProxyHeader()) && Objects.equals(this.requestPath, that.getRequestPath());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port, this.portName, this.proxyHeader, this.requestPath);
    }

    public static class Builder {
        private String host;
        private Integer port;
        private String portName;
        private String proxyHeader;
        private String requestPath;

        Builder() {
        }

        public Builder mergeFrom(HttpSHealthCheck other) {
            if (other == HttpSHealthCheck.getDefaultInstance()) {
                return this;
            }
            if (other.getHost() != null) {
                this.host = other.host;
            }
            if (other.getPort() != null) {
                this.port = other.port;
            }
            if (other.getPortName() != null) {
                this.portName = other.portName;
            }
            if (other.getProxyHeader() != null) {
                this.proxyHeader = other.proxyHeader;
            }
            if (other.getRequestPath() != null) {
                this.requestPath = other.requestPath;
            }
            return this;
        }

        Builder(HttpSHealthCheck source) {
            this.host = source.host;
            this.port = source.port;
            this.portName = source.portName;
            this.proxyHeader = source.proxyHeader;
            this.requestPath = source.requestPath;
        }

        public String getHost() {
            return this.host;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Integer getPort() {
            return this.port;
        }

        public Builder setPort(Integer port) {
            this.port = port;
            return this;
        }

        public String getPortName() {
            return this.portName;
        }

        public Builder setPortName(String portName) {
            this.portName = portName;
            return this;
        }

        public String getProxyHeader() {
            return this.proxyHeader;
        }

        public Builder setProxyHeader(String proxyHeader) {
            this.proxyHeader = proxyHeader;
            return this;
        }

        public String getRequestPath() {
            return this.requestPath;
        }

        public Builder setRequestPath(String requestPath) {
            this.requestPath = requestPath;
            return this;
        }

        public HttpSHealthCheck build() {
            return new HttpSHealthCheck(this.host, this.port, this.portName, this.proxyHeader, this.requestPath);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setHost(this.host);
            newBuilder.setPort(this.port);
            newBuilder.setPortName(this.portName);
            newBuilder.setProxyHeader(this.proxyHeader);
            newBuilder.setRequestPath(this.requestPath);
            return newBuilder;
        }
    }
}

