/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteHttpHealthCheckHttpRequest;
import com.google.cloud.compute.v1.GetHttpHealthCheckHttpRequest;
import com.google.cloud.compute.v1.HttpHealthCheck2;
import com.google.cloud.compute.v1.HttpHealthCheckList;
import com.google.cloud.compute.v1.HttpHealthCheckSettings;
import com.google.cloud.compute.v1.InsertHttpHealthCheckHttpRequest;
import com.google.cloud.compute.v1.ListHttpHealthChecksHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchHttpHealthCheckHttpRequest;
import com.google.cloud.compute.v1.ProjectGlobalHttpHealthCheckName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.UpdateHttpHealthCheckHttpRequest;
import com.google.cloud.compute.v1.stub.HttpHealthCheckStub;
import com.google.cloud.compute.v1.stub.HttpHealthCheckStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpHealthCheckClient
implements BackgroundResource {
    private final HttpHealthCheckSettings settings;
    private final HttpHealthCheckStub stub;

    public static final HttpHealthCheckClient create() throws IOException {
        return HttpHealthCheckClient.create(HttpHealthCheckSettings.newBuilder().build());
    }

    public static final HttpHealthCheckClient create(HttpHealthCheckSettings settings) throws IOException {
        return new HttpHealthCheckClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final HttpHealthCheckClient create(HttpHealthCheckStub stub) {
        return new HttpHealthCheckClient(stub);
    }

    protected HttpHealthCheckClient(HttpHealthCheckSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((HttpHealthCheckStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected HttpHealthCheckClient(HttpHealthCheckStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final HttpHealthCheckSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public HttpHealthCheckStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation deleteHttpHealthCheck(ProjectGlobalHttpHealthCheckName httpHealthCheck) {
        DeleteHttpHealthCheckHttpRequest request = DeleteHttpHealthCheckHttpRequest.newBuilder().setHttpHealthCheck(httpHealthCheck == null ? null : httpHealthCheck.toString()).build();
        return this.deleteHttpHealthCheck(request);
    }

    @BetaApi
    public final Operation deleteHttpHealthCheck(String httpHealthCheck) {
        DeleteHttpHealthCheckHttpRequest request = DeleteHttpHealthCheckHttpRequest.newBuilder().setHttpHealthCheck(httpHealthCheck).build();
        return this.deleteHttpHealthCheck(request);
    }

    @BetaApi
    public final Operation deleteHttpHealthCheck(DeleteHttpHealthCheckHttpRequest request) {
        return (Operation)this.deleteHttpHealthCheckCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteHttpHealthCheckHttpRequest, Operation> deleteHttpHealthCheckCallable() {
        return this.stub.deleteHttpHealthCheckCallable();
    }

    @BetaApi
    public final HttpHealthCheck2 getHttpHealthCheck(ProjectGlobalHttpHealthCheckName httpHealthCheck) {
        GetHttpHealthCheckHttpRequest request = GetHttpHealthCheckHttpRequest.newBuilder().setHttpHealthCheck(httpHealthCheck == null ? null : httpHealthCheck.toString()).build();
        return this.getHttpHealthCheck(request);
    }

    @BetaApi
    public final HttpHealthCheck2 getHttpHealthCheck(String httpHealthCheck) {
        GetHttpHealthCheckHttpRequest request = GetHttpHealthCheckHttpRequest.newBuilder().setHttpHealthCheck(httpHealthCheck).build();
        return this.getHttpHealthCheck(request);
    }

    @BetaApi
    public final HttpHealthCheck2 getHttpHealthCheck(GetHttpHealthCheckHttpRequest request) {
        return (HttpHealthCheck2)this.getHttpHealthCheckCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetHttpHealthCheckHttpRequest, HttpHealthCheck2> getHttpHealthCheckCallable() {
        return this.stub.getHttpHealthCheckCallable();
    }

    @BetaApi
    public final Operation insertHttpHealthCheck(ProjectName project, HttpHealthCheck2 httpHealthCheckResource) {
        InsertHttpHealthCheckHttpRequest request = InsertHttpHealthCheckHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).setHttpHealthCheckResource(httpHealthCheckResource).build();
        return this.insertHttpHealthCheck(request);
    }

    @BetaApi
    public final Operation insertHttpHealthCheck(String project, HttpHealthCheck2 httpHealthCheckResource) {
        InsertHttpHealthCheckHttpRequest request = InsertHttpHealthCheckHttpRequest.newBuilder().setProject(project).setHttpHealthCheckResource(httpHealthCheckResource).build();
        return this.insertHttpHealthCheck(request);
    }

    @BetaApi
    public final Operation insertHttpHealthCheck(InsertHttpHealthCheckHttpRequest request) {
        return (Operation)this.insertHttpHealthCheckCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertHttpHealthCheckHttpRequest, Operation> insertHttpHealthCheckCallable() {
        return this.stub.insertHttpHealthCheckCallable();
    }

    @BetaApi
    public final ListHttpHealthChecksPagedResponse listHttpHealthChecks(ProjectName project) {
        ListHttpHealthChecksHttpRequest request = ListHttpHealthChecksHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listHttpHealthChecks(request);
    }

    @BetaApi
    public final ListHttpHealthChecksPagedResponse listHttpHealthChecks(String project) {
        ListHttpHealthChecksHttpRequest request = ListHttpHealthChecksHttpRequest.newBuilder().setProject(project).build();
        return this.listHttpHealthChecks(request);
    }

    @BetaApi
    public final ListHttpHealthChecksPagedResponse listHttpHealthChecks(ListHttpHealthChecksHttpRequest request) {
        return (ListHttpHealthChecksPagedResponse)((Object)this.listHttpHealthChecksPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListHttpHealthChecksHttpRequest, ListHttpHealthChecksPagedResponse> listHttpHealthChecksPagedCallable() {
        return this.stub.listHttpHealthChecksPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListHttpHealthChecksHttpRequest, HttpHealthCheckList> listHttpHealthChecksCallable() {
        return this.stub.listHttpHealthChecksCallable();
    }

    @BetaApi
    public final Operation patchHttpHealthCheck(ProjectGlobalHttpHealthCheckName httpHealthCheck, HttpHealthCheck2 httpHealthCheckResource, List<String> fieldMask) {
        PatchHttpHealthCheckHttpRequest request = PatchHttpHealthCheckHttpRequest.newBuilder().setHttpHealthCheck(httpHealthCheck == null ? null : httpHealthCheck.toString()).setHttpHealthCheckResource(httpHealthCheckResource).addAllFieldMask(fieldMask).build();
        return this.patchHttpHealthCheck(request);
    }

    @BetaApi
    public final Operation patchHttpHealthCheck(String httpHealthCheck, HttpHealthCheck2 httpHealthCheckResource, List<String> fieldMask) {
        PatchHttpHealthCheckHttpRequest request = PatchHttpHealthCheckHttpRequest.newBuilder().setHttpHealthCheck(httpHealthCheck).setHttpHealthCheckResource(httpHealthCheckResource).addAllFieldMask(fieldMask).build();
        return this.patchHttpHealthCheck(request);
    }

    @BetaApi
    public final Operation patchHttpHealthCheck(PatchHttpHealthCheckHttpRequest request) {
        return (Operation)this.patchHttpHealthCheckCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<PatchHttpHealthCheckHttpRequest, Operation> patchHttpHealthCheckCallable() {
        return this.stub.patchHttpHealthCheckCallable();
    }

    @BetaApi
    public final Operation updateHttpHealthCheck(ProjectGlobalHttpHealthCheckName httpHealthCheck, HttpHealthCheck2 httpHealthCheckResource, List<String> fieldMask) {
        UpdateHttpHealthCheckHttpRequest request = UpdateHttpHealthCheckHttpRequest.newBuilder().setHttpHealthCheck(httpHealthCheck == null ? null : httpHealthCheck.toString()).setHttpHealthCheckResource(httpHealthCheckResource).addAllFieldMask(fieldMask).build();
        return this.updateHttpHealthCheck(request);
    }

    @BetaApi
    public final Operation updateHttpHealthCheck(String httpHealthCheck, HttpHealthCheck2 httpHealthCheckResource, List<String> fieldMask) {
        UpdateHttpHealthCheckHttpRequest request = UpdateHttpHealthCheckHttpRequest.newBuilder().setHttpHealthCheck(httpHealthCheck).setHttpHealthCheckResource(httpHealthCheckResource).addAllFieldMask(fieldMask).build();
        return this.updateHttpHealthCheck(request);
    }

    @BetaApi
    public final Operation updateHttpHealthCheck(UpdateHttpHealthCheckHttpRequest request) {
        return (Operation)this.updateHttpHealthCheckCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<UpdateHttpHealthCheckHttpRequest, Operation> updateHttpHealthCheckCallable() {
        return this.stub.updateHttpHealthCheckCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListHttpHealthChecksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListHttpHealthChecksHttpRequest, HttpHealthCheckList, HttpHealthCheck2, ListHttpHealthChecksPage, ListHttpHealthChecksFixedSizeCollection> {
        private ListHttpHealthChecksFixedSizeCollection(List<ListHttpHealthChecksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListHttpHealthChecksFixedSizeCollection createEmptyCollection() {
            return new ListHttpHealthChecksFixedSizeCollection(null, 0);
        }

        protected ListHttpHealthChecksFixedSizeCollection createCollection(List<ListHttpHealthChecksPage> pages, int collectionSize) {
            return new ListHttpHealthChecksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListHttpHealthChecksPage
    extends AbstractPage<ListHttpHealthChecksHttpRequest, HttpHealthCheckList, HttpHealthCheck2, ListHttpHealthChecksPage> {
        private ListHttpHealthChecksPage(PageContext<ListHttpHealthChecksHttpRequest, HttpHealthCheckList, HttpHealthCheck2> context, HttpHealthCheckList response) {
            super(context, (Object)response);
        }

        private static ListHttpHealthChecksPage createEmptyPage() {
            return new ListHttpHealthChecksPage(null, null);
        }

        protected ListHttpHealthChecksPage createPage(PageContext<ListHttpHealthChecksHttpRequest, HttpHealthCheckList, HttpHealthCheck2> context, HttpHealthCheckList response) {
            return new ListHttpHealthChecksPage(context, response);
        }

        public ApiFuture<ListHttpHealthChecksPage> createPageAsync(PageContext<ListHttpHealthChecksHttpRequest, HttpHealthCheckList, HttpHealthCheck2> context, ApiFuture<HttpHealthCheckList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListHttpHealthChecksPagedResponse
    extends AbstractPagedListResponse<ListHttpHealthChecksHttpRequest, HttpHealthCheckList, HttpHealthCheck2, ListHttpHealthChecksPage, ListHttpHealthChecksFixedSizeCollection> {
        public static ApiFuture<ListHttpHealthChecksPagedResponse> createAsync(PageContext<ListHttpHealthChecksHttpRequest, HttpHealthCheckList, HttpHealthCheck2> context, ApiFuture<HttpHealthCheckList> futureResponse) {
            ApiFuture<ListHttpHealthChecksPage> futurePage = ListHttpHealthChecksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListHttpHealthChecksPage, ListHttpHealthChecksPagedResponse>(){

                public ListHttpHealthChecksPagedResponse apply(ListHttpHealthChecksPage input) {
                    return new ListHttpHealthChecksPagedResponse(input);
                }
            });
        }

        private ListHttpHealthChecksPagedResponse(ListHttpHealthChecksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListHttpHealthChecksFixedSizeCollection.createEmptyCollection());
        }
    }
}

