/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.GetRegionHttpRequest;
import com.google.cloud.compute.v1.ListRegionsHttpRequest;
import com.google.cloud.compute.v1.Region;
import com.google.cloud.compute.v1.RegionClient;
import com.google.cloud.compute.v1.RegionList;
import com.google.cloud.compute.v1.stub.HttpJsonRegionStub;
import com.google.cloud.compute.v1.stub.RegionStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class RegionStubSettings
extends StubSettings<RegionStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<GetRegionHttpRequest, Region> getRegionSettings;
    private final PagedCallSettings<ListRegionsHttpRequest, RegionList, RegionClient.ListRegionsPagedResponse> listRegionsSettings;
    private static final PagedListDescriptor<ListRegionsHttpRequest, RegionList, Region> LIST_REGIONS_PAGE_STR_DESC = new PagedListDescriptor<ListRegionsHttpRequest, RegionList, Region>(){

        public String emptyToken() {
            return "";
        }

        public ListRegionsHttpRequest injectToken(ListRegionsHttpRequest payload, String token) {
            return ListRegionsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListRegionsHttpRequest injectPageSize(ListRegionsHttpRequest payload, int pageSize) {
            return ListRegionsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListRegionsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(RegionList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Region> extractResources(RegionList payload) {
            return payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<ListRegionsHttpRequest, RegionList, RegionClient.ListRegionsPagedResponse> LIST_REGIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListRegionsHttpRequest, RegionList, RegionClient.ListRegionsPagedResponse>(){

        public ApiFuture<RegionClient.ListRegionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListRegionsHttpRequest, RegionList> callable, ListRegionsHttpRequest request, ApiCallContext context, ApiFuture<RegionList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_REGIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionClient.ListRegionsPagedResponse.createAsync((PageContext<ListRegionsHttpRequest, RegionList, Region>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetRegionHttpRequest, Region> getRegionSettings() {
        return this.getRegionSettings;
    }

    public PagedCallSettings<ListRegionsHttpRequest, RegionList, RegionClient.ListRegionsPagedResponse> listRegionsSettings() {
        return this.listRegionsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRegionStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RegionStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RegionStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RegionStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getRegionSettings = settingsBuilder.getRegionSettings().build();
        this.listRegionsSettings = settingsBuilder.listRegionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RegionStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetRegionHttpRequest, Region> getRegionSettings;
        private final PagedCallSettings.Builder<ListRegionsHttpRequest, RegionList, RegionClient.ListRegionsPagedResponse> listRegionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getRegionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRegionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_REGIONS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getRegionSettings, this.listRegionsSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RegionStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RegionStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RegionStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(RegionStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getRegionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listRegionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(RegionStubSettings settings) {
            super((StubSettings)settings);
            this.getRegionSettings = settings.getRegionSettings.toBuilder();
            this.listRegionsSettings = settings.listRegionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getRegionSettings, this.listRegionsSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetRegionHttpRequest, Region> getRegionSettings() {
            return this.getRegionSettings;
        }

        public PagedCallSettings.Builder<ListRegionsHttpRequest, RegionList, RegionClient.ListRegionsPagedResponse> listRegionsSettings() {
            return this.listRegionsSettings;
        }

        public RegionStubSettings build() throws IOException {
            return new RegionStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

