/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.ApiMessageHttpRequestFormatter;
import com.google.api.gax.httpjson.ApiMessageHttpResponseParser;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.compute.v1.Address;
import com.google.cloud.compute.v1.AddressAggregatedList;
import com.google.cloud.compute.v1.AddressClient;
import com.google.cloud.compute.v1.AddressList;
import com.google.cloud.compute.v1.AggregatedListAddressesHttpRequest;
import com.google.cloud.compute.v1.DeleteAddressHttpRequest;
import com.google.cloud.compute.v1.GetAddressHttpRequest;
import com.google.cloud.compute.v1.InsertAddressHttpRequest;
import com.google.cloud.compute.v1.ListAddressesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectRegionAddressName;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.stub.AddressStub;
import com.google.cloud.compute.v1.stub.AddressStubSettings;
import com.google.cloud.compute.v1.stub.HttpJsonAddressCallableFactory;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonAddressStub
extends AddressStub {
    @InternalApi
    public static final ApiMethodDescriptor<AggregatedListAddressesHttpRequest, AddressAggregatedList> aggregatedListAddressesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.addresses.aggregatedList").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/aggregated/addresses")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)AddressAggregatedList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<DeleteAddressHttpRequest, Operation> deleteAddressMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.addresses.delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/addresses/{address}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectRegionAddressName.newFactory()).setResourceNameField("address").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetAddressHttpRequest, Address> getAddressMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.addresses.get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/addresses/{address}")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectRegionAddressName.newFactory()).setResourceNameField("address").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Address.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<InsertAddressHttpRequest, Operation> insertAddressMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.addresses.insert").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/addresses")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectRegionName.newFactory()).setResourceNameField("region").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ListAddressesHttpRequest, AddressList> listAddressesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.addresses.list").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/addresses")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectRegionName.newFactory()).setResourceNameField("region").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)AddressList.getDefaultInstance()).build()).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<AggregatedListAddressesHttpRequest, AddressAggregatedList> aggregatedListAddressesCallable;
    private final UnaryCallable<AggregatedListAddressesHttpRequest, AddressClient.AggregatedListAddressesPagedResponse> aggregatedListAddressesPagedCallable;
    private final UnaryCallable<DeleteAddressHttpRequest, Operation> deleteAddressCallable;
    private final UnaryCallable<GetAddressHttpRequest, Address> getAddressCallable;
    private final UnaryCallable<InsertAddressHttpRequest, Operation> insertAddressCallable;
    private final UnaryCallable<ListAddressesHttpRequest, AddressList> listAddressesCallable;
    private final UnaryCallable<ListAddressesHttpRequest, AddressClient.ListAddressesPagedResponse> listAddressesPagedCallable;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonAddressStub create(AddressStubSettings settings) throws IOException {
        return new HttpJsonAddressStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonAddressStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonAddressStub(AddressStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonAddressStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonAddressStub(AddressStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonAddressStub(AddressStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonAddressCallableFactory());
    }

    protected HttpJsonAddressStub(AddressStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings aggregatedListAddressesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(aggregatedListAddressesMethodDescriptor).build();
        HttpJsonCallSettings deleteAddressTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteAddressMethodDescriptor).build();
        HttpJsonCallSettings getAddressTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getAddressMethodDescriptor).build();
        HttpJsonCallSettings insertAddressTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertAddressMethodDescriptor).build();
        HttpJsonCallSettings listAddressesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listAddressesMethodDescriptor).build();
        this.aggregatedListAddressesCallable = callableFactory.createUnaryCallable(aggregatedListAddressesTransportSettings, settings.aggregatedListAddressesSettings(), clientContext);
        this.aggregatedListAddressesPagedCallable = callableFactory.createPagedCallable(aggregatedListAddressesTransportSettings, settings.aggregatedListAddressesSettings(), clientContext);
        this.deleteAddressCallable = callableFactory.createUnaryCallable(deleteAddressTransportSettings, settings.deleteAddressSettings(), clientContext);
        this.getAddressCallable = callableFactory.createUnaryCallable(getAddressTransportSettings, settings.getAddressSettings(), clientContext);
        this.insertAddressCallable = callableFactory.createUnaryCallable(insertAddressTransportSettings, settings.insertAddressSettings(), clientContext);
        this.listAddressesCallable = callableFactory.createUnaryCallable(listAddressesTransportSettings, settings.listAddressesSettings(), clientContext);
        this.listAddressesPagedCallable = callableFactory.createPagedCallable(listAddressesTransportSettings, settings.listAddressesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    @BetaApi
    public UnaryCallable<AggregatedListAddressesHttpRequest, AddressClient.AggregatedListAddressesPagedResponse> aggregatedListAddressesPagedCallable() {
        return this.aggregatedListAddressesPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<AggregatedListAddressesHttpRequest, AddressAggregatedList> aggregatedListAddressesCallable() {
        return this.aggregatedListAddressesCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<DeleteAddressHttpRequest, Operation> deleteAddressCallable() {
        return this.deleteAddressCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetAddressHttpRequest, Address> getAddressCallable() {
        return this.getAddressCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<InsertAddressHttpRequest, Operation> insertAddressCallable() {
        return this.insertAddressCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListAddressesHttpRequest, AddressClient.ListAddressesPagedResponse> listAddressesPagedCallable() {
        return this.listAddressesPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListAddressesHttpRequest, AddressList> listAddressesCallable() {
        return this.listAddressesCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

