/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectGlobalInstanceTemplateName
implements ResourceName {
    private final String instanceTemplate;
    private final String project;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/global/instanceTemplates/{instanceTemplate}");
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectGlobalInstanceTemplateName(Builder builder) {
        this.instanceTemplate = (String)Preconditions.checkNotNull((Object)builder.getInstanceTemplate());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
    }

    public static ProjectGlobalInstanceTemplateName of(String instanceTemplate, String project) {
        return ProjectGlobalInstanceTemplateName.newBuilder().setInstanceTemplate(instanceTemplate).setProject(project).build();
    }

    public static String format(String instanceTemplate, String project) {
        return ProjectGlobalInstanceTemplateName.of(instanceTemplate, project).toString();
    }

    public String getInstanceTemplate() {
        return this.instanceTemplate;
    }

    public String getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectGlobalInstanceTemplateName projectGlobalInstanceTemplateName = this;
            synchronized (projectGlobalInstanceTemplateName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"instanceTemplate", (Object)this.instanceTemplate);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectGlobalInstanceTemplateName> newFactory() {
        return new ResourceNameFactory<ProjectGlobalInstanceTemplateName>(){

            public ProjectGlobalInstanceTemplateName parse(String formattedString) {
                return ProjectGlobalInstanceTemplateName.parse(formattedString);
            }
        };
    }

    public static ProjectGlobalInstanceTemplateName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ProjectGlobalInstanceTemplateName.parse: formattedString not in valid format");
        return ProjectGlobalInstanceTemplateName.of((String)matchMap.get("instanceTemplate"), (String)matchMap.get("project"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"instanceTemplate", this.instanceTemplate, "project", this.project});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectGlobalInstanceTemplateName) {
            ProjectGlobalInstanceTemplateName that = (ProjectGlobalInstanceTemplateName)o;
            return Objects.equals(this.instanceTemplate, that.getInstanceTemplate()) && Objects.equals(this.project, that.getProject());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.instanceTemplate, this.project);
    }

    public static class Builder {
        private String instanceTemplate;
        private String project;

        public String getInstanceTemplate() {
            return this.instanceTemplate;
        }

        public String getProject() {
            return this.project;
        }

        public Builder setInstanceTemplate(String instanceTemplate) {
            this.instanceTemplate = instanceTemplate;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectGlobalInstanceTemplateName projectGlobalInstanceTemplateName) {
            this.instanceTemplate = projectGlobalInstanceTemplateName.instanceTemplate;
            this.project = projectGlobalInstanceTemplateName.project;
        }

        public ProjectGlobalInstanceTemplateName build() {
            return new ProjectGlobalInstanceTemplateName(this);
        }
    }
}

