/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AccessConfig;
import com.google.cloud.compute.v1.AddAccessConfigInstanceHttpRequest;
import com.google.cloud.compute.v1.AggregatedListInstancesHttpRequest;
import com.google.cloud.compute.v1.AttachDiskInstanceHttpRequest;
import com.google.cloud.compute.v1.AttachedDisk;
import com.google.cloud.compute.v1.DeleteAccessConfigInstanceHttpRequest;
import com.google.cloud.compute.v1.DeleteInstanceHttpRequest;
import com.google.cloud.compute.v1.DetachDiskInstanceHttpRequest;
import com.google.cloud.compute.v1.GetInstanceHttpRequest;
import com.google.cloud.compute.v1.GetSerialPortOutputInstanceHttpRequest;
import com.google.cloud.compute.v1.InsertInstanceHttpRequest;
import com.google.cloud.compute.v1.Instance;
import com.google.cloud.compute.v1.InstanceAggregatedList;
import com.google.cloud.compute.v1.InstanceList;
import com.google.cloud.compute.v1.InstanceListReferrers;
import com.google.cloud.compute.v1.InstanceSettings;
import com.google.cloud.compute.v1.InstancesScopedList;
import com.google.cloud.compute.v1.InstancesSetLabelsRequest;
import com.google.cloud.compute.v1.InstancesSetMachineResourcesRequest;
import com.google.cloud.compute.v1.InstancesSetMachineTypeRequest;
import com.google.cloud.compute.v1.InstancesSetMinCpuPlatformRequest;
import com.google.cloud.compute.v1.InstancesSetServiceAccountRequest;
import com.google.cloud.compute.v1.InstancesStartWithEncryptionKeyRequest;
import com.google.cloud.compute.v1.ListInstancesHttpRequest;
import com.google.cloud.compute.v1.ListReferrersInstancesHttpRequest;
import com.google.cloud.compute.v1.Metadata;
import com.google.cloud.compute.v1.NetworkInterface;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectZoneInstanceName;
import com.google.cloud.compute.v1.ProjectZoneInstanceResourceName;
import com.google.cloud.compute.v1.ProjectZoneName;
import com.google.cloud.compute.v1.Reference;
import com.google.cloud.compute.v1.ResetInstanceHttpRequest;
import com.google.cloud.compute.v1.Scheduling;
import com.google.cloud.compute.v1.SerialPortOutput;
import com.google.cloud.compute.v1.SetDeletionProtectionInstanceHttpRequest;
import com.google.cloud.compute.v1.SetDiskAutoDeleteInstanceHttpRequest;
import com.google.cloud.compute.v1.SetLabelsInstanceHttpRequest;
import com.google.cloud.compute.v1.SetMachineResourcesInstanceHttpRequest;
import com.google.cloud.compute.v1.SetMachineTypeInstanceHttpRequest;
import com.google.cloud.compute.v1.SetMetadataInstanceHttpRequest;
import com.google.cloud.compute.v1.SetMinCpuPlatformInstanceHttpRequest;
import com.google.cloud.compute.v1.SetSchedulingInstanceHttpRequest;
import com.google.cloud.compute.v1.SetServiceAccountInstanceHttpRequest;
import com.google.cloud.compute.v1.SetTagsInstanceHttpRequest;
import com.google.cloud.compute.v1.SimulateMaintenanceEventInstanceHttpRequest;
import com.google.cloud.compute.v1.StartInstanceHttpRequest;
import com.google.cloud.compute.v1.StartWithEncryptionKeyInstanceHttpRequest;
import com.google.cloud.compute.v1.StopInstanceHttpRequest;
import com.google.cloud.compute.v1.Tags;
import com.google.cloud.compute.v1.UpdateAccessConfigInstanceHttpRequest;
import com.google.cloud.compute.v1.UpdateNetworkInterfaceInstanceHttpRequest;
import com.google.cloud.compute.v1.stub.InstanceStub;
import com.google.cloud.compute.v1.stub.InstanceStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class InstanceClient
implements BackgroundResource {
    private final InstanceSettings settings;
    private final InstanceStub stub;

    public static final InstanceClient create() throws IOException {
        return InstanceClient.create(InstanceSettings.newBuilder().build());
    }

    public static final InstanceClient create(InstanceSettings settings) throws IOException {
        return new InstanceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final InstanceClient create(InstanceStub stub) {
        return new InstanceClient(stub);
    }

    protected InstanceClient(InstanceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((InstanceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected InstanceClient(InstanceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final InstanceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public InstanceStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation addAccessConfigInstance(ProjectZoneInstanceName instance, String networkInterface, AccessConfig accessConfigResource) {
        AddAccessConfigInstanceHttpRequest request = AddAccessConfigInstanceHttpRequest.newBuilder().setInstance(instance == null ? null : instance.toString()).setNetworkInterface(networkInterface).setAccessConfigResource(accessConfigResource).build();
        return this.addAccessConfigInstance(request);
    }

    @BetaApi
    public final Operation addAccessConfigInstance(String instance, String networkInterface, AccessConfig accessConfigResource) {
        AddAccessConfigInstanceHttpRequest request = AddAccessConfigInstanceHttpRequest.newBuilder().setInstance(instance).setNetworkInterface(networkInterface).setAccessConfigResource(accessConfigResource).build();
        return this.addAccessConfigInstance(request);
    }

    @BetaApi
    public final Operation addAccessConfigInstance(AddAccessConfigInstanceHttpRequest request) {
        return (Operation)this.addAccessConfigInstanceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<AddAccessConfigInstanceHttpRequest, Operation> addAccessConfigInstanceCallable() {
        return this.stub.addAccessConfigInstanceCallable();
    }

    @BetaApi
    public final AggregatedListInstancesPagedResponse aggregatedListInstances(ProjectName project) {
        AggregatedListInstancesHttpRequest request = AggregatedListInstancesHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.aggregatedListInstances(request);
    }

    @BetaApi
    public final AggregatedListInstancesPagedResponse aggregatedListInstances(String project) {
        AggregatedListInstancesHttpRequest request = AggregatedListInstancesHttpRequest.newBuilder().setProject(project).build();
        return this.aggregatedListInstances(request);
    }

    @BetaApi
    public final AggregatedListInstancesPagedResponse aggregatedListInstances(AggregatedListInstancesHttpRequest request) {
        return (AggregatedListInstancesPagedResponse)((Object)this.aggregatedListInstancesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<AggregatedListInstancesHttpRequest, AggregatedListInstancesPagedResponse> aggregatedListInstancesPagedCallable() {
        return this.stub.aggregatedListInstancesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<AggregatedListInstancesHttpRequest, InstanceAggregatedList> aggregatedListInstancesCallable() {
        return this.stub.aggregatedListInstancesCallable();
    }

    @BetaApi
    public final Operation attachDiskInstance(ProjectZoneInstanceName instance, Boolean forceAttach, AttachedDisk attachedDiskResource) {
        AttachDiskInstanceHttpRequest request = AttachDiskInstanceHttpRequest.newBuilder().setInstance(instance == null ? null : instance.toString()).setForceAttach(forceAttach).setAttachedDiskResource(attachedDiskResource).build();
        return this.attachDiskInstance(request);
    }

    @BetaApi
    public final Operation attachDiskInstance(String instance, Boolean forceAttach, AttachedDisk attachedDiskResource) {
        AttachDiskInstanceHttpRequest request = AttachDiskInstanceHttpRequest.newBuilder().setInstance(instance).setForceAttach(forceAttach).setAttachedDiskResource(attachedDiskResource).build();
        return this.attachDiskInstance(request);
    }

    @BetaApi
    public final Operation attachDiskInstance(AttachDiskInstanceHttpRequest request) {
        return (Operation)this.attachDiskInstanceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<AttachDiskInstanceHttpRequest, Operation> attachDiskInstanceCallable() {
        return this.stub.attachDiskInstanceCallable();
    }

    @BetaApi
    public final Operation deleteInstance(ProjectZoneInstanceName instance) {
        DeleteInstanceHttpRequest request = DeleteInstanceHttpRequest.newBuilder().setInstance(instance == null ? null : instance.toString()).build();
        return this.deleteInstance(request);
    }

    @BetaApi
    public final Operation deleteInstance(String instance) {
        DeleteInstanceHttpRequest request = DeleteInstanceHttpRequest.newBuilder().setInstance(instance).build();
        return this.deleteInstance(request);
    }

    @BetaApi
    public final Operation deleteInstance(DeleteInstanceHttpRequest request) {
        return (Operation)this.deleteInstanceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteInstanceHttpRequest, Operation> deleteInstanceCallable() {
        return this.stub.deleteInstanceCallable();
    }

    @BetaApi
    public final Operation deleteAccessConfigInstance(ProjectZoneInstanceName instance, String networkInterface, String accessConfig) {
        DeleteAccessConfigInstanceHttpRequest request = DeleteAccessConfigInstanceHttpRequest.newBuilder().setInstance(instance == null ? null : instance.toString()).setNetworkInterface(networkInterface).setAccessConfig(accessConfig).build();
        return this.deleteAccessConfigInstance(request);
    }

    @BetaApi
    public final Operation deleteAccessConfigInstance(String instance, String networkInterface, String accessConfig) {
        DeleteAccessConfigInstanceHttpRequest request = DeleteAccessConfigInstanceHttpRequest.newBuilder().setInstance(instance).setNetworkInterface(networkInterface).setAccessConfig(accessConfig).build();
        return this.deleteAccessConfigInstance(request);
    }

    @BetaApi
    public final Operation deleteAccessConfigInstance(DeleteAccessConfigInstanceHttpRequest request) {
        return (Operation)this.deleteAccessConfigInstanceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteAccessConfigInstanceHttpRequest, Operation> deleteAccessConfigInstanceCallable() {
        return this.stub.deleteAccessConfigInstanceCallable();
    }

    @BetaApi
    public final Operation detachDiskInstance(ProjectZoneInstanceName instance, String deviceName) {
        DetachDiskInstanceHttpRequest request = DetachDiskInstanceHttpRequest.newBuilder().setInstance(instance == null ? null : instance.toString()).setDeviceName(deviceName).build();
        return this.detachDiskInstance(request);
    }

    @BetaApi
    public final Operation detachDiskInstance(String instance, String deviceName) {
        DetachDiskInstanceHttpRequest request = DetachDiskInstanceHttpRequest.newBuilder().setInstance(instance).setDeviceName(deviceName).build();
        return this.detachDiskInstance(request);
    }

    @BetaApi
    public final Operation detachDiskInstance(DetachDiskInstanceHttpRequest request) {
        return (Operation)this.detachDiskInstanceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DetachDiskInstanceHttpRequest, Operation> detachDiskInstanceCallable() {
        return this.stub.detachDiskInstanceCallable();
    }

    @BetaApi
    public final Instance getInstance(ProjectZoneInstanceName instance) {
        GetInstanceHttpRequest request = GetInstanceHttpRequest.newBuilder().setInstance(instance == null ? null : instance.toString()).build();
        return this.getInstance(request);
    }

    @BetaApi
    public final Instance getInstance(String instance) {
        GetInstanceHttpRequest request = GetInstanceHttpRequest.newBuilder().setInstance(instance).build();
        return this.getInstance(request);
    }

    @BetaApi
    public final Instance getInstance(GetInstanceHttpRequest request) {
        return (Instance)this.getInstanceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetInstanceHttpRequest, Instance> getInstanceCallable() {
        return this.stub.getInstanceCallable();
    }

    @BetaApi
    public final SerialPortOutput getSerialPortOutputInstance(ProjectZoneInstanceName instance, Integer port, String start) {
        GetSerialPortOutputInstanceHttpRequest request = GetSerialPortOutputInstanceHttpRequest.newBuilder().setInstance(instance == null ? null : instance.toString()).setPort(port).setStart(start).build();
        return this.getSerialPortOutputInstance(request);
    }

    @BetaApi
    public final SerialPortOutput getSerialPortOutputInstance(String instance, Integer port, String start) {
        GetSerialPortOutputInstanceHttpRequest request = GetSerialPortOutputInstanceHttpRequest.newBuilder().setInstance(instance).setPort(port).setStart(start).build();
        return this.getSerialPortOutputInstance(request);
    }

    @BetaApi
    public final SerialPortOutput getSerialPortOutputInstance(GetSerialPortOutputInstanceHttpRequest request) {
        return (SerialPortOutput)this.getSerialPortOutputInstanceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetSerialPortOutputInstanceHttpRequest, SerialPortOutput> getSerialPortOutputInstanceCallable() {
        return this.stub.getSerialPortOutputInstanceCallable();
    }

    @BetaApi
    public final Operation insertInstance(ProjectZoneName zone, Instance instanceResource) {
        InsertInstanceHttpRequest request = InsertInstanceHttpRequest.newBuilder().setZone(zone == null ? null : zone.toString()).setInstanceResource(instanceResource).build();
        return this.insertInstance(request);
    }

    @BetaApi
    public final Operation insertInstance(String zone, Instance instanceResource) {
        InsertInstanceHttpRequest request = InsertInstanceHttpRequest.newBuilder().setZone(zone).setInstanceResource(instanceResource).build();
        return this.insertInstance(request);
    }

    @BetaApi
    public final Operation insertInstance(InsertInstanceHttpRequest request) {
        return (Operation)this.insertInstanceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertInstanceHttpRequest, Operation> insertInstanceCallable() {
        return this.stub.insertInstanceCallable();
    }

    @BetaApi
    public final ListInstancesPagedResponse listInstances(ProjectZoneName zone) {
        ListInstancesHttpRequest request = ListInstancesHttpRequest.newBuilder().setZone(zone == null ? null : zone.toString()).build();
        return this.listInstances(request);
    }

    @BetaApi
    public final ListInstancesPagedResponse listInstances(String zone) {
        ListInstancesHttpRequest request = ListInstancesHttpRequest.newBuilder().setZone(zone).build();
        return this.listInstances(request);
    }

    @BetaApi
    public final ListInstancesPagedResponse listInstances(ListInstancesHttpRequest request) {
        return (ListInstancesPagedResponse)((Object)this.listInstancesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListInstancesHttpRequest, ListInstancesPagedResponse> listInstancesPagedCallable() {
        return this.stub.listInstancesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListInstancesHttpRequest, InstanceList> listInstancesCallable() {
        return this.stub.listInstancesCallable();
    }

    @BetaApi
    public final ListReferrersInstancesPagedResponse listReferrersInstances(ProjectZoneInstanceName instance) {
        ListReferrersInstancesHttpRequest request = ListReferrersInstancesHttpRequest.newBuilder().setInstance(instance == null ? null : instance.toString()).build();
        return this.listReferrersInstances(request);
    }

    @BetaApi
    public final ListReferrersInstancesPagedResponse listReferrersInstances(String instance) {
        ListReferrersInstancesHttpRequest request = ListReferrersInstancesHttpRequest.newBuilder().setInstance(instance).build();
        return this.listReferrersInstances(request);
    }

    @BetaApi
    public final ListReferrersInstancesPagedResponse listReferrersInstances(ListReferrersInstancesHttpRequest request) {
        return (ListReferrersInstancesPagedResponse)((Object)this.listReferrersInstancesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListReferrersInstancesHttpRequest, ListReferrersInstancesPagedResponse> listReferrersInstancesPagedCallable() {
        return this.stub.listReferrersInstancesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListReferrersInstancesHttpRequest, InstanceListReferrers> listReferrersInstancesCallable() {
        return this.stub.listReferrersInstancesCallable();
    }

    @BetaApi
    public final Operation resetInstance(ProjectZoneInstanceName instance) {
        ResetInstanceHttpRequest request = ResetInstanceHttpRequest.newBuilder().setInstance(instance == null ? null : instance.toString()).build();
        return this.resetInstance(request);
    }

    @BetaApi
    public final Operation resetInstance(String instance) {
        ResetInstanceHttpRequest request = ResetInstanceHttpRequest.newBuilder().setInstance(instance).build();
        return this.resetInstance(request);
    }

    @BetaApi
    public final Operation resetInstance(ResetInstanceHttpRequest request) {
        return (Operation)this.resetInstanceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<ResetInstanceHttpRequest, Operation> resetInstanceCallable() {
        return this.stub.resetInstanceCallable();
    }

    @BetaApi
    public final Operation setDeletionProtectionInstance(ProjectZoneInstanceResourceName resource, Boolean deletionProtection) {
        SetDeletionProtectionInstanceHttpRequest request = SetDeletionProtectionInstanceHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setDeletionProtection(deletionProtection).build();
        return this.setDeletionProtectionInstance(request);
    }

    @BetaApi
    public final Operation setDeletionProtectionInstance(String resource, Boolean deletionProtection) {
        SetDeletionProtectionInstanceHttpRequest request = SetDeletionProtectionInstanceHttpRequest.newBuilder().setResource(resource).setDeletionProtection(deletionProtection).build();
        return this.setDeletionProtectionInstance(request);
    }

    @BetaApi
    public final Operation setDeletionProtectionInstance(SetDeletionProtectionInstanceHttpRequest request) {
        return (Operation)this.setDeletionProtectionInstanceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetDeletionProtectionInstanceHttpRequest, Operation> setDeletionProtectionInstanceCallable() {
        return this.stub.setDeletionProtectionInstanceCallable();
    }

    @BetaApi
    public final Operation setDiskAutoDeleteInstance(ProjectZoneInstanceName instance, Boolean autoDelete, String deviceName) {
        SetDiskAutoDeleteInstanceHttpRequest request = SetDiskAutoDeleteInstanceHttpRequest.newBuilder().setInstance(instance == null ? null : instance.toString()).setAutoDelete(autoDelete).setDeviceName(deviceName).build();
        return this.setDiskAutoDeleteInstance(request);
    }

    @BetaApi
    public final Operation setDiskAutoDeleteInstance(String instance, Boolean autoDelete, String deviceName) {
        SetDiskAutoDeleteInstanceHttpRequest request = SetDiskAutoDeleteInstanceHttpRequest.newBuilder().setInstance(instance).setAutoDelete(autoDelete).setDeviceName(deviceName).build();
        return this.setDiskAutoDeleteInstance(request);
    }

    @BetaApi
    public final Operation setDiskAutoDeleteInstance(SetDiskAutoDeleteInstanceHttpRequest request) {
        return (Operation)this.setDiskAutoDeleteInstanceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetDiskAutoDeleteInstanceHttpRequest, Operation> setDiskAutoDeleteInstanceCallable() {
        return this.stub.setDiskAutoDeleteInstanceCallable();
    }

    @BetaApi
    public final Operation setLabelsInstance(ProjectZoneInstanceName instance, InstancesSetLabelsRequest instancesSetLabelsRequestResource) {
        SetLabelsInstanceHttpRequest request = SetLabelsInstanceHttpRequest.newBuilder().setInstance(instance == null ? null : instance.toString()).setInstancesSetLabelsRequestResource(instancesSetLabelsRequestResource).build();
        return this.setLabelsInstance(request);
    }

    @BetaApi
    public final Operation setLabelsInstance(String instance, InstancesSetLabelsRequest instancesSetLabelsRequestResource) {
        SetLabelsInstanceHttpRequest request = SetLabelsInstanceHttpRequest.newBuilder().setInstance(instance).setInstancesSetLabelsRequestResource(instancesSetLabelsRequestResource).build();
        return this.setLabelsInstance(request);
    }

    @BetaApi
    public final Operation setLabelsInstance(SetLabelsInstanceHttpRequest request) {
        return (Operation)this.setLabelsInstanceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetLabelsInstanceHttpRequest, Operation> setLabelsInstanceCallable() {
        return this.stub.setLabelsInstanceCallable();
    }

    @BetaApi
    public final Operation setMachineResourcesInstance(ProjectZoneInstanceName instance, InstancesSetMachineResourcesRequest instancesSetMachineResourcesRequestResource) {
        SetMachineResourcesInstanceHttpRequest request = SetMachineResourcesInstanceHttpRequest.newBuilder().setInstance(instance == null ? null : instance.toString()).setInstancesSetMachineResourcesRequestResource(instancesSetMachineResourcesRequestResource).build();
        return this.setMachineResourcesInstance(request);
    }

    @BetaApi
    public final Operation setMachineResourcesInstance(String instance, InstancesSetMachineResourcesRequest instancesSetMachineResourcesRequestResource) {
        SetMachineResourcesInstanceHttpRequest request = SetMachineResourcesInstanceHttpRequest.newBuilder().setInstance(instance).setInstancesSetMachineResourcesRequestResource(instancesSetMachineResourcesRequestResource).build();
        return this.setMachineResourcesInstance(request);
    }

    @BetaApi
    public final Operation setMachineResourcesInstance(SetMachineResourcesInstanceHttpRequest request) {
        return (Operation)this.setMachineResourcesInstanceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetMachineResourcesInstanceHttpRequest, Operation> setMachineResourcesInstanceCallable() {
        return this.stub.setMachineResourcesInstanceCallable();
    }

    @BetaApi
    public final Operation setMachineTypeInstance(ProjectZoneInstanceName instance, InstancesSetMachineTypeRequest instancesSetMachineTypeRequestResource) {
        SetMachineTypeInstanceHttpRequest request = SetMachineTypeInstanceHttpRequest.newBuilder().setInstance(instance == null ? null : instance.toString()).setInstancesSetMachineTypeRequestResource(instancesSetMachineTypeRequestResource).build();
        return this.setMachineTypeInstance(request);
    }

    @BetaApi
    public final Operation setMachineTypeInstance(String instance, InstancesSetMachineTypeRequest instancesSetMachineTypeRequestResource) {
        SetMachineTypeInstanceHttpRequest request = SetMachineTypeInstanceHttpRequest.newBuilder().setInstance(instance).setInstancesSetMachineTypeRequestResource(instancesSetMachineTypeRequestResource).build();
        return this.setMachineTypeInstance(request);
    }

    @BetaApi
    public final Operation setMachineTypeInstance(SetMachineTypeInstanceHttpRequest request) {
        return (Operation)this.setMachineTypeInstanceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetMachineTypeInstanceHttpRequest, Operation> setMachineTypeInstanceCallable() {
        return this.stub.setMachineTypeInstanceCallable();
    }

    @BetaApi
    public final Operation setMetadataInstance(ProjectZoneInstanceName instance, Metadata metadataResource) {
        SetMetadataInstanceHttpRequest request = SetMetadataInstanceHttpRequest.newBuilder().setInstance(instance == null ? null : instance.toString()).setMetadataResource(metadataResource).build();
        return this.setMetadataInstance(request);
    }

    @BetaApi
    public final Operation setMetadataInstance(String instance, Metadata metadataResource) {
        SetMetadataInstanceHttpRequest request = SetMetadataInstanceHttpRequest.newBuilder().setInstance(instance).setMetadataResource(metadataResource).build();
        return this.setMetadataInstance(request);
    }

    @BetaApi
    public final Operation setMetadataInstance(SetMetadataInstanceHttpRequest request) {
        return (Operation)this.setMetadataInstanceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetMetadataInstanceHttpRequest, Operation> setMetadataInstanceCallable() {
        return this.stub.setMetadataInstanceCallable();
    }

    @BetaApi
    public final Operation setMinCpuPlatformInstance(ProjectZoneInstanceName instance, InstancesSetMinCpuPlatformRequest instancesSetMinCpuPlatformRequestResource) {
        SetMinCpuPlatformInstanceHttpRequest request = SetMinCpuPlatformInstanceHttpRequest.newBuilder().setInstance(instance == null ? null : instance.toString()).setInstancesSetMinCpuPlatformRequestResource(instancesSetMinCpuPlatformRequestResource).build();
        return this.setMinCpuPlatformInstance(request);
    }

    @BetaApi
    public final Operation setMinCpuPlatformInstance(String instance, InstancesSetMinCpuPlatformRequest instancesSetMinCpuPlatformRequestResource) {
        SetMinCpuPlatformInstanceHttpRequest request = SetMinCpuPlatformInstanceHttpRequest.newBuilder().setInstance(instance).setInstancesSetMinCpuPlatformRequestResource(instancesSetMinCpuPlatformRequestResource).build();
        return this.setMinCpuPlatformInstance(request);
    }

    @BetaApi
    public final Operation setMinCpuPlatformInstance(SetMinCpuPlatformInstanceHttpRequest request) {
        return (Operation)this.setMinCpuPlatformInstanceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetMinCpuPlatformInstanceHttpRequest, Operation> setMinCpuPlatformInstanceCallable() {
        return this.stub.setMinCpuPlatformInstanceCallable();
    }

    @BetaApi
    public final Operation setSchedulingInstance(ProjectZoneInstanceName instance, Scheduling schedulingResource) {
        SetSchedulingInstanceHttpRequest request = SetSchedulingInstanceHttpRequest.newBuilder().setInstance(instance == null ? null : instance.toString()).setSchedulingResource(schedulingResource).build();
        return this.setSchedulingInstance(request);
    }

    @BetaApi
    public final Operation setSchedulingInstance(String instance, Scheduling schedulingResource) {
        SetSchedulingInstanceHttpRequest request = SetSchedulingInstanceHttpRequest.newBuilder().setInstance(instance).setSchedulingResource(schedulingResource).build();
        return this.setSchedulingInstance(request);
    }

    @BetaApi
    public final Operation setSchedulingInstance(SetSchedulingInstanceHttpRequest request) {
        return (Operation)this.setSchedulingInstanceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetSchedulingInstanceHttpRequest, Operation> setSchedulingInstanceCallable() {
        return this.stub.setSchedulingInstanceCallable();
    }

    @BetaApi
    public final Operation setServiceAccountInstance(ProjectZoneInstanceName instance, InstancesSetServiceAccountRequest instancesSetServiceAccountRequestResource) {
        SetServiceAccountInstanceHttpRequest request = SetServiceAccountInstanceHttpRequest.newBuilder().setInstance(instance == null ? null : instance.toString()).setInstancesSetServiceAccountRequestResource(instancesSetServiceAccountRequestResource).build();
        return this.setServiceAccountInstance(request);
    }

    @BetaApi
    public final Operation setServiceAccountInstance(String instance, InstancesSetServiceAccountRequest instancesSetServiceAccountRequestResource) {
        SetServiceAccountInstanceHttpRequest request = SetServiceAccountInstanceHttpRequest.newBuilder().setInstance(instance).setInstancesSetServiceAccountRequestResource(instancesSetServiceAccountRequestResource).build();
        return this.setServiceAccountInstance(request);
    }

    @BetaApi
    public final Operation setServiceAccountInstance(SetServiceAccountInstanceHttpRequest request) {
        return (Operation)this.setServiceAccountInstanceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetServiceAccountInstanceHttpRequest, Operation> setServiceAccountInstanceCallable() {
        return this.stub.setServiceAccountInstanceCallable();
    }

    @BetaApi
    public final Operation setTagsInstance(ProjectZoneInstanceName instance, Tags tagsResource) {
        SetTagsInstanceHttpRequest request = SetTagsInstanceHttpRequest.newBuilder().setInstance(instance == null ? null : instance.toString()).setTagsResource(tagsResource).build();
        return this.setTagsInstance(request);
    }

    @BetaApi
    public final Operation setTagsInstance(String instance, Tags tagsResource) {
        SetTagsInstanceHttpRequest request = SetTagsInstanceHttpRequest.newBuilder().setInstance(instance).setTagsResource(tagsResource).build();
        return this.setTagsInstance(request);
    }

    @BetaApi
    public final Operation setTagsInstance(SetTagsInstanceHttpRequest request) {
        return (Operation)this.setTagsInstanceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetTagsInstanceHttpRequest, Operation> setTagsInstanceCallable() {
        return this.stub.setTagsInstanceCallable();
    }

    @BetaApi
    public final Operation simulateMaintenanceEventInstance(ProjectZoneInstanceName instance) {
        SimulateMaintenanceEventInstanceHttpRequest request = SimulateMaintenanceEventInstanceHttpRequest.newBuilder().setInstance(instance == null ? null : instance.toString()).build();
        return this.simulateMaintenanceEventInstance(request);
    }

    @BetaApi
    public final Operation simulateMaintenanceEventInstance(String instance) {
        SimulateMaintenanceEventInstanceHttpRequest request = SimulateMaintenanceEventInstanceHttpRequest.newBuilder().setInstance(instance).build();
        return this.simulateMaintenanceEventInstance(request);
    }

    @BetaApi
    public final Operation simulateMaintenanceEventInstance(SimulateMaintenanceEventInstanceHttpRequest request) {
        return (Operation)this.simulateMaintenanceEventInstanceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SimulateMaintenanceEventInstanceHttpRequest, Operation> simulateMaintenanceEventInstanceCallable() {
        return this.stub.simulateMaintenanceEventInstanceCallable();
    }

    @BetaApi
    public final Operation startInstance(ProjectZoneInstanceName instance) {
        StartInstanceHttpRequest request = StartInstanceHttpRequest.newBuilder().setInstance(instance == null ? null : instance.toString()).build();
        return this.startInstance(request);
    }

    @BetaApi
    public final Operation startInstance(String instance) {
        StartInstanceHttpRequest request = StartInstanceHttpRequest.newBuilder().setInstance(instance).build();
        return this.startInstance(request);
    }

    @BetaApi
    public final Operation startInstance(StartInstanceHttpRequest request) {
        return (Operation)this.startInstanceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<StartInstanceHttpRequest, Operation> startInstanceCallable() {
        return this.stub.startInstanceCallable();
    }

    @BetaApi
    public final Operation startWithEncryptionKeyInstance(ProjectZoneInstanceName instance, InstancesStartWithEncryptionKeyRequest instancesStartWithEncryptionKeyRequestResource) {
        StartWithEncryptionKeyInstanceHttpRequest request = StartWithEncryptionKeyInstanceHttpRequest.newBuilder().setInstance(instance == null ? null : instance.toString()).setInstancesStartWithEncryptionKeyRequestResource(instancesStartWithEncryptionKeyRequestResource).build();
        return this.startWithEncryptionKeyInstance(request);
    }

    @BetaApi
    public final Operation startWithEncryptionKeyInstance(String instance, InstancesStartWithEncryptionKeyRequest instancesStartWithEncryptionKeyRequestResource) {
        StartWithEncryptionKeyInstanceHttpRequest request = StartWithEncryptionKeyInstanceHttpRequest.newBuilder().setInstance(instance).setInstancesStartWithEncryptionKeyRequestResource(instancesStartWithEncryptionKeyRequestResource).build();
        return this.startWithEncryptionKeyInstance(request);
    }

    @BetaApi
    public final Operation startWithEncryptionKeyInstance(StartWithEncryptionKeyInstanceHttpRequest request) {
        return (Operation)this.startWithEncryptionKeyInstanceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<StartWithEncryptionKeyInstanceHttpRequest, Operation> startWithEncryptionKeyInstanceCallable() {
        return this.stub.startWithEncryptionKeyInstanceCallable();
    }

    @BetaApi
    public final Operation stopInstance(ProjectZoneInstanceName instance) {
        StopInstanceHttpRequest request = StopInstanceHttpRequest.newBuilder().setInstance(instance == null ? null : instance.toString()).build();
        return this.stopInstance(request);
    }

    @BetaApi
    public final Operation stopInstance(String instance) {
        StopInstanceHttpRequest request = StopInstanceHttpRequest.newBuilder().setInstance(instance).build();
        return this.stopInstance(request);
    }

    @BetaApi
    public final Operation stopInstance(StopInstanceHttpRequest request) {
        return (Operation)this.stopInstanceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<StopInstanceHttpRequest, Operation> stopInstanceCallable() {
        return this.stub.stopInstanceCallable();
    }

    @BetaApi
    public final Operation updateAccessConfigInstance(ProjectZoneInstanceName instance, String networkInterface, AccessConfig accessConfigResource) {
        UpdateAccessConfigInstanceHttpRequest request = UpdateAccessConfigInstanceHttpRequest.newBuilder().setInstance(instance == null ? null : instance.toString()).setNetworkInterface(networkInterface).setAccessConfigResource(accessConfigResource).build();
        return this.updateAccessConfigInstance(request);
    }

    @BetaApi
    public final Operation updateAccessConfigInstance(String instance, String networkInterface, AccessConfig accessConfigResource) {
        UpdateAccessConfigInstanceHttpRequest request = UpdateAccessConfigInstanceHttpRequest.newBuilder().setInstance(instance).setNetworkInterface(networkInterface).setAccessConfigResource(accessConfigResource).build();
        return this.updateAccessConfigInstance(request);
    }

    @BetaApi
    public final Operation updateAccessConfigInstance(UpdateAccessConfigInstanceHttpRequest request) {
        return (Operation)this.updateAccessConfigInstanceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<UpdateAccessConfigInstanceHttpRequest, Operation> updateAccessConfigInstanceCallable() {
        return this.stub.updateAccessConfigInstanceCallable();
    }

    @BetaApi
    public final Operation updateNetworkInterfaceInstance(ProjectZoneInstanceName instance, String networkInterface, NetworkInterface networkInterfaceResource, List<String> fieldMask) {
        UpdateNetworkInterfaceInstanceHttpRequest request = UpdateNetworkInterfaceInstanceHttpRequest.newBuilder().setInstance(instance == null ? null : instance.toString()).setNetworkInterface(networkInterface).setNetworkInterfaceResource(networkInterfaceResource).addAllFieldMask(fieldMask).build();
        return this.updateNetworkInterfaceInstance(request);
    }

    @BetaApi
    public final Operation updateNetworkInterfaceInstance(String instance, String networkInterface, NetworkInterface networkInterfaceResource, List<String> fieldMask) {
        UpdateNetworkInterfaceInstanceHttpRequest request = UpdateNetworkInterfaceInstanceHttpRequest.newBuilder().setInstance(instance).setNetworkInterface(networkInterface).setNetworkInterfaceResource(networkInterfaceResource).addAllFieldMask(fieldMask).build();
        return this.updateNetworkInterfaceInstance(request);
    }

    @BetaApi
    public final Operation updateNetworkInterfaceInstance(UpdateNetworkInterfaceInstanceHttpRequest request) {
        return (Operation)this.updateNetworkInterfaceInstanceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<UpdateNetworkInterfaceInstanceHttpRequest, Operation> updateNetworkInterfaceInstanceCallable() {
        return this.stub.updateNetworkInterfaceInstanceCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListReferrersInstancesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListReferrersInstancesHttpRequest, InstanceListReferrers, Reference, ListReferrersInstancesPage, ListReferrersInstancesFixedSizeCollection> {
        private ListReferrersInstancesFixedSizeCollection(List<ListReferrersInstancesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListReferrersInstancesFixedSizeCollection createEmptyCollection() {
            return new ListReferrersInstancesFixedSizeCollection(null, 0);
        }

        protected ListReferrersInstancesFixedSizeCollection createCollection(List<ListReferrersInstancesPage> pages, int collectionSize) {
            return new ListReferrersInstancesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListReferrersInstancesPage
    extends AbstractPage<ListReferrersInstancesHttpRequest, InstanceListReferrers, Reference, ListReferrersInstancesPage> {
        private ListReferrersInstancesPage(PageContext<ListReferrersInstancesHttpRequest, InstanceListReferrers, Reference> context, InstanceListReferrers response) {
            super(context, (Object)response);
        }

        private static ListReferrersInstancesPage createEmptyPage() {
            return new ListReferrersInstancesPage(null, null);
        }

        protected ListReferrersInstancesPage createPage(PageContext<ListReferrersInstancesHttpRequest, InstanceListReferrers, Reference> context, InstanceListReferrers response) {
            return new ListReferrersInstancesPage(context, response);
        }

        public ApiFuture<ListReferrersInstancesPage> createPageAsync(PageContext<ListReferrersInstancesHttpRequest, InstanceListReferrers, Reference> context, ApiFuture<InstanceListReferrers> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListReferrersInstancesPagedResponse
    extends AbstractPagedListResponse<ListReferrersInstancesHttpRequest, InstanceListReferrers, Reference, ListReferrersInstancesPage, ListReferrersInstancesFixedSizeCollection> {
        public static ApiFuture<ListReferrersInstancesPagedResponse> createAsync(PageContext<ListReferrersInstancesHttpRequest, InstanceListReferrers, Reference> context, ApiFuture<InstanceListReferrers> futureResponse) {
            ApiFuture<ListReferrersInstancesPage> futurePage = ListReferrersInstancesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListReferrersInstancesPage, ListReferrersInstancesPagedResponse>(){

                public ListReferrersInstancesPagedResponse apply(ListReferrersInstancesPage input) {
                    return new ListReferrersInstancesPagedResponse(input);
                }
            });
        }

        private ListReferrersInstancesPagedResponse(ListReferrersInstancesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListReferrersInstancesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListInstancesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstancesHttpRequest, InstanceList, Instance, ListInstancesPage, ListInstancesFixedSizeCollection> {
        private ListInstancesFixedSizeCollection(List<ListInstancesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInstancesFixedSizeCollection createEmptyCollection() {
            return new ListInstancesFixedSizeCollection(null, 0);
        }

        protected ListInstancesFixedSizeCollection createCollection(List<ListInstancesPage> pages, int collectionSize) {
            return new ListInstancesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInstancesPage
    extends AbstractPage<ListInstancesHttpRequest, InstanceList, Instance, ListInstancesPage> {
        private ListInstancesPage(PageContext<ListInstancesHttpRequest, InstanceList, Instance> context, InstanceList response) {
            super(context, (Object)response);
        }

        private static ListInstancesPage createEmptyPage() {
            return new ListInstancesPage(null, null);
        }

        protected ListInstancesPage createPage(PageContext<ListInstancesHttpRequest, InstanceList, Instance> context, InstanceList response) {
            return new ListInstancesPage(context, response);
        }

        public ApiFuture<ListInstancesPage> createPageAsync(PageContext<ListInstancesHttpRequest, InstanceList, Instance> context, ApiFuture<InstanceList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInstancesPagedResponse
    extends AbstractPagedListResponse<ListInstancesHttpRequest, InstanceList, Instance, ListInstancesPage, ListInstancesFixedSizeCollection> {
        public static ApiFuture<ListInstancesPagedResponse> createAsync(PageContext<ListInstancesHttpRequest, InstanceList, Instance> context, ApiFuture<InstanceList> futureResponse) {
            ApiFuture<ListInstancesPage> futurePage = ListInstancesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListInstancesPage, ListInstancesPagedResponse>(){

                public ListInstancesPagedResponse apply(ListInstancesPage input) {
                    return new ListInstancesPagedResponse(input);
                }
            });
        }

        private ListInstancesPagedResponse(ListInstancesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInstancesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListInstancesFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListInstancesHttpRequest, InstanceAggregatedList, InstancesScopedList, AggregatedListInstancesPage, AggregatedListInstancesFixedSizeCollection> {
        private AggregatedListInstancesFixedSizeCollection(List<AggregatedListInstancesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListInstancesFixedSizeCollection createEmptyCollection() {
            return new AggregatedListInstancesFixedSizeCollection(null, 0);
        }

        protected AggregatedListInstancesFixedSizeCollection createCollection(List<AggregatedListInstancesPage> pages, int collectionSize) {
            return new AggregatedListInstancesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListInstancesPage
    extends AbstractPage<AggregatedListInstancesHttpRequest, InstanceAggregatedList, InstancesScopedList, AggregatedListInstancesPage> {
        private AggregatedListInstancesPage(PageContext<AggregatedListInstancesHttpRequest, InstanceAggregatedList, InstancesScopedList> context, InstanceAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListInstancesPage createEmptyPage() {
            return new AggregatedListInstancesPage(null, null);
        }

        protected AggregatedListInstancesPage createPage(PageContext<AggregatedListInstancesHttpRequest, InstanceAggregatedList, InstancesScopedList> context, InstanceAggregatedList response) {
            return new AggregatedListInstancesPage(context, response);
        }

        public ApiFuture<AggregatedListInstancesPage> createPageAsync(PageContext<AggregatedListInstancesHttpRequest, InstanceAggregatedList, InstancesScopedList> context, ApiFuture<InstanceAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListInstancesPagedResponse
    extends AbstractPagedListResponse<AggregatedListInstancesHttpRequest, InstanceAggregatedList, InstancesScopedList, AggregatedListInstancesPage, AggregatedListInstancesFixedSizeCollection> {
        public static ApiFuture<AggregatedListInstancesPagedResponse> createAsync(PageContext<AggregatedListInstancesHttpRequest, InstanceAggregatedList, InstancesScopedList> context, ApiFuture<InstanceAggregatedList> futureResponse) {
            ApiFuture<AggregatedListInstancesPage> futurePage = AggregatedListInstancesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListInstancesPage, AggregatedListInstancesPagedResponse>(){

                public AggregatedListInstancesPagedResponse apply(AggregatedListInstancesPage input) {
                    return new AggregatedListInstancesPagedResponse(input);
                }
            });
        }

        private AggregatedListInstancesPagedResponse(AggregatedListInstancesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListInstancesFixedSizeCollection.createEmptyCollection());
        }
    }
}

