/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.CustomerEncryptionKey;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class AttachedDiskInitializeParams
implements ApiMessage {
    private final String diskName;
    private final String diskSizeGb;
    private final String diskType;
    private final Map<String, String> labels;
    private final String sourceImage;
    private final CustomerEncryptionKey sourceImageEncryptionKey;
    private static final AttachedDiskInitializeParams DEFAULT_INSTANCE = new AttachedDiskInitializeParams();

    private AttachedDiskInitializeParams() {
        this.diskName = null;
        this.diskSizeGb = null;
        this.diskType = null;
        this.labels = null;
        this.sourceImage = null;
        this.sourceImageEncryptionKey = null;
    }

    private AttachedDiskInitializeParams(String diskName, String diskSizeGb, String diskType, Map<String, String> labels, String sourceImage, CustomerEncryptionKey sourceImageEncryptionKey) {
        this.diskName = diskName;
        this.diskSizeGb = diskSizeGb;
        this.diskType = diskType;
        this.labels = labels;
        this.sourceImage = sourceImage;
        this.sourceImageEncryptionKey = sourceImageEncryptionKey;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("diskName")) {
            return this.diskName;
        }
        if (fieldName.equals("diskSizeGb")) {
            return this.diskSizeGb;
        }
        if (fieldName.equals("diskType")) {
            return this.diskType;
        }
        if (fieldName.equals("labels")) {
            return this.labels;
        }
        if (fieldName.equals("sourceImage")) {
            return this.sourceImage;
        }
        if (fieldName.equals("sourceImageEncryptionKey")) {
            return this.sourceImageEncryptionKey;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getDiskName() {
        return this.diskName;
    }

    public String getDiskSizeGb() {
        return this.diskSizeGb;
    }

    public String getDiskType() {
        return this.diskType;
    }

    public Map<String, String> getLabelsMap() {
        return this.labels;
    }

    public String getSourceImage() {
        return this.sourceImage;
    }

    public CustomerEncryptionKey getSourceImageEncryptionKey() {
        return this.sourceImageEncryptionKey;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(AttachedDiskInitializeParams prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static AttachedDiskInitializeParams getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "AttachedDiskInitializeParams{diskName=" + this.diskName + ", diskSizeGb=" + this.diskSizeGb + ", diskType=" + this.diskType + ", labels=" + this.labels + ", sourceImage=" + this.sourceImage + ", sourceImageEncryptionKey=" + this.sourceImageEncryptionKey + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AttachedDiskInitializeParams) {
            AttachedDiskInitializeParams that = (AttachedDiskInitializeParams)o;
            return Objects.equals(this.diskName, that.getDiskName()) && Objects.equals(this.diskSizeGb, that.getDiskSizeGb()) && Objects.equals(this.diskType, that.getDiskType()) && Objects.equals(this.labels, that.getLabelsMap()) && Objects.equals(this.sourceImage, that.getSourceImage()) && Objects.equals(this.sourceImageEncryptionKey, that.getSourceImageEncryptionKey());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.diskName, this.diskSizeGb, this.diskType, this.labels, this.sourceImage, this.sourceImageEncryptionKey);
    }

    public static class Builder {
        private String diskName;
        private String diskSizeGb;
        private String diskType;
        private Map<String, String> labels;
        private String sourceImage;
        private CustomerEncryptionKey sourceImageEncryptionKey;

        Builder() {
        }

        public Builder mergeFrom(AttachedDiskInitializeParams other) {
            if (other == AttachedDiskInitializeParams.getDefaultInstance()) {
                return this;
            }
            if (other.getDiskName() != null) {
                this.diskName = other.diskName;
            }
            if (other.getDiskSizeGb() != null) {
                this.diskSizeGb = other.diskSizeGb;
            }
            if (other.getDiskType() != null) {
                this.diskType = other.diskType;
            }
            if (other.getLabelsMap() != null) {
                this.labels = other.labels;
            }
            if (other.getSourceImage() != null) {
                this.sourceImage = other.sourceImage;
            }
            if (other.getSourceImageEncryptionKey() != null) {
                this.sourceImageEncryptionKey = other.sourceImageEncryptionKey;
            }
            return this;
        }

        Builder(AttachedDiskInitializeParams source) {
            this.diskName = source.diskName;
            this.diskSizeGb = source.diskSizeGb;
            this.diskType = source.diskType;
            this.labels = source.labels;
            this.sourceImage = source.sourceImage;
            this.sourceImageEncryptionKey = source.sourceImageEncryptionKey;
        }

        public String getDiskName() {
            return this.diskName;
        }

        public Builder setDiskName(String diskName) {
            this.diskName = diskName;
            return this;
        }

        public String getDiskSizeGb() {
            return this.diskSizeGb;
        }

        public Builder setDiskSizeGb(String diskSizeGb) {
            this.diskSizeGb = diskSizeGb;
            return this;
        }

        public String getDiskType() {
            return this.diskType;
        }

        public Builder setDiskType(String diskType) {
            this.diskType = diskType;
            return this;
        }

        public Map<String, String> getLabelsMap() {
            return this.labels;
        }

        public Builder putAllLabels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public String getSourceImage() {
            return this.sourceImage;
        }

        public Builder setSourceImage(String sourceImage) {
            this.sourceImage = sourceImage;
            return this;
        }

        public CustomerEncryptionKey getSourceImageEncryptionKey() {
            return this.sourceImageEncryptionKey;
        }

        public Builder setSourceImageEncryptionKey(CustomerEncryptionKey sourceImageEncryptionKey) {
            this.sourceImageEncryptionKey = sourceImageEncryptionKey;
            return this;
        }

        public AttachedDiskInitializeParams build() {
            return new AttachedDiskInitializeParams(this.diskName, this.diskSizeGb, this.diskType, this.labels, this.sourceImage, this.sourceImageEncryptionKey);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setDiskName(this.diskName);
            newBuilder.setDiskSizeGb(this.diskSizeGb);
            newBuilder.setDiskType(this.diskType);
            newBuilder.putAllLabels(this.labels);
            newBuilder.setSourceImage(this.sourceImage);
            newBuilder.setSourceImageEncryptionKey(this.sourceImageEncryptionKey);
            return newBuilder;
        }
    }
}

