/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteHttpHealthCheckHttpRequest;
import com.google.cloud.compute.v1.GetHttpHealthCheckHttpRequest;
import com.google.cloud.compute.v1.HttpHealthCheck2;
import com.google.cloud.compute.v1.HttpHealthCheckClient;
import com.google.cloud.compute.v1.HttpHealthCheckList;
import com.google.cloud.compute.v1.InsertHttpHealthCheckHttpRequest;
import com.google.cloud.compute.v1.ListHttpHealthChecksHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchHttpHealthCheckHttpRequest;
import com.google.cloud.compute.v1.UpdateHttpHealthCheckHttpRequest;
import com.google.cloud.compute.v1.stub.HttpHealthCheckStub;
import com.google.cloud.compute.v1.stub.HttpJsonHttpHealthCheckStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class HttpHealthCheckStubSettings
extends StubSettings<HttpHealthCheckStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DeleteHttpHealthCheckHttpRequest, Operation> deleteHttpHealthCheckSettings;
    private final UnaryCallSettings<GetHttpHealthCheckHttpRequest, HttpHealthCheck2> getHttpHealthCheckSettings;
    private final UnaryCallSettings<InsertHttpHealthCheckHttpRequest, Operation> insertHttpHealthCheckSettings;
    private final PagedCallSettings<ListHttpHealthChecksHttpRequest, HttpHealthCheckList, HttpHealthCheckClient.ListHttpHealthChecksPagedResponse> listHttpHealthChecksSettings;
    private final UnaryCallSettings<PatchHttpHealthCheckHttpRequest, Operation> patchHttpHealthCheckSettings;
    private final UnaryCallSettings<UpdateHttpHealthCheckHttpRequest, Operation> updateHttpHealthCheckSettings;
    private static final PagedListDescriptor<ListHttpHealthChecksHttpRequest, HttpHealthCheckList, HttpHealthCheck2> LIST_HTTP_HEALTH_CHECKS_PAGE_STR_DESC = new PagedListDescriptor<ListHttpHealthChecksHttpRequest, HttpHealthCheckList, HttpHealthCheck2>(){

        public String emptyToken() {
            return "";
        }

        public ListHttpHealthChecksHttpRequest injectToken(ListHttpHealthChecksHttpRequest payload, String token) {
            return ListHttpHealthChecksHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListHttpHealthChecksHttpRequest injectPageSize(ListHttpHealthChecksHttpRequest payload, int pageSize) {
            return ListHttpHealthChecksHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListHttpHealthChecksHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(HttpHealthCheckList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<HttpHealthCheck2> extractResources(HttpHealthCheckList payload) {
            return payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<ListHttpHealthChecksHttpRequest, HttpHealthCheckList, HttpHealthCheckClient.ListHttpHealthChecksPagedResponse> LIST_HTTP_HEALTH_CHECKS_PAGE_STR_FACT = new PagedListResponseFactory<ListHttpHealthChecksHttpRequest, HttpHealthCheckList, HttpHealthCheckClient.ListHttpHealthChecksPagedResponse>(){

        public ApiFuture<HttpHealthCheckClient.ListHttpHealthChecksPagedResponse> getFuturePagedResponse(UnaryCallable<ListHttpHealthChecksHttpRequest, HttpHealthCheckList> callable, ListHttpHealthChecksHttpRequest request, ApiCallContext context, ApiFuture<HttpHealthCheckList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_HTTP_HEALTH_CHECKS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return HttpHealthCheckClient.ListHttpHealthChecksPagedResponse.createAsync((PageContext<ListHttpHealthChecksHttpRequest, HttpHealthCheckList, HttpHealthCheck2>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteHttpHealthCheckHttpRequest, Operation> deleteHttpHealthCheckSettings() {
        return this.deleteHttpHealthCheckSettings;
    }

    public UnaryCallSettings<GetHttpHealthCheckHttpRequest, HttpHealthCheck2> getHttpHealthCheckSettings() {
        return this.getHttpHealthCheckSettings;
    }

    public UnaryCallSettings<InsertHttpHealthCheckHttpRequest, Operation> insertHttpHealthCheckSettings() {
        return this.insertHttpHealthCheckSettings;
    }

    public PagedCallSettings<ListHttpHealthChecksHttpRequest, HttpHealthCheckList, HttpHealthCheckClient.ListHttpHealthChecksPagedResponse> listHttpHealthChecksSettings() {
        return this.listHttpHealthChecksSettings;
    }

    public UnaryCallSettings<PatchHttpHealthCheckHttpRequest, Operation> patchHttpHealthCheckSettings() {
        return this.patchHttpHealthCheckSettings;
    }

    public UnaryCallSettings<UpdateHttpHealthCheckHttpRequest, Operation> updateHttpHealthCheckSettings() {
        return this.updateHttpHealthCheckSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public HttpHealthCheckStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonHttpHealthCheckStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return HttpHealthCheckStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(HttpHealthCheckStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected HttpHealthCheckStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteHttpHealthCheckSettings = settingsBuilder.deleteHttpHealthCheckSettings().build();
        this.getHttpHealthCheckSettings = settingsBuilder.getHttpHealthCheckSettings().build();
        this.insertHttpHealthCheckSettings = settingsBuilder.insertHttpHealthCheckSettings().build();
        this.listHttpHealthChecksSettings = settingsBuilder.listHttpHealthChecksSettings().build();
        this.patchHttpHealthCheckSettings = settingsBuilder.patchHttpHealthCheckSettings().build();
        this.updateHttpHealthCheckSettings = settingsBuilder.updateHttpHealthCheckSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<HttpHealthCheckStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteHttpHealthCheckHttpRequest, Operation> deleteHttpHealthCheckSettings;
        private final UnaryCallSettings.Builder<GetHttpHealthCheckHttpRequest, HttpHealthCheck2> getHttpHealthCheckSettings;
        private final UnaryCallSettings.Builder<InsertHttpHealthCheckHttpRequest, Operation> insertHttpHealthCheckSettings;
        private final PagedCallSettings.Builder<ListHttpHealthChecksHttpRequest, HttpHealthCheckList, HttpHealthCheckClient.ListHttpHealthChecksPagedResponse> listHttpHealthChecksSettings;
        private final UnaryCallSettings.Builder<PatchHttpHealthCheckHttpRequest, Operation> patchHttpHealthCheckSettings;
        private final UnaryCallSettings.Builder<UpdateHttpHealthCheckHttpRequest, Operation> updateHttpHealthCheckSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteHttpHealthCheckSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getHttpHealthCheckSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertHttpHealthCheckSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listHttpHealthChecksSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_HTTP_HEALTH_CHECKS_PAGE_STR_FACT);
            this.patchHttpHealthCheckSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateHttpHealthCheckSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteHttpHealthCheckSettings, this.getHttpHealthCheckSettings, this.insertHttpHealthCheckSettings, this.listHttpHealthChecksSettings, this.patchHttpHealthCheckSettings, this.updateHttpHealthCheckSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(HttpHealthCheckStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)HttpHealthCheckStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)HttpHealthCheckStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(HttpHealthCheckStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteHttpHealthCheckSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getHttpHealthCheckSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertHttpHealthCheckSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listHttpHealthChecksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.patchHttpHealthCheckSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateHttpHealthCheckSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(HttpHealthCheckStubSettings settings) {
            super((StubSettings)settings);
            this.deleteHttpHealthCheckSettings = settings.deleteHttpHealthCheckSettings.toBuilder();
            this.getHttpHealthCheckSettings = settings.getHttpHealthCheckSettings.toBuilder();
            this.insertHttpHealthCheckSettings = settings.insertHttpHealthCheckSettings.toBuilder();
            this.listHttpHealthChecksSettings = settings.listHttpHealthChecksSettings.toBuilder();
            this.patchHttpHealthCheckSettings = settings.patchHttpHealthCheckSettings.toBuilder();
            this.updateHttpHealthCheckSettings = settings.updateHttpHealthCheckSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteHttpHealthCheckSettings, this.getHttpHealthCheckSettings, this.insertHttpHealthCheckSettings, this.listHttpHealthChecksSettings, this.patchHttpHealthCheckSettings, this.updateHttpHealthCheckSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteHttpHealthCheckHttpRequest, Operation> deleteHttpHealthCheckSettings() {
            return this.deleteHttpHealthCheckSettings;
        }

        public UnaryCallSettings.Builder<GetHttpHealthCheckHttpRequest, HttpHealthCheck2> getHttpHealthCheckSettings() {
            return this.getHttpHealthCheckSettings;
        }

        public UnaryCallSettings.Builder<InsertHttpHealthCheckHttpRequest, Operation> insertHttpHealthCheckSettings() {
            return this.insertHttpHealthCheckSettings;
        }

        public PagedCallSettings.Builder<ListHttpHealthChecksHttpRequest, HttpHealthCheckList, HttpHealthCheckClient.ListHttpHealthChecksPagedResponse> listHttpHealthChecksSettings() {
            return this.listHttpHealthChecksSettings;
        }

        public UnaryCallSettings.Builder<PatchHttpHealthCheckHttpRequest, Operation> patchHttpHealthCheckSettings() {
            return this.patchHttpHealthCheckSettings;
        }

        public UnaryCallSettings.Builder<UpdateHttpHealthCheckHttpRequest, Operation> updateHttpHealthCheckSettings() {
            return this.updateHttpHealthCheckSettings;
        }

        public HttpHealthCheckStubSettings build() throws IOException {
            return new HttpHealthCheckStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

