/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.Address;
import com.google.cloud.compute.v1.Warning;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class AddressesScopedList
implements ApiMessage {
    private final List<Address> addresses;
    private final Warning warning;
    private static final AddressesScopedList DEFAULT_INSTANCE = new AddressesScopedList();

    private AddressesScopedList() {
        this.addresses = null;
        this.warning = null;
    }

    private AddressesScopedList(List<Address> addresses, Warning warning) {
        this.addresses = addresses;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("addresses")) {
            return this.addresses;
        }
        if (fieldName.equals("warning")) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<Address> getAddressesList() {
        return this.addresses;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(AddressesScopedList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static AddressesScopedList getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "AddressesScopedList{addresses=" + this.addresses + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AddressesScopedList) {
            AddressesScopedList that = (AddressesScopedList)o;
            return Objects.equals(this.addresses, that.getAddressesList()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.addresses, this.warning);
    }

    public static class Builder {
        private List<Address> addresses;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(AddressesScopedList other) {
            if (other == AddressesScopedList.getDefaultInstance()) {
                return this;
            }
            if (other.getAddressesList() != null) {
                this.addresses = other.addresses;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(AddressesScopedList source) {
            this.addresses = source.addresses;
            this.warning = source.warning;
        }

        public List<Address> getAddressesList() {
            return this.addresses;
        }

        public Builder addAllAddresses(List<Address> addresses) {
            if (this.addresses == null) {
                this.addresses = new LinkedList<Address>();
            }
            this.addresses.addAll(addresses);
            return this;
        }

        public Builder addAddresses(Address addresses) {
            if (this.addresses == null) {
                this.addresses = new LinkedList<Address>();
            }
            this.addresses.add(addresses);
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public AddressesScopedList build() {
            return new AddressesScopedList(this.addresses, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllAddresses(this.addresses);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

