/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListTargetInstancesHttpRequest;
import com.google.cloud.compute.v1.DeleteTargetInstanceHttpRequest;
import com.google.cloud.compute.v1.GetTargetInstanceHttpRequest;
import com.google.cloud.compute.v1.InsertTargetInstanceHttpRequest;
import com.google.cloud.compute.v1.ListTargetInstancesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectZoneName;
import com.google.cloud.compute.v1.ProjectZoneTargetInstanceName;
import com.google.cloud.compute.v1.TargetInstance;
import com.google.cloud.compute.v1.TargetInstanceAggregatedList;
import com.google.cloud.compute.v1.TargetInstanceList;
import com.google.cloud.compute.v1.TargetInstanceSettings;
import com.google.cloud.compute.v1.TargetInstancesScopedList;
import com.google.cloud.compute.v1.stub.TargetInstanceStub;
import com.google.cloud.compute.v1.stub.TargetInstanceStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class TargetInstanceClient
implements BackgroundResource {
    private final TargetInstanceSettings settings;
    private final TargetInstanceStub stub;

    public static final TargetInstanceClient create() throws IOException {
        return TargetInstanceClient.create(TargetInstanceSettings.newBuilder().build());
    }

    public static final TargetInstanceClient create(TargetInstanceSettings settings) throws IOException {
        return new TargetInstanceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final TargetInstanceClient create(TargetInstanceStub stub) {
        return new TargetInstanceClient(stub);
    }

    protected TargetInstanceClient(TargetInstanceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TargetInstanceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected TargetInstanceClient(TargetInstanceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TargetInstanceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TargetInstanceStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final AggregatedListTargetInstancesPagedResponse aggregatedListTargetInstances(ProjectName project) {
        AggregatedListTargetInstancesHttpRequest request = AggregatedListTargetInstancesHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.aggregatedListTargetInstances(request);
    }

    @BetaApi
    public final AggregatedListTargetInstancesPagedResponse aggregatedListTargetInstances(String project) {
        AggregatedListTargetInstancesHttpRequest request = AggregatedListTargetInstancesHttpRequest.newBuilder().setProject(project).build();
        return this.aggregatedListTargetInstances(request);
    }

    @BetaApi
    public final AggregatedListTargetInstancesPagedResponse aggregatedListTargetInstances(AggregatedListTargetInstancesHttpRequest request) {
        return (AggregatedListTargetInstancesPagedResponse)((Object)this.aggregatedListTargetInstancesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<AggregatedListTargetInstancesHttpRequest, AggregatedListTargetInstancesPagedResponse> aggregatedListTargetInstancesPagedCallable() {
        return this.stub.aggregatedListTargetInstancesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<AggregatedListTargetInstancesHttpRequest, TargetInstanceAggregatedList> aggregatedListTargetInstancesCallable() {
        return this.stub.aggregatedListTargetInstancesCallable();
    }

    @BetaApi
    public final Operation deleteTargetInstance(ProjectZoneTargetInstanceName targetInstance) {
        DeleteTargetInstanceHttpRequest request = DeleteTargetInstanceHttpRequest.newBuilder().setTargetInstance(targetInstance == null ? null : targetInstance.toString()).build();
        return this.deleteTargetInstance(request);
    }

    @BetaApi
    public final Operation deleteTargetInstance(String targetInstance) {
        DeleteTargetInstanceHttpRequest request = DeleteTargetInstanceHttpRequest.newBuilder().setTargetInstance(targetInstance).build();
        return this.deleteTargetInstance(request);
    }

    @BetaApi
    public final Operation deleteTargetInstance(DeleteTargetInstanceHttpRequest request) {
        return (Operation)this.deleteTargetInstanceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteTargetInstanceHttpRequest, Operation> deleteTargetInstanceCallable() {
        return this.stub.deleteTargetInstanceCallable();
    }

    @BetaApi
    public final TargetInstance getTargetInstance(ProjectZoneTargetInstanceName targetInstance) {
        GetTargetInstanceHttpRequest request = GetTargetInstanceHttpRequest.newBuilder().setTargetInstance(targetInstance == null ? null : targetInstance.toString()).build();
        return this.getTargetInstance(request);
    }

    @BetaApi
    public final TargetInstance getTargetInstance(String targetInstance) {
        GetTargetInstanceHttpRequest request = GetTargetInstanceHttpRequest.newBuilder().setTargetInstance(targetInstance).build();
        return this.getTargetInstance(request);
    }

    @BetaApi
    public final TargetInstance getTargetInstance(GetTargetInstanceHttpRequest request) {
        return (TargetInstance)this.getTargetInstanceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetTargetInstanceHttpRequest, TargetInstance> getTargetInstanceCallable() {
        return this.stub.getTargetInstanceCallable();
    }

    @BetaApi
    public final Operation insertTargetInstance(ProjectZoneName zone, TargetInstance targetInstanceResource) {
        InsertTargetInstanceHttpRequest request = InsertTargetInstanceHttpRequest.newBuilder().setZone(zone == null ? null : zone.toString()).setTargetInstanceResource(targetInstanceResource).build();
        return this.insertTargetInstance(request);
    }

    @BetaApi
    public final Operation insertTargetInstance(String zone, TargetInstance targetInstanceResource) {
        InsertTargetInstanceHttpRequest request = InsertTargetInstanceHttpRequest.newBuilder().setZone(zone).setTargetInstanceResource(targetInstanceResource).build();
        return this.insertTargetInstance(request);
    }

    @BetaApi
    public final Operation insertTargetInstance(InsertTargetInstanceHttpRequest request) {
        return (Operation)this.insertTargetInstanceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertTargetInstanceHttpRequest, Operation> insertTargetInstanceCallable() {
        return this.stub.insertTargetInstanceCallable();
    }

    @BetaApi
    public final ListTargetInstancesPagedResponse listTargetInstances(ProjectZoneName zone) {
        ListTargetInstancesHttpRequest request = ListTargetInstancesHttpRequest.newBuilder().setZone(zone == null ? null : zone.toString()).build();
        return this.listTargetInstances(request);
    }

    @BetaApi
    public final ListTargetInstancesPagedResponse listTargetInstances(String zone) {
        ListTargetInstancesHttpRequest request = ListTargetInstancesHttpRequest.newBuilder().setZone(zone).build();
        return this.listTargetInstances(request);
    }

    @BetaApi
    public final ListTargetInstancesPagedResponse listTargetInstances(ListTargetInstancesHttpRequest request) {
        return (ListTargetInstancesPagedResponse)((Object)this.listTargetInstancesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListTargetInstancesHttpRequest, ListTargetInstancesPagedResponse> listTargetInstancesPagedCallable() {
        return this.stub.listTargetInstancesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListTargetInstancesHttpRequest, TargetInstanceList> listTargetInstancesCallable() {
        return this.stub.listTargetInstancesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTargetInstancesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTargetInstancesHttpRequest, TargetInstanceList, TargetInstance, ListTargetInstancesPage, ListTargetInstancesFixedSizeCollection> {
        private ListTargetInstancesFixedSizeCollection(List<ListTargetInstancesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTargetInstancesFixedSizeCollection createEmptyCollection() {
            return new ListTargetInstancesFixedSizeCollection(null, 0);
        }

        protected ListTargetInstancesFixedSizeCollection createCollection(List<ListTargetInstancesPage> pages, int collectionSize) {
            return new ListTargetInstancesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTargetInstancesPage
    extends AbstractPage<ListTargetInstancesHttpRequest, TargetInstanceList, TargetInstance, ListTargetInstancesPage> {
        private ListTargetInstancesPage(PageContext<ListTargetInstancesHttpRequest, TargetInstanceList, TargetInstance> context, TargetInstanceList response) {
            super(context, (Object)response);
        }

        private static ListTargetInstancesPage createEmptyPage() {
            return new ListTargetInstancesPage(null, null);
        }

        protected ListTargetInstancesPage createPage(PageContext<ListTargetInstancesHttpRequest, TargetInstanceList, TargetInstance> context, TargetInstanceList response) {
            return new ListTargetInstancesPage(context, response);
        }

        public ApiFuture<ListTargetInstancesPage> createPageAsync(PageContext<ListTargetInstancesHttpRequest, TargetInstanceList, TargetInstance> context, ApiFuture<TargetInstanceList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTargetInstancesPagedResponse
    extends AbstractPagedListResponse<ListTargetInstancesHttpRequest, TargetInstanceList, TargetInstance, ListTargetInstancesPage, ListTargetInstancesFixedSizeCollection> {
        public static ApiFuture<ListTargetInstancesPagedResponse> createAsync(PageContext<ListTargetInstancesHttpRequest, TargetInstanceList, TargetInstance> context, ApiFuture<TargetInstanceList> futureResponse) {
            ApiFuture<ListTargetInstancesPage> futurePage = ListTargetInstancesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListTargetInstancesPage, ListTargetInstancesPagedResponse>(){

                public ListTargetInstancesPagedResponse apply(ListTargetInstancesPage input) {
                    return new ListTargetInstancesPagedResponse(input);
                }
            });
        }

        private ListTargetInstancesPagedResponse(ListTargetInstancesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTargetInstancesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListTargetInstancesFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListTargetInstancesHttpRequest, TargetInstanceAggregatedList, TargetInstancesScopedList, AggregatedListTargetInstancesPage, AggregatedListTargetInstancesFixedSizeCollection> {
        private AggregatedListTargetInstancesFixedSizeCollection(List<AggregatedListTargetInstancesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListTargetInstancesFixedSizeCollection createEmptyCollection() {
            return new AggregatedListTargetInstancesFixedSizeCollection(null, 0);
        }

        protected AggregatedListTargetInstancesFixedSizeCollection createCollection(List<AggregatedListTargetInstancesPage> pages, int collectionSize) {
            return new AggregatedListTargetInstancesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListTargetInstancesPage
    extends AbstractPage<AggregatedListTargetInstancesHttpRequest, TargetInstanceAggregatedList, TargetInstancesScopedList, AggregatedListTargetInstancesPage> {
        private AggregatedListTargetInstancesPage(PageContext<AggregatedListTargetInstancesHttpRequest, TargetInstanceAggregatedList, TargetInstancesScopedList> context, TargetInstanceAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListTargetInstancesPage createEmptyPage() {
            return new AggregatedListTargetInstancesPage(null, null);
        }

        protected AggregatedListTargetInstancesPage createPage(PageContext<AggregatedListTargetInstancesHttpRequest, TargetInstanceAggregatedList, TargetInstancesScopedList> context, TargetInstanceAggregatedList response) {
            return new AggregatedListTargetInstancesPage(context, response);
        }

        public ApiFuture<AggregatedListTargetInstancesPage> createPageAsync(PageContext<AggregatedListTargetInstancesHttpRequest, TargetInstanceAggregatedList, TargetInstancesScopedList> context, ApiFuture<TargetInstanceAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListTargetInstancesPagedResponse
    extends AbstractPagedListResponse<AggregatedListTargetInstancesHttpRequest, TargetInstanceAggregatedList, TargetInstancesScopedList, AggregatedListTargetInstancesPage, AggregatedListTargetInstancesFixedSizeCollection> {
        public static ApiFuture<AggregatedListTargetInstancesPagedResponse> createAsync(PageContext<AggregatedListTargetInstancesHttpRequest, TargetInstanceAggregatedList, TargetInstancesScopedList> context, ApiFuture<TargetInstanceAggregatedList> futureResponse) {
            ApiFuture<AggregatedListTargetInstancesPage> futurePage = AggregatedListTargetInstancesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListTargetInstancesPage, AggregatedListTargetInstancesPagedResponse>(){

                public AggregatedListTargetInstancesPagedResponse apply(AggregatedListTargetInstancesPage input) {
                    return new AggregatedListTargetInstancesPagedResponse(input);
                }
            });
        }

        private AggregatedListTargetInstancesPagedResponse(AggregatedListTargetInstancesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListTargetInstancesFixedSizeCollection.createEmptyCollection());
        }
    }
}

